/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.linkedin.tony.LocalizableResource;
import com.linkedin.tony.TFConfig;
import com.linkedin.tony.TonyConfigurationKeys;
import com.linkedin.tony.rpc.TaskInfo;
import com.linkedin.tony.tensorflow.JobContainerRequest;
import com.linkedin.tony.util.HdfsUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;

public class Utils {
    private static final Log LOG = LogFactory.getLog(Utils.class);
    private static final String WORKER_LOG_URL_TEMPLATE = "http://%s/node/containerlogs/%s/%s";

    public static boolean poll(Callable<Boolean> func, int interval, int timeout) {
        Preconditions.checkArgument((interval >= 0 ? 1 : 0) != 0, (Object)"Interval must be non-negative.");
        Preconditions.checkArgument((timeout >= 0 ? 1 : 0) != 0, (Object)"Timeout must be non-negative.");
        try {
            for (int remainingTime = timeout; timeout == 0 || remainingTime >= 0; remainingTime -= interval) {
                if (func.call().booleanValue()) {
                    LOG.info((Object)("Poll function finished within " + timeout + " seconds"));
                    return true;
                }
                Thread.sleep(interval * 1000);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Polled function threw exception.", (Throwable)e);
        }
        LOG.warn((Object)("Function didn't return true within " + timeout + " seconds."));
        return false;
    }

    public static <T> T pollTillNonNull(Callable<T> func, int interval, int timeout) {
        Preconditions.checkArgument((interval >= 0 ? 1 : 0) != 0, (Object)"Interval must be non-negative.");
        Preconditions.checkArgument((timeout >= 0 ? 1 : 0) != 0, (Object)"Timeout must be non-negative.");
        try {
            for (int remainingTime = timeout; timeout == 0 || remainingTime >= 0; remainingTime -= interval) {
                T ret = func.call();
                if (ret != null) {
                    LOG.info((Object)("pollTillNonNull function finished within " + timeout + " seconds"));
                    return ret;
                }
                Thread.sleep(interval * 1000);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"pollTillNonNull function threw exception", (Throwable)e);
        }
        LOG.warn((Object)("Function didn't return non-null within " + timeout + " seconds."));
        return null;
    }

    public static String parseMemoryString(String memory) {
        memory = memory.toLowerCase();
        int m = memory.indexOf(109);
        int g = memory.indexOf(103);
        if (-1 != m) {
            return memory.substring(0, m);
        }
        if (-1 != g) {
            return String.valueOf(Integer.parseInt(memory.substring(0, g)) * 1024);
        }
        return memory;
    }

    public static void zipFolder(final java.nio.file.Path sourceFolderPath, java.nio.file.Path zipPath) throws IOException {
        final ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipPath.toFile()));
        Files.walkFileTree(sourceFolderPath, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

            @Override
            public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                zos.putNextEntry(new ZipEntry(sourceFolderPath.relativize(file).toString()));
                Files.copy(file, zos);
                zos.closeEntry();
                return FileVisitResult.CONTINUE;
            }
        });
        zos.close();
    }

    public static void unzipArchive(String src, String dst) {
        LOG.info((Object)("Unzipping " + src + " to destination " + dst));
        try {
            ZipFile zipFile = new ZipFile(src);
            zipFile.extractAll(dst);
        }
        catch (ZipException e) {
            LOG.fatal((Object)("Failed to unzip " + src), (Throwable)e);
        }
    }

    public static void setCapabilityGPU(Resource resource, int gpuCount) {
        if (gpuCount <= 0) {
            return;
        }
        try {
            Method method = resource.getClass().getMethod("setResourceValue", String.class, Long.TYPE);
            method.invoke((Object)resource, "yarn.io/gpu", gpuCount);
        }
        catch (NoSuchMethodException nsme) {
            LOG.error((Object)("API to set GPU capability(setResourceValue) is not supported in this version (" + VersionInfo.getVersion() + ") of YARN. Please do not request GPU."));
            throw new RuntimeException(nsme);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.error((Object)"Failed to invoke 'setResourceValue' method to set GPU resources", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String constructUrl(String urlString) {
        if (!urlString.startsWith("http")) {
            return "http://" + urlString;
        }
        return urlString;
    }

    public static String constructContainerUrl(Container container) {
        return Utils.constructContainerUrl(container.getNodeHttpAddress(), container.getId());
    }

    public static String constructContainerUrl(String nodeAddress, ContainerId containerId) {
        try {
            return String.format(WORKER_LOG_URL_TEMPLATE, nodeAddress, containerId, UserGroupInformation.getCurrentUser().getShortUserName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void printTaskUrl(TaskInfo taskInfo, Log log) {
        log.info((Object)String.format("Logs for %s %s at: %s", taskInfo.getName(), taskInfo.getIndex(), taskInfo.getUrl()));
    }

    public static void printTonyPortalUrl(String portalUrl, String appId, Log log) {
        log.info((Object)String.format("Link for %s's events/metrics: %s/%s/%s", appId, portalUrl, "jobs", appId));
    }

    public static Map<String, String> parseKeyValue(String[] keyValues) {
        HashMap<String, String> keyValue = new HashMap<String, String>();
        if (keyValues == null) {
            return keyValue;
        }
        for (String kv : keyValues) {
            String trimmedKeyValue = kv.trim();
            int index = kv.indexOf(61);
            if (index == -1) {
                keyValue.put(trimmedKeyValue, "");
                continue;
            }
            String key = trimmedKeyValue.substring(0, index);
            String val = "";
            if (index < trimmedKeyValue.length() - 1) {
                val = trimmedKeyValue.substring(index + 1);
            }
            keyValue.put(key, val);
        }
        return keyValue;
    }

    public static Options getCommonOptions() {
        Options opts = new Options();
        opts.addOption("hdfs_classpath", true, "Path to jars on HDFS for workers.");
        opts.addOption("python_binary_path", true, "The relative path to python binary.");
        opts.addOption("python_venv", true, "The python virtual environment zip.");
        return opts;
    }

    public static int executeShell(String taskCommand, long timeout, Map<String, String> env) throws IOException, InterruptedException {
        LOG.info((Object)("Executing command: " + taskCommand));
        String executablePath = taskCommand.trim().split(" ")[0];
        File executable = new File(executablePath);
        if (!executable.canExecute() && !executable.setExecutable(true)) {
            LOG.warn((Object)("Failed to make " + executable + " executable"));
        }
        if (System.getenv("SKIP_HADOOP_PATH") == null) {
            taskCommand = "CLASSPATH=$(${HADOOP_HDFS_HOME}/bin/hadoop classpath --glob) " + taskCommand;
        }
        ProcessBuilder taskProcessBuilder = new ProcessBuilder("bash", "-c", taskCommand);
        taskProcessBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        taskProcessBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        taskProcessBuilder.environment().remove("MALLOC_ARENA_MAX");
        if (env != null) {
            taskProcessBuilder.environment().putAll(env);
        }
        Process taskProcess = taskProcessBuilder.start();
        if (timeout > 0L) {
            taskProcess.waitFor(timeout, TimeUnit.MILLISECONDS);
        } else {
            taskProcess.waitFor();
        }
        return taskProcess.exitValue();
    }

    public static String getCurrentHostName() {
        return System.getenv(ApplicationConstants.Environment.NM_HOST.name());
    }

    public static String getHostNameOrIpFromTokenConf(Configuration conf) throws YarnException, SocketException {
        boolean useIp = conf.getBoolean("hadoop.security.token.service.use_ip", true);
        String hostName = System.getenv(ApplicationConstants.Environment.NM_HOST.name());
        if (useIp) {
            InetAddress ip = NetUtils.getLocalInetAddress((String)hostName);
            if (ip == null) {
                throw new YarnException("Can't resolve the ip of " + hostName);
            }
            return ip.getHostAddress();
        }
        return hostName;
    }

    public static void addEnvironmentForResource(LocalResource resource, FileSystem fs, String envPrefix, Map<String, String> env) throws IOException {
        Path resourcePath = new Path(fs.getHomeDirectory(), resource.getResource().getFile());
        FileStatus resourceStatus = fs.getFileStatus(resourcePath);
        long resourceLength = resourceStatus.getLen();
        long resourceTimestamp = resourceStatus.getModificationTime();
        env.put(envPrefix + "_PATH", resourcePath.toString());
        env.put(envPrefix + "_LENGTH", Long.toString(resourceLength));
        env.put(envPrefix + "_TIMESTAMP", Long.toString(resourceTimestamp));
    }

    public static Map<String, JobContainerRequest> parseContainerRequests(Configuration conf) {
        Set<String> jobNames = Utils.getAllJobTypes(conf);
        Set untrackedJobTypes = Arrays.stream(Utils.getUntrackedJobTypes(conf)).collect(Collectors.toSet());
        HashMap<String, JobContainerRequest> containerRequests = new HashMap<String, JobContainerRequest>();
        int priority = 0;
        ArrayList<String> prepareStageTasks = new ArrayList<String>(conf.getTrimmedStringCollection("tony.application.prepare-stage"));
        ArrayList<String> trainingStageTasks = new ArrayList<String>(conf.getTrimmedStringCollection("tony.application.training-stage"));
        Utils.ensureStagedTasksIntegrity(prepareStageTasks, trainingStageTasks, jobNames);
        List tasksToDependOn = prepareStageTasks.stream().filter(x -> !untrackedJobTypes.contains(x)).collect(Collectors.toList());
        for (String jobName : jobNames) {
            int numInstances = conf.getInt(TonyConfigurationKeys.getInstancesKey(jobName), 0);
            String memoryString = conf.get(TonyConfigurationKeys.getResourceKey(jobName, "memory"), "2g");
            long memory = Long.parseLong(Utils.parseMemoryString(memoryString));
            int vCores = conf.getInt(TonyConfigurationKeys.getResourceKey(jobName, "vcores"), 1);
            int gpus = conf.getInt(TonyConfigurationKeys.getResourceKey(jobName, "gpus"), 0);
            String nodeLabel = conf.get(TonyConfigurationKeys.getNodeLabelKey(jobName));
            ArrayList<String> dependsOn = new ArrayList<String>();
            if (trainingStageTasks.contains(jobName)) {
                dependsOn.addAll(tasksToDependOn);
            }
            if (numInstances <= 0) continue;
            containerRequests.put(jobName, new JobContainerRequest(jobName, numInstances, memory, vCores, gpus, priority, nodeLabel, dependsOn));
            ++priority;
        }
        return containerRequests;
    }

    private static void ensureStagedTasksIntegrity(List<String> prepareStageTasks, List<String> trainingStageTasks, Set<String> allJobTypes) {
        if (prepareStageTasks.isEmpty() && !trainingStageTasks.isEmpty()) {
            prepareStageTasks.addAll(CollectionUtils.subtract(allJobTypes, trainingStageTasks));
            LOG.warn((Object)("Found no prepare stage tasks, auto-filling with: " + Arrays.toString(prepareStageTasks.toArray())));
        } else if (!prepareStageTasks.isEmpty() && trainingStageTasks.isEmpty()) {
            trainingStageTasks.addAll(CollectionUtils.subtract(allJobTypes, prepareStageTasks));
            LOG.warn((Object)("Found no training stage tasks, auto-filling with: " + Arrays.toString(trainingStageTasks.toArray())));
        } else if (prepareStageTasks.isEmpty() && trainingStageTasks.isEmpty()) {
            return;
        }
        if (prepareStageTasks.size() + trainingStageTasks.size() != allJobTypes.size()) {
            throw new IllegalArgumentException("TonY cannot parse application stage command, there are " + prepareStageTasks.size() + " prepare-stage tasks, " + trainingStageTasks.size() + " training-stage tasks.However, you have " + allJobTypes.size() + " total jobs in total");
        }
    }

    public static Set<String> getAllJobTypes(Configuration conf) {
        return conf.getValByRegex("tony\\.([a-z]+)\\.instances").keySet().stream().map(Utils::getTaskType).collect(Collectors.toSet());
    }

    public static int getNumTotalTasks(Configuration conf) {
        return Utils.getAllJobTypes(conf).stream().mapToInt(type -> conf.getInt(TonyConfigurationKeys.getInstancesKey(type), 0)).sum();
    }

    public static String getTaskType(String confKey) {
        Pattern instancePattern = Pattern.compile("tony\\.([a-z]+)\\.instances");
        Matcher instanceMatcher = instancePattern.matcher(confKey);
        if (instanceMatcher.matches()) {
            return instanceMatcher.group(1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isArchive(String path) {
        File f = new File(path);
        int fileSignature = 0;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(f, "r");
            fileSignature = raf.readInt();
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(raf);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(raf);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)raf);
        return fileSignature == 1347093252 || fileSignature == 1347093766 || fileSignature == 1347094280 || fileSignature == 1952805748 || fileSignature == 1970500705 || (fileSignature & 0xFFFF0000) == 529203200;
    }

    public static boolean renameFile(String oldName, String newName) {
        File oldFile = new File(oldName);
        File newFile = new File(newName);
        return oldFile.renameTo(newFile);
    }

    public static String constructTFConfig(String clusterSpec, String jobName, int taskIndex) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map spec = (Map)mapper.readValue(clusterSpec, (TypeReference)new TypeReference<Map<String, List<String>>>(){});
            TFConfig tfConfig = new TFConfig(spec, jobName, taskIndex);
            return mapper.writeValueAsString((Object)tfConfig);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String getClientResourcesPath(String appId, String fileName) {
        return String.format("%s-%s", appId, fileName);
    }

    public static void cleanupHDFSPath(Configuration hdfsConf, Path path) {
        try (FileSystem fs = FileSystem.get((Configuration)hdfsConf);){
            if (path != null && fs.exists(path)) {
                fs.delete(path, true);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to clean up HDFS path: " + path), (Throwable)e);
        }
    }

    public static void addResources(String[] resources, Map<String, LocalResource> resourcesMap, FileSystem fs) {
        if (null != resources) {
            for (String dir : resources) {
                Utils.addResource(dir, resourcesMap, fs);
            }
        }
    }

    public static void addResource(String path, Map<String, LocalResource> resourcesMap, FileSystem fs) {
        try {
            if (path != null) {
                LocalizableResource localizableResource = new LocalizableResource(path, fs);
                if (localizableResource.isDirectory()) {
                    FileStatus[] ls;
                    Path dirpath = localizableResource.getSourceFilePath();
                    for (FileStatus fileStatus : ls = fs.listStatus(dirpath)) {
                        if (fileStatus.isDirectory()) continue;
                        Utils.addResource(fileStatus.getPath().toString(), resourcesMap, fs);
                    }
                } else {
                    resourcesMap.put(localizableResource.getLocalizedFileName(), localizableResource.toLocalResource());
                }
            }
        }
        catch (IOException | ParseException exception) {
            LOG.error((Object)("Failed to add " + path + " to local resources."), exception);
        }
    }

    public static String buildRMUrl(Configuration yarnConf, String appId) {
        return "http://" + yarnConf.get("yarn.resourcemanager.webapp.address") + "/cluster/app/" + appId;
    }

    public static void printCompletedTrackedTasks(int completedTrackedTasks, int totalTrackedTasks) {
        if (completedTrackedTasks == totalTrackedTasks) {
            LOG.info((Object)("Completed all " + totalTrackedTasks + " tracked tasks."));
            return;
        }
        LOG.info((Object)("Completed " + completedTrackedTasks + " out of " + totalTrackedTasks + " tracked tasks."));
    }

    public static String parseClusterSpecForPytorch(String clusterSpec) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Map clusterSpecMap = (Map)objectMapper.readValue(clusterSpec, (TypeReference)new TypeReference<Map<String, List<String>>>(){});
        String chiefWorkerAddress = (String)((List)clusterSpecMap.get("worker")).get(0);
        if (chiefWorkerAddress == null) {
            LOG.error((Object)"Failed to get chief worker address from cluster spec.");
            return null;
        }
        return "tcp://" + chiefWorkerAddress;
    }

    public static String[] parseClusterSpecForMXNet(String clusterSpec) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Map clusterSpecMap = (Map)objectMapper.readValue(clusterSpec, (TypeReference)new TypeReference<Map<String, List<String>>>(){});
        String serverAddress = (String)((List)clusterSpecMap.get("scheduler")).get(0);
        LOG.info((Object)("Parsed ServerAddress " + serverAddress));
        if (serverAddress == null) {
            LOG.error((Object)"Failed to get server address from cluster spec.");
            return null;
        }
        String[] splitAddress = Utils.splitAddressPort(serverAddress);
        if (splitAddress == null) {
            LOG.error((Object)("Failed to split address: " + serverAddress));
            return null;
        }
        try {
            splitAddress[0] = Utils.resolveNameToIpAddress(splitAddress[0]);
        }
        catch (UnknownHostException e) {
            LOG.error((Object)("Cannot resolve ipaddress of " + splitAddress[0]));
            return null;
        }
        return splitAddress;
    }

    public static String resolveNameToIpAddress(String hostname) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(hostname);
        return address.getHostAddress();
    }

    public static void createDirIfNotExists(FileSystem fs, Path dir, FsPermission permission) {
        try {
            if (!fs.exists(dir)) {
                fs.mkdirs(dir, permission);
                fs.setPermission(dir, permission);
                return;
            }
            String warningMsg = "Directory " + dir + " already exists!";
            LOG.info((Object)warningMsg);
        }
        catch (IOException e) {
            String warningMsg = "Failed to create " + dir + ": " + e.toString();
            LOG.error((Object)warningMsg);
        }
    }

    public static String[] getUntrackedJobTypes(Configuration conf) {
        return conf.getStrings("tony.application.untracked.jobtypes", new String[]{"ps"});
    }

    public static boolean isJobTypeTracked(String taskName, Configuration tonyConf) {
        return !Arrays.asList(Utils.getUntrackedJobTypes(tonyConf)).contains(taskName);
    }

    public static String[] getStopOnFailureJobTypes(Configuration conf) {
        return conf.getStrings("tony.application.stop-on-failure-jobtypes", new String[]{""});
    }

    public static void uploadFileAndSetConfResources(Path hdfsPath, Path filePath, String fileName, Configuration tonyConf, FileSystem fs, LocalResourceType resourceType, String resourceKey) throws IOException {
        Path dst = new Path(hdfsPath, fileName);
        HdfsUtils.copySrcToDest(filePath, dst, tonyConf);
        fs.setPermission(dst, new FsPermission(504));
        String dstAddress = dst.toString();
        if (resourceType == LocalResourceType.ARCHIVE) {
            dstAddress = dstAddress + "#archive";
        }
        Utils.appendConfResources(resourceKey, dstAddress, tonyConf);
    }

    public static String[] splitAddressPort(String hostname) {
        String hostPattern = "([\\w\\.\\-]+):(\\d+)";
        Pattern p = Pattern.compile(hostPattern);
        Matcher m = p.matcher(hostname);
        if (m.matches()) {
            return new String[]{m.group(1), m.group(2)};
        }
        return null;
    }

    public static void appendConfResources(String key, String resource, Configuration tonyConf) {
        if (resource == null) {
            return;
        }
        String[] resources = tonyConf.getStrings(key);
        ArrayList<Object> updatedResources = new ArrayList<String>();
        if (resources != null) {
            updatedResources = new ArrayList<String>(Arrays.asList(resources));
        }
        updatedResources.add(resource);
        tonyConf.setStrings(key, updatedResources.toArray(new String[0]));
    }

    public static void initYarnConf(Configuration yarnConf) {
        Utils.addCoreConfs(yarnConf);
        Utils.addComponentConfs(yarnConf, "yarn-default.xml", "yarn-site.xml");
    }

    public static void initHdfsConf(Configuration hdfsConf) {
        Utils.addCoreConfs(hdfsConf);
        Utils.addComponentConfs(hdfsConf, "hdfs-default.xml", "hdfs-site.xml");
    }

    private static void addCoreConfs(Configuration conf) {
        URL coreDefault = Utils.class.getClassLoader().getResource("core-default.xml");
        if (coreDefault != null) {
            conf.addResource(coreDefault);
        }
        if (new File("core-site.xml").exists()) {
            conf.addResource(new Path("core-site.xml"));
        }
    }

    private static void addComponentConfs(Configuration conf, String defaultConfName, String siteConfName) {
        URL defaultConf = Utils.class.getClassLoader().getResource(defaultConfName);
        if (defaultConf != null) {
            conf.addResource(defaultConf);
        }
        if (new File(siteConfName).exists()) {
            conf.addResource(new Path(siteConfName));
        }
    }

    public static void extractResources() {
        File venvZip;
        if (new File("tony_src.zip").exists()) {
            LOG.info((Object)"Unpacking src directory..");
            Utils.unzipArchive("tony_src.zip", "./");
        }
        if ((venvZip = new File("venv.zip")).exists() && venvZip.isFile()) {
            LOG.info((Object)"Unpacking Python virtual environment.. ");
            Utils.unzipArchive("venv.zip", "venv");
        } else {
            LOG.info((Object)"No virtual environment uploaded.");
        }
    }

    public static Map<String, String> getContainerEnvForDocker(Configuration tonyConf, String jobType) {
        HashMap<String, String> containerEnv = new HashMap<String, String>();
        if (tonyConf.getBoolean("tony.docker.enabled", false)) {
            String imagePath = tonyConf.get(TonyConfigurationKeys.getContainerDockerKey());
            String jobImagePath = tonyConf.get(TonyConfigurationKeys.getDockerImageKey(jobType));
            if (jobImagePath != null) {
                imagePath = jobImagePath;
            }
            if (imagePath == null) {
                LOG.error((Object)("Docker is enabled but " + TonyConfigurationKeys.getContainerDockerKey() + " is not set."));
                return containerEnv;
            }
            Class<?> containerRuntimeClass = null;
            Class<?> dockerRuntimeClass = null;
            try {
                containerRuntimeClass = Class.forName("org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeConstants");
                dockerRuntimeClass = Class.forName("org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DockerLinuxContainerRuntime");
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("Docker runtime classes not found in this version (" + VersionInfo.getVersion() + ") of Hadoop."), (Throwable)e);
            }
            if (dockerRuntimeClass != null) {
                try {
                    String envContainerType = (String)containerRuntimeClass.getField("ENV_CONTAINER_TYPE").get(null);
                    String envDockerImage = (String)dockerRuntimeClass.getField("ENV_DOCKER_CONTAINER_IMAGE").get(null);
                    containerEnv.put(envContainerType, "docker");
                    containerEnv.put(envDockerImage, imagePath);
                }
                catch (NoSuchFieldException e) {
                    LOG.error((Object)("Field ENV_CONTAINER_TYPE or ENV_DOCKER_CONTAINER_IMAGE not found in " + containerRuntimeClass.getName()));
                }
                catch (IllegalAccessException e) {
                    LOG.error((Object)"Unable to access ENV_CONTAINER_TYPE or ENV_DOCKER_CONTAINER_IMAGE fields.");
                }
            }
        }
        return containerEnv;
    }

    public static Map<String, String> linksToBeDisplayedOnPage(String jobId) {
        TreeMap<String, String> titleAndLinks = new TreeMap<String, String>();
        if (Objects.nonNull(jobId)) {
            titleAndLinks.put("Logs", "/logs/" + jobId);
            titleAndLinks.put("Events", "/jobs/" + jobId);
        }
        return titleAndLinks;
    }

    private Utils() {
    }
}

