/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony.tensorflow;

import com.google.common.base.Preconditions;
import com.linkedin.tony.rpc.TaskInfo;
import com.linkedin.tony.rpc.impl.TaskStatus;
import com.linkedin.tony.tensorflow.JobContainerRequest;
import com.linkedin.tony.util.Utils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class TonySession {
    private static final Log LOG = LogFactory.getLog(TonySession.class);
    private Configuration tonyConf;
    private Map<String, JobContainerRequest> containerRequests;
    public int sessionId = 0;
    private Map<String, TonyTask[]> jobTasks = new ConcurrentHashMap<String, TonyTask[]>();
    private FinalApplicationStatus sessionFinalStatus = FinalApplicationStatus.UNDEFINED;
    private String sessionFinalMessage = null;
    private String jvmArgs;
    private boolean trainingFinished = false;
    private int numExpectedTasks = 0;
    private ConcurrentHashMap<ContainerId, TonyTask> containerIdMap = new ConcurrentHashMap();

    public String getTaskCommand() {
        StringBuilder cmd = new StringBuilder();
        cmd.append("$JAVA_HOME/bin/java ").append(this.jvmArgs).append(" com.linkedin.tony.TaskExecutor");
        return cmd.toString();
    }

    public TonySession() {
    }

    private TonySession(Builder builder) {
        this.containerRequests = Utils.parseContainerRequests(builder.tonyConf);
        this.jvmArgs = builder.jvmArgs;
        this.tonyConf = builder.tonyConf;
        for (Map.Entry<String, JobContainerRequest> entry : this.containerRequests.entrySet()) {
            this.jobTasks.put(entry.getKey(), new TonyTask[entry.getValue().getNumInstances()]);
        }
    }

    public Map<String, TonyTask[]> getTonyTasks() {
        return this.jobTasks;
    }

    public boolean isTrainingFinished() {
        return this.trainingFinished;
    }

    public void setResources(Configuration yarnConf, Configuration hdfsConf, Map<String, LocalResource> localResources, Map<String, String> shellEnv, String hdfsClasspathDir) {
        Map<String, String> env = System.getenv();
        String tonyConfPath = env.get("TONY_CONF_PATH");
        long tonyConfTimestamp = Long.parseLong(env.get("TONY_CONF_TIMESTAMP"));
        long tonyConfLength = Long.parseLong(env.get("TONY_CONF_LENGTH"));
        LocalResource tonyConfResource = LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromURI((URI)URI.create(tonyConfPath)), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PRIVATE, (long)tonyConfLength, (long)tonyConfTimestamp);
        localResources.put("tony-final.xml", tonyConfResource);
        try {
            if (hdfsClasspathDir != null) {
                FileSystem fs = FileSystem.get((URI)new URI(hdfsClasspathDir), (Configuration)hdfsConf);
                Utils.addResource(hdfsClasspathDir, localResources, fs);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        StringBuilder classPathEnv = new StringBuilder(ApplicationConstants.Environment.CLASSPATH.$$()).append("<CPS>").append("./*");
        for (String c : yarnConf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_CROSS_PLATFORM_APPLICATION_CLASSPATH)) {
            classPathEnv.append("<CPS>");
            classPathEnv.append(c.trim());
        }
        shellEnv.put("CLASSPATH", classPathEnv.toString());
    }

    public List<JobContainerRequest> getContainersRequests() {
        ArrayList<JobContainerRequest> requests = new ArrayList<JobContainerRequest>();
        block0: for (Map.Entry<String, TonyTask[]> entry : this.jobTasks.entrySet()) {
            TonyTask[] tasks;
            for (TonyTask task : tasks = entry.getValue()) {
                if (task != null) continue;
                requests.add(this.getContainerRequestForType(entry.getKey()));
                continue block0;
            }
        }
        return requests;
    }

    public JobContainerRequest getContainerRequestForType(String jobType) {
        return this.containerRequests.get(jobType);
    }

    public boolean allTasksScheduled() {
        for (TonyTask[] tasks : this.jobTasks.values()) {
            for (TonyTask task : tasks) {
                if (task != null && task.getTaskInfo() != null) continue;
                return false;
            }
        }
        return true;
    }

    public int getTotalTasks() {
        return this.jobTasks.values().stream().reduce(0, (currTotal, taskArr) -> currTotal + ((TonyTask[])taskArr).length, (count1, count2) -> count1 + count2);
    }

    public int getTotalTrackedTasks() {
        return this.jobTasks.entrySet().stream().filter(entry -> Utils.isJobTypeTracked((String)entry.getKey(), this.tonyConf)).mapToInt(entry -> ((TonyTask[])entry.getValue()).length).sum();
    }

    public int getNumCompletedTasks() {
        return (int)this.jobTasks.values().stream().flatMap(arr -> Arrays.stream(arr)).filter(task -> task != null && task.isCompleted()).count();
    }

    public int getNumCompletedTrackedTasks() {
        return (int)this.jobTasks.entrySet().stream().filter(entry -> Utils.isJobTypeTracked((String)entry.getKey(), this.tonyConf)).flatMap(entry -> Arrays.stream((Object[])entry.getValue())).filter(task -> task != null && task.isCompleted()).count();
    }

    public int getNumFailedTasks() {
        return (int)this.jobTasks.values().stream().flatMap(arr -> Arrays.stream(arr)).filter(task -> task != null && task.isFailed()).count();
    }

    public int getNumExpectedTasks() {
        return this.numExpectedTasks;
    }

    public void addNumExpectedTask(int numExpectedTasksToAdd) {
        this.numExpectedTasks += numExpectedTasksToAdd;
    }

    public synchronized TonyTask getAndInitMatchingTaskByPriority(int priority) {
        for (Map.Entry<String, JobContainerRequest> entry : this.containerRequests.entrySet()) {
            String jobName = entry.getKey();
            if (entry.getValue().getPriority() != priority) {
                LOG.debug((Object)("Ignoring jobname {" + jobName + "} as priority doesn't match"));
                continue;
            }
            TonyTask[] tasks = this.jobTasks.get(jobName);
            for (int i = 0; i < tasks.length; ++i) {
                if (tasks[i] != null) continue;
                tasks[i] = new TonyTask(jobName, String.valueOf(i), this.sessionId, System.currentTimeMillis());
                return tasks[i];
            }
        }
        return null;
    }

    public Map<String, List<String>> getClusterSpec() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry<String, TonyTask[]> entry : this.jobTasks.entrySet()) {
            String jobName = entry.getKey();
            TonyTask[] tasks = entry.getValue();
            ArrayList<String> builder = new ArrayList<String>();
            for (TonyTask task : tasks) {
                if (task == null) continue;
                String hostPort = task.getHostPort();
                builder.add(hostPort);
            }
            map.put(jobName, builder);
        }
        return map;
    }

    public void onTaskCompleted(String jobName, String jobIndex, int exitCode) {
        LOG.info((Object)String.format("Job %s:%s exited with %d", jobName, jobIndex, exitCode));
        TonyTask task = this.getTask(jobName, jobIndex);
        Preconditions.checkNotNull((Object)task);
        task.setExitStatus(exitCode);
        if (exitCode != 0 && exitCode != -105 && (this.isChief(jobName, jobIndex) || this.shouldStopOnFailure(jobName) || this.isFailOnWorkerFailure())) {
            this.trainingFinished = true;
            this.setFinalStatus(FinalApplicationStatus.FAILED, "Exit status: " + exitCode);
        }
    }

    public void updateSessionStatus() {
        int failureCount = 0;
        if (this.getFinalStatus() == FinalApplicationStatus.FAILED) {
            return;
        }
        for (Map.Entry<String, TonyTask[]> entry : this.jobTasks.entrySet()) {
            String jobName = entry.getKey();
            TonyTask[] tasks = entry.getValue();
            if (!Utils.isJobTypeTracked(jobName, this.tonyConf)) continue;
            for (TonyTask task : tasks) {
                if (task == null) {
                    String msg = "Job is null, this should not happen.";
                    LOG.error((Object)msg);
                    this.setFinalStatus(FinalApplicationStatus.FAILED, msg);
                    return;
                }
                boolean isCompleted = task.isCompleted();
                if (!isCompleted) {
                    String msg = "Job " + task + " hasn't finished yet.";
                    LOG.error((Object)msg);
                    this.setFinalStatus(FinalApplicationStatus.FAILED, msg);
                    return;
                }
                int exitStatus = task.getExitStatus();
                if (exitStatus == 0) continue;
                ++failureCount;
            }
        }
        if (failureCount > 0) {
            if (this.isFailOnWorkerFailure() || failureCount >= this.getTotalTrackedTasks()) {
                this.setFinalStatus(FinalApplicationStatus.FAILED, "At least one job task exited with non-zero status, failedCnt=" + failureCount);
            } else {
                LOG.info((Object)("Session completed with some worker jobs failure, failedCnt=" + failureCount + " and TotalTrackedTasks=" + this.getTotalTrackedTasks() + ", setting final status SUCCEEDED."));
                this.setFinalStatus(FinalApplicationStatus.SUCCEEDED, "Training completed with some worker jobs failure, failedCnt=" + failureCount);
            }
        } else {
            LOG.info((Object)"Session completed with no job failures, setting final status SUCCEEDED.");
            this.setFinalStatus(FinalApplicationStatus.SUCCEEDED, null);
        }
    }

    public String getFinalMessage() {
        return this.sessionFinalMessage;
    }

    public FinalApplicationStatus getFinalStatus() {
        return this.sessionFinalStatus;
    }

    public void setFinalStatus(FinalApplicationStatus status, String message) {
        this.sessionFinalStatus = status;
        this.sessionFinalMessage = message;
    }

    private TonyTask getTask(String jobName, String taskIndex) {
        for (Map.Entry<String, TonyTask[]> entry : this.jobTasks.entrySet()) {
            TonyTask[] tasks;
            for (TonyTask task : tasks = entry.getValue()) {
                if (task == null) continue;
                String job = task.getJobName();
                String index = task.getTaskIndex();
                if (!job.equals(jobName) || !index.equals(taskIndex)) continue;
                return task;
            }
        }
        return null;
    }

    public boolean isChief(String jobName, String index) {
        return jobName.equals("chief") || !this.jobTasks.containsKey("chief") && jobName.equals("worker") && index.equals("0");
    }

    public boolean shouldStopOnFailure(String jobName) {
        return Arrays.asList(Utils.getStopOnFailureJobTypes(this.tonyConf)).contains(jobName);
    }

    public boolean isFailOnWorkerFailure() {
        return this.tonyConf.getBoolean("tony.application.fail-on-worker-failure-enabled", false);
    }

    public TonyTask getTask(ContainerId containerId) {
        return this.containerIdMap.get(containerId);
    }

    public TonyTask getTask(String taskId) {
        try {
            String[] tSplit = taskId.split(":");
            return this.jobTasks.get(tSplit[0])[Integer.parseInt(tSplit[1])];
        }
        catch (Exception e) {
            return null;
        }
    }

    public class TonyTask {
        private final String jobName;
        private final String taskIndex;
        private final int sessionId;
        private String host;
        private int port = -1;
        private TaskInfo taskInfo;
        private final long startTime;
        private Container container;
        private int exitStatus = -1;
        boolean completed = false;

        public String getJobName() {
            return this.jobName;
        }

        public int getSessionId() {
            return this.sessionId;
        }

        public String getTaskIndex() {
            return this.taskIndex;
        }

        public String getHost() {
            return this.host;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public Container getContainer() {
            return this.container;
        }

        public void setContainer(Container container) {
            this.container = container;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public boolean isFailed() {
            return this.taskInfo.getStatus() == TaskStatus.FAILED;
        }

        String getHostPort() {
            return String.format("%s:%d", this.host, this.port < 0 ? 0 : this.port);
        }

        public void setHostPort(String hostPort) {
            this.host = hostPort.split(":")[0];
            this.port = Integer.parseInt(hostPort.split(":")[1]);
        }

        synchronized int getExitStatus() {
            return this.exitStatus;
        }

        synchronized void setExitStatus(int status) {
            if (this.exitStatus == -1) {
                this.exitStatus = status;
                switch (status) {
                    case 0: {
                        this.taskInfo.setStatus(TaskStatus.SUCCEEDED);
                        break;
                    }
                    case -105: {
                        this.taskInfo.setStatus(TaskStatus.FINISHED);
                        break;
                    }
                    default: {
                        this.taskInfo.setStatus(TaskStatus.FAILED);
                    }
                }
                this.completed = true;
            }
        }

        public TaskInfo getTaskInfo() {
            return this.taskInfo;
        }

        public void setTaskInfo(Container container) {
            this.taskInfo = new TaskInfo(this.jobName, this.taskIndex, Utils.constructContainerUrl(container));
        }

        TonyTask(String jobName, String taskIndex, int sessionId, long startTime) {
            this.jobName = jobName;
            this.taskIndex = taskIndex;
            this.sessionId = sessionId;
            this.startTime = startTime;
        }

        public void addContainer(Container container) {
            this.setContainer(container);
            TonySession.this.containerIdMap.put(container.getId(), this);
        }

        public String getId() {
            return this.jobName + ":" + this.taskIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TonyTask tonyTask = (TonyTask)o;
            return Objects.equals(this.jobName, tonyTask.jobName) && Objects.equals(this.taskIndex, tonyTask.taskIndex);
        }

        public int hashCode() {
            return Objects.hash(this.jobName, this.taskIndex);
        }

        public String toString() {
            return this.getId();
        }
    }

    public static class Builder {
        private String jvmArgs;
        private Configuration tonyConf;

        public TonySession build() {
            return new TonySession(this);
        }

        public Builder setTaskExecutorJVMArgs(String jvmArgs) {
            this.jvmArgs = jvmArgs;
            return this;
        }

        public Builder setTonyConf(Configuration tonyConf) {
            this.tonyConf = tonyConf;
            return this;
        }
    }

    public static enum TaskType {
        TASK_TYPE_CHIEF,
        TASK_TYPE_PARAMETER_SERVER,
        TASK_TYPE_OTHERS;

    }
}

