/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony.rpc.impl;

import com.linkedin.tony.events.Metric;
import com.linkedin.tony.rpc.MetricsRpc;
import com.linkedin.tony.rpc.impl.MetricsWritable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.VersionedProtocol;

public class MetricsRpcServer
implements MetricsRpc {
    private static final Log LOG = LogFactory.getLog(MetricsRpcServer.class);
    private Map<String, Map<Integer, MetricsWritable>> metricsMap = new HashMap<String, Map<Integer, MetricsWritable>>();

    public List<Metric> getMetrics(String taskType, int taskIndex) {
        if (!this.metricsMap.containsKey(taskType) || !this.metricsMap.get(taskType).containsKey(taskIndex)) {
            LOG.warn((Object)("No metrics for " + taskType + " " + taskIndex + "!"));
            return Collections.EMPTY_LIST;
        }
        return this.metricsMap.get(taskType).get(taskIndex).getMetricsAsList();
    }

    @Override
    public void updateMetrics(String taskType, int taskIndex, MetricsWritable metrics) {
        if (!this.metricsMap.containsKey(taskType)) {
            this.metricsMap.put(taskType, new HashMap());
        }
        this.metricsMap.get(taskType).put(taskIndex, metrics);
    }

    public long getProtocolVersion(String protocol, long clientVersion) {
        return 1L;
    }

    public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        return ProtocolSignature.getProtocolSignature((VersionedProtocol)this, (String)protocol, (long)clientVersion, (int)clientMethodsHash);
    }
}

