/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony.models;

import com.linkedin.tony.util.Utils;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public class JobMetadata {
    private String id;
    private String jobLink;
    private String configLink;
    private String rmLink;
    private long started;
    private long completed;
    private String status;
    private String user;

    private JobMetadata(Builder builder) {
        this.id = builder.id;
        this.jobLink = "/jobs/" + this.id;
        this.configLink = "/config/" + this.id;
        this.rmLink = Utils.buildRMUrl(builder.conf, builder.id);
        this.started = builder.started;
        this.completed = builder.completed;
        this.status = builder.status;
        this.user = builder.user;
    }

    public static JobMetadata newInstance(YarnConfiguration conf, String histFileName) {
        String histFileNoExt = histFileName.substring(0, histFileName.indexOf(46));
        String[] metadata = histFileNoExt.split("-");
        Builder metadataBuilder = new Builder().setId(metadata[0]).setStarted(Long.parseLong(metadata[1])).setConf((Configuration)conf);
        if (histFileName.endsWith("inprogress")) {
            metadataBuilder.setUser(metadata[2]).setStatus("RUNNING");
            return metadataBuilder.build();
        }
        metadataBuilder.setCompleted(Long.parseLong(metadata[2])).setUser(metadata[3]).setStatus(metadata[4]);
        return metadataBuilder.build();
    }

    public String getId() {
        return this.id;
    }

    public String getJobLink() {
        return this.jobLink;
    }

    public String getConfigLink() {
        return this.configLink;
    }

    public String getRMLink() {
        return this.rmLink;
    }

    public Date getStartedDate() {
        return new Date(this.started);
    }

    public long getStarted() {
        return this.started;
    }

    public Date getCompletedDate() {
        return new Date(this.completed);
    }

    public long getCompleted() {
        return this.completed;
    }

    public String getStatus() {
        return this.status;
    }

    public String getUser() {
        return this.user;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String toString() {
        return "Metadata{ id: " + this.id + ", joblink: " + this.jobLink + ", configlink: " + this.configLink + ", rmLink: " + this.rmLink + ", dateStarted: " + new Date(this.started) + ", started: " + this.started + ", dateCompleted: " + new Date(this.completed) + ", status: " + this.status + ", user: " + this.user + "}";
    }

    public static class Builder {
        private String id = "";
        private long started = -1L;
        private long completed = -1L;
        private String status = "";
        private String user = "";
        private Configuration conf = null;

        public JobMetadata build() {
            return new JobMetadata(this);
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder setStarted(long startTime) {
            this.started = startTime;
            return this;
        }

        public Builder setCompleted(long completed) {
            this.completed = completed;
            return this;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }
    }
}

