/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony.models;

import com.linkedin.tony.events.ApplicationInited;
import com.linkedin.tony.events.Event;
import com.linkedin.tony.events.TaskStarted;
import com.linkedin.tony.util.JobLogMetaData;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public class JobLog {
    private static final Log LOG = LogFactory.getLog(JobLog.class);
    private static final String LOG_URL_SCHEMA = "http://{0}:{1}/node/containerlogs/{2}/{3}";
    private static final String YARN_NODEMANAGER_WEBAPP_ADDRESS = "yarn.nodemanager.webapp.address";
    private static final String IP_ADDRESS_PORT_DELIMITER = ":";
    private String hostAddress;
    private String containerID;
    private String logLink;

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    public String getContainerID() {
        return this.containerID;
    }

    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    public String getLogLink() {
        return this.logLink;
    }

    public void setLogLink(String logLink) {
        this.logLink = logLink;
    }

    public static JobLog convertEventToJobLog(Event e, JobLogMetaData jobLogMetaData) {
        JobLog wrapper = new JobLog();
        Pair<String, String> nodeIdContainerId = JobLog.processEventForNodeIdContainerId(e);
        if (JobLog.isParameterValid(nodeIdContainerId)) {
            wrapper.setContainerID((String)nodeIdContainerId.getRight());
            wrapper.setHostAddress((String)nodeIdContainerId.getLeft());
            wrapper.setLogLink(JobLog.createLogLink(nodeIdContainerId, jobLogMetaData.getYarnConfiguration(), jobLogMetaData.getUserName()));
        }
        return wrapper;
    }

    private static Pair<String, String> processEventForNodeIdContainerId(Event e) {
        Pair nodeIDContainerID = null;
        switch (e.getType()) {
            case APPLICATION_INITED: {
                nodeIDContainerID = Pair.of((Object)((ApplicationInited)((Object)e.getEvent())).getHost(), (Object)((ApplicationInited)((Object)e.getEvent())).getContainerID());
                break;
            }
            case TASK_STARTED: {
                nodeIDContainerID = Pair.of((Object)((TaskStarted)((Object)e.getEvent())).getHost(), (Object)((TaskStarted)((Object)e.getEvent())).getContainerID());
                break;
            }
            default: {
                LOG.debug((Object)(" Event type doesnt have node id  and container id information " + e.getType().name()));
            }
        }
        return nodeIDContainerID;
    }

    private static String createLogLink(Pair<String, String> nodeIdContainerId, YarnConfiguration yarnConfiguration, String userName) {
        String logLink = "NA";
        if (JobLog.isParameterValid(userName)) {
            LOG.debug((Object)" Valid values in yarn configuration and username");
            String nodeManagerWebAppAddress = JobLog.getNodeMgrWebAppAddress(yarnConfiguration);
            if (JobLog.isParameterValid(nodeManagerWebAppAddress)) {
                LOG.debug((Object)("Create container log URL with following information  " + nodeManagerWebAppAddress + " " + (String)nodeIdContainerId.getLeft() + " " + (String)nodeIdContainerId.getRight()));
                logLink = JobLog.processForLogLink(nodeManagerWebAppAddress, nodeIdContainerId, userName);
            }
        }
        return logLink;
    }

    private static String getNodeMgrWebAppAddress(YarnConfiguration yarnConfiguration) {
        String yarnNodeManagerWebAppAddress = null;
        if (JobLog.isParameterValid(yarnConfiguration)) {
            yarnNodeManagerWebAppAddress = yarnConfiguration.get(YARN_NODEMANAGER_WEBAPP_ADDRESS);
            if (JobLog.isParameterValid(yarnNodeManagerWebAppAddress)) {
                LOG.debug((Object)("There is sufficient information to construct container url " + yarnNodeManagerWebAppAddress));
            }
        }
        return yarnNodeManagerWebAppAddress;
    }

    private static boolean isParameterValid(Object ... parameters) {
        return Stream.of(parameters).allMatch(Objects::nonNull);
    }

    private static String processForLogLink(String nodeManagerWebAppAddress, Pair<String, String> nodeIdContainerId, String userName) {
        String[] nodeMgrAddress = nodeManagerWebAppAddress.split(IP_ADDRESS_PORT_DELIMITER);
        if (nodeMgrAddress.length >= NodeWebAddressSchema.MAX.ordinal()) {
            String nodeMgrPort = nodeMgrAddress[NodeWebAddressSchema.PORT.ordinal()];
            String logLink = MessageFormat.format(LOG_URL_SCHEMA, nodeIdContainerId.getLeft(), nodeMgrPort, nodeIdContainerId.getRight(), userName);
            LOG.info((Object)(" Log link URL " + logLink));
            return logLink;
        }
        LOG.error((Object)(" Node mgr address is incorrect " + nodeManagerWebAppAddress));
        return "NA";
    }

    private static enum NodeWebAddressSchema {
        IP_ADDRESS,
        PORT,
        MAX;

    }
}

