/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony.events;

import com.google.common.annotations.VisibleForTesting;
import com.linkedin.tony.events.Event;
import com.linkedin.tony.models.JobMetadata;
import com.linkedin.tony.util.HistoryFileUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class EventHandler
extends Thread {
    private static final Log LOG = LogFactory.getLog(EventHandler.class);
    private volatile boolean isStopped = false;
    private BlockingQueue<Event> eventQueue;
    private Path finalHistFile = null;
    private Path inProgressHistFile = null;
    private DatumWriter<Event> eventWriter = new SpecificDatumWriter();
    private DataFileWriter<Event> dataFileWriter = new DataFileWriter(this.eventWriter);
    private OutputStream out;
    private FileSystem myFs;

    public EventHandler(FileSystem fs, BlockingQueue<Event> q) {
        this.eventQueue = q;
        this.myFs = fs;
    }

    public void setUpThread(Path intermDir, JobMetadata metadata) {
        if (intermDir == null) {
            return;
        }
        this.inProgressHistFile = new Path(intermDir, HistoryFileUtils.generateFileName(metadata));
        try {
            this.out = this.myFs.create(this.inProgressHistFile);
            this.dataFileWriter.create(Event.SCHEMA$, this.out);
            LOG.info((Object)("Writing events to " + this.inProgressHistFile));
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to set up writer", (Throwable)e);
        }
    }

    @VisibleForTesting
    void writeEvent(BlockingQueue<Event> queue, DataFileWriter<Event> writer) {
        Event event = null;
        try {
            event = queue.take();
            writer.append((Object)event);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to append event " + (Object)((Object)event)), (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.info((Object)"Event writer interrupted");
        }
    }

    @VisibleForTesting
    void drainQueue(BlockingQueue<Event> queue, DataFileWriter<Event> writer) {
        LOG.info((Object)"Draining queue");
        while (!this.eventQueue.isEmpty()) {
            try {
                Event event = (Event)((Object)queue.poll());
                writer.append((Object)event);
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to drain queue", (Throwable)e);
            }
        }
    }

    public void emitEvent(Event event) {
        try {
            LOG.info((Object)("Emitting event: " + (Object)((Object)event)));
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Failed to add event " + (Object)((Object)event) + " to event queue"), (Throwable)e);
        }
    }

    @Override
    public void run() {
        LOG.info((Object)"Checking if jhist file is ready...");
        if (this.inProgressHistFile == null) {
            LOG.warn((Object)"inProgressHistFile is null");
            return;
        }
        while (!this.isStopped && !Thread.currentThread().isInterrupted()) {
            this.writeEvent(this.eventQueue, this.dataFileWriter);
        }
        this.drainQueue(this.eventQueue, this.dataFileWriter);
    }

    private void cleanUp() {
        try {
            this.dataFileWriter.close();
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to close writer", (Throwable)e);
        }
    }

    private void moveInProgressToFinal() {
        try {
            LOG.info((Object)("Moving " + this.inProgressHistFile + " to " + this.finalHistFile + "."));
            if (!this.myFs.rename(this.inProgressHistFile, this.finalHistFile)) {
                LOG.error((Object)("Failed to move " + this.inProgressHistFile + " to " + this.finalHistFile));
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to rename to jhist file", (Throwable)e);
        }
    }

    public void stop(Path intermDir, JobMetadata metadata) {
        if (this.inProgressHistFile == null) {
            LOG.warn((Object)"inProgressHistFile is null");
            return;
        }
        this.finalHistFile = new Path(intermDir, HistoryFileUtils.generateFileName(metadata));
        LOG.info((Object)"Stopping event handler thread");
        this.isStopped = true;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Encountered interruption while stopping event handler thread", (Throwable)e);
        }
        this.cleanUp();
        this.moveInProgressToFinal();
    }
}

