/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.linkedin.tony.TonyConfigurationKeys;
import com.linkedin.tony.rpc.MetricWritable;
import com.linkedin.tony.rpc.MetricsRpc;
import com.linkedin.tony.rpc.impl.MetricsWritable;
import com.linkedin.tony.util.gpu.GpuDeviceInformation;
import com.linkedin.tony.util.gpu.GpuDiscoverer;
import com.linkedin.tony.util.gpu.GpuInfoException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;

class TaskMonitor
implements Runnable {
    private static final Log LOG = LogFactory.getLog(TaskMonitor.class);
    private String taskType;
    private int taskIndex;
    private MetricsRpc metricsRpcClient;
    private ResourceCalculatorProcessTree resourceCalculator;
    private GpuDiscoverer gpuDiscoverer;
    public static final List<String> METRICS_TO_COLLECT = ImmutableList.of((Object)"MAX_MEMORY_BYTES", (Object)"AVG_MEMORY_BYTES", (Object)"MAX_GPU_UTILIZATION", (Object)"AVG_GPU_UTILIZATION", (Object)"MAX_GPU_FB_MEMORY_USAGE", (Object)"AVG_GPU_FB_MEMORY_USAGE", (Object)"MAX_GPU_MAIN_MEMORY_USAGE", (Object)"AVG_GPU_MAIN_MEMORY_USAGE");
    public static final int MAX_MEMORY_BYTES_INDEX = 0;
    public static final int AVG_MEMORY_BYTES_INDEX = 1;
    public static final int MAX_GPU_UTILIZATION_INDEX = 2;
    public static final int AVG_GPU_UTILIZATION_INDEX = 3;
    public static final int MAX_GPU_FB_MEMORY_USAGE_INDEX = 4;
    public static final int AVG_GPU_FB_MEMORY_USAGE_INDEX = 5;
    public static final int MAX_GPU_MAIN_MEMORY_USAGE_INDEX = 6;
    public static final int AVG_GPU_MAIN_MEMORY_USAGE_INDEX = 7;
    private Boolean isGpuMachine;
    private Boolean gpuMetricsEnabled;
    private MetricsWritable metrics = new MetricsWritable(METRICS_TO_COLLECT.size());
    @VisibleForTesting
    protected int numRefreshes = 0;

    TaskMonitor(String taskType, int taskIndex, Configuration yarnConf, Configuration tonyConf, MetricsRpc metricsRpcClient) {
        this.taskType = taskType;
        this.taskIndex = taskIndex;
        this.initMetrics();
        this.metricsRpcClient = metricsRpcClient;
        String pid = System.getenv("JVM_PID");
        LOG.info((Object)("Task pid is: " + pid));
        this.isGpuMachine = this.checkIsGpuMachine(tonyConf);
        this.gpuMetricsEnabled = tonyConf.getBoolean("tony.task.gpu-metrics.enabled", true);
        this.resourceCalculator = ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)pid, null, (Configuration)yarnConf);
        if (this.isGpuMachine.booleanValue() && this.gpuMetricsEnabled.booleanValue()) {
            this.gpuDiscoverer = GpuDiscoverer.getInstance();
            this.gpuDiscoverer.initialize(yarnConf);
        }
    }

    @VisibleForTesting
    void initMetrics() {
        for (int i = 0; i < METRICS_TO_COLLECT.size(); ++i) {
            this.metrics.setMetric(i, new MetricWritable(METRICS_TO_COLLECT.get(i), -1.0));
        }
    }

    private boolean checkIsGpuMachine(Configuration conf) {
        int numWorkerGpus = conf.getInt(TonyConfigurationKeys.getResourceKey(this.taskType, "gpus"), 0);
        LOG.info((Object)("Number of GPUs requested for " + this.taskType + ": " + numWorkerGpus));
        return numWorkerGpus > 0;
    }

    @Override
    public void run() {
        this.refreshMetrics();
        try {
            this.metricsRpcClient.updateMetrics(this.taskType, this.taskIndex, this.metrics);
        }
        catch (Exception e) {
            LOG.error((Object)"Encountered exception updating metrics", (Throwable)e);
        }
    }

    private void refreshMetrics() {
        this.refreshMemoryBytesMetrics();
        if (this.isGpuMachine.booleanValue() && this.gpuMetricsEnabled.booleanValue()) {
            this.refreshGPUMetrics();
        }
        ++this.numRefreshes;
    }

    private void refreshMemoryBytesMetrics() {
        this.resourceCalculator.updateProcessTree();
        double memoryBytes = this.resourceCalculator.getRssMemorySize();
        this.setMaxMetrics(0, memoryBytes);
        this.setAvgMetrics(1, memoryBytes);
    }

    private void refreshGPUMetrics() {
        try {
            GpuDeviceInformation gpuInfo = this.gpuDiscoverer.getGpuDeviceInformation();
            double maxGpuUtilization = gpuInfo.getGpus().stream().mapToDouble(x -> x.getGpuUtilizations().getOverallGpuUtilization().floatValue()).max().getAsDouble();
            double avgGpuUtilization = gpuInfo.getGpus().stream().mapToDouble(x -> x.getGpuUtilizations().getOverallGpuUtilization().floatValue()).average().getAsDouble();
            double maxGpuFBMemoryUsage = gpuInfo.getGpus().stream().mapToDouble(x -> (double)x.getGpuFBMemoryUsage().getUsedMemoryMiB().longValue() / (double)x.getGpuFBMemoryUsage().getTotalMemoryMiB() * 100.0).max().getAsDouble();
            double avgGpuFBMemoryUsage = gpuInfo.getGpus().stream().mapToDouble(x -> (double)x.getGpuFBMemoryUsage().getUsedMemoryMiB().longValue() / (double)x.getGpuFBMemoryUsage().getTotalMemoryMiB() * 100.0).average().getAsDouble();
            double maxGpuMainMemoryUsage = gpuInfo.getGpus().stream().mapToDouble(x -> (double)x.getGpuMainMemoryUsage().getUsedMemoryMiB().longValue() / (double)x.getGpuMainMemoryUsage().getTotalMemoryMiB() * 100.0).max().getAsDouble();
            double avgGpuMainMemoryUsage = gpuInfo.getGpus().stream().mapToDouble(x -> (double)x.getGpuMainMemoryUsage().getUsedMemoryMiB().longValue() / (double)x.getGpuMainMemoryUsage().getTotalMemoryMiB() * 100.0).average().getAsDouble();
            this.setMaxMetrics(2, maxGpuUtilization);
            this.setAvgMetrics(3, avgGpuUtilization);
            this.setMaxMetrics(4, maxGpuFBMemoryUsage);
            this.setAvgMetrics(5, avgGpuFBMemoryUsage);
            this.setMaxMetrics(6, maxGpuMainMemoryUsage);
            this.setAvgMetrics(7, avgGpuMainMemoryUsage);
        }
        catch (GpuInfoException e) {
            if (this.gpuDiscoverer.getNumOfErrorExecutionSinceLastSucceed() >= 10) {
                LOG.warn((Object)"Failed to collect GPU metrics", (Throwable)e);
                this.isGpuMachine = false;
                return;
            }
            LOG.warn((Object)("Failed to collect GPU metrics on attempt " + (this.numRefreshes + 1) + ", retrying..."), (Throwable)e);
        }
    }

    @VisibleForTesting
    void setAvgMetrics(int metricIndex, double newMetricValue) {
        MetricWritable metric = this.metrics.getMetric(metricIndex);
        metric.setValue((metric.getValue() * (double)this.numRefreshes + newMetricValue) / (double)(this.numRefreshes + 1));
        this.metrics.setMetric(metricIndex, metric);
    }

    @VisibleForTesting
    void setMaxMetrics(int metricIndex, double newMetricValue) {
        MetricWritable metric = this.metrics.getMetric(metricIndex);
        if (newMetricValue > metric.getValue()) {
            metric.setValue(newMetricValue);
            this.metrics.setMetric(metricIndex, metric);
        }
    }

    @VisibleForTesting
    MetricsWritable getMetrics() {
        return this.metrics;
    }
}

