/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.submitter.yarn;

import com.linkedin.tony.TonyClient;
import com.linkedin.tony.client.CallbackHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.submarine.client.cli.param.ParametersHolder;
import org.apache.submarine.commons.runtime.JobSubmitter;
import org.apache.submarine.commons.runtime.exception.SubmarineException;
import org.apache.submarine.commons.runtime.param.Parameter;
import org.apache.submarine.server.submitter.yarn.YarnUtils;

public class YarnJobSubmitter
implements JobSubmitter,
CallbackHandler {
    private static final Log LOG = LogFactory.getLog(YarnJobSubmitter.class);
    private ApplicationId applicationId;
    private TonyClient tonyClient;

    public void setTonyClient(TonyClient client) {
        this.tonyClient = client;
    }

    public ApplicationId submitJob(Parameter parameters) throws IOException, SubmarineException {
        LOG.info((Object)"Starting Tony runtime..");
        LOG.info((Object)("Use ML framework : " + parameters.getFramework().getValue()));
        File tonyFinalConfPath = File.createTempFile("temp", "tony-final.xml");
        Configuration tonyConf = null;
        try {
            tonyConf = YarnUtils.tonyConfFromClientContext((ParametersHolder)parameters);
        }
        catch (Exception e) {
            throw new SubmarineException("Failed to create tony conf from client context");
        }
        try (FileOutputStream os = new FileOutputStream(tonyFinalConfPath);){
            tonyConf.writeXml((OutputStream)os);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create " + tonyFinalConfPath + " conf file. Exiting.", e);
        }
        try {
            this.tonyClient.init(new String[]{"--conf_file", tonyFinalConfPath.getAbsolutePath()});
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to init TonyClient: ", (Throwable)e);
        }
        Thread clientThread = new Thread(() -> ((TonyClient)this.tonyClient).start());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.tonyClient.forceKillApplication();
            }
            catch (IOException | YarnException e) {
                LOG.error((Object)"Failed to kill application during shutdown.", e);
            }
        }));
        clientThread.start();
        while (clientThread.isAlive()) {
            if (this.applicationId != null) {
                LOG.info((Object)("TonyClient returned applicationId: " + this.applicationId));
                return this.applicationId;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)e);
            }
        }
        return null;
    }

    public void onApplicationIdReceived(ApplicationId appId) {
        this.applicationId = appId;
    }
}

