/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.commons.runtime.fs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.submarine.commons.runtime.ClientContext;
import org.apache.submarine.commons.runtime.fs.RemoteDirectoryManager;

public class DefaultRemoteDirectoryManager
implements RemoteDirectoryManager {
    private FileSystem fs;
    private Configuration conf;

    public DefaultRemoteDirectoryManager(ClientContext context) {
        this.conf = context.getYarnConfig();
        try {
            this.fs = FileSystem.get((Configuration)context.getYarnConfig());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path getJobStagingArea(String jobName, boolean create) throws IOException {
        Path staging = new Path(this.getJobRootFolder(jobName), "staging");
        if (create) {
            this.createFolderIfNotExist(staging);
        }
        FileStatus fStatus = this.fs.getFileStatus(staging);
        return fStatus.getPath();
    }

    @Override
    public Path getJobCheckpointDir(String jobName, boolean create) throws IOException {
        Path jobDir = new Path(this.getJobStagingArea(jobName, create), "checkpoint_path");
        if (create) {
            this.createFolderIfNotExist(jobDir);
        }
        return jobDir;
    }

    @Override
    public Path getModelDir(String modelName, boolean create) throws IOException {
        Path modelDir = new Path(new Path("submarine", "models"), modelName);
        if (create) {
            this.createFolderIfNotExist(modelDir);
        }
        return modelDir;
    }

    @Override
    public FileSystem getDefaultFileSystem() {
        return this.fs;
    }

    @Override
    public FileSystem getFileSystemByUri(String uri) throws IOException {
        return FileSystem.get((URI)URI.create(uri), (Configuration)this.conf);
    }

    @Override
    public Path getUserRootFolder() throws IOException {
        Path rootPath = new Path("submarine", "jobs");
        this.createFolderIfNotExist(rootPath);
        FileStatus fStatus = this.fs.getFileStatus(rootPath);
        return fStatus.getPath();
    }

    @Override
    public boolean isDir(String uri) throws IOException {
        if (this.isRemote(uri)) {
            return this.getFileSystemByUri(uri).getFileStatus(new Path(uri)).isDirectory();
        }
        return new File(uri).isDirectory();
    }

    @Override
    public boolean isRemote(String uri) {
        String scheme = new Path(uri).toUri().getScheme();
        if (null == scheme) {
            return false;
        }
        return !scheme.startsWith("file://");
    }

    @Override
    public boolean copyRemoteToLocal(String remoteUri, String localUri) throws IOException {
        File old = new File(localUri);
        if (old.exists() && !FileUtil.fullyDelete((File)old)) {
            throw new IOException("Failed to delete dir:" + old.getAbsolutePath());
        }
        return FileUtil.copy((FileSystem)this.getFileSystemByUri(remoteUri), (Path)new Path(remoteUri), (File)new File(localUri), (boolean)false, (Configuration)this.conf);
    }

    @Override
    public boolean existsRemoteFile(String uri) throws IOException {
        return this.getFileSystemByUri(uri).exists(new Path(uri));
    }

    @Override
    public FileStatus getRemoteFileStatus(String uri) throws IOException {
        return this.getFileSystemByUri(uri).getFileStatus(new Path(uri));
    }

    @Override
    public long getRemoteFileSize(String uri) throws IOException {
        return this.getFileSystemByUri(uri).getContentSummary(new Path(uri)).getSpaceConsumed();
    }

    private Path getJobRootFolder(String jobName) throws IOException {
        Path userRoot = this.getUserRootFolder();
        Path jobRootPath = new Path(userRoot, jobName);
        this.createFolderIfNotExist(jobRootPath);
        FileStatus fStatus = this.fs.getFileStatus(jobRootPath);
        return fStatus.getPath();
    }

    private void createFolderIfNotExist(Path path) throws IOException {
        if (!this.fs.exists(path) && !this.fs.mkdirs(path)) {
            throw new IOException("Failed to create folder=" + path);
        }
    }
}

