/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.commons.runtime;

import java.io.IOException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.submarine.commons.runtime.ClientContext;
import org.apache.submarine.commons.runtime.api.JobState;
import org.apache.submarine.commons.runtime.api.JobStatus;
import org.apache.submarine.commons.runtime.exception.SubmarineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(JobMonitor.class);
    protected ClientContext clientContext;

    public JobMonitor(ClientContext clientContext) {
        this.clientContext = clientContext;
    }

    public abstract JobStatus getTrainingJobStatus(String var1) throws IOException, YarnException;

    public void cleanup() throws IOException {
    }

    public void waitTrainingFinal(String jobName) throws IOException, YarnException, SubmarineException {
        JobState jobState;
        int waitIntervalSec = 5;
        while (true) {
            JobStatus js = this.getTrainingJobStatus(jobName);
            jobState = js.getState();
            js.nicePrint(System.err);
            if (JobState.isFinal(jobState)) {
                if (jobState.equals((Object)JobState.FAILED)) {
                    throw new SubmarineException("Job failed");
                }
                if (jobState.equals((Object)JobState.KILLED)) {
                    throw new SubmarineException("Job killed");
                }
                break;
            }
            try {
                Thread.sleep(waitIntervalSec * 1000);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        LOG.info("Job exited with state=" + (Object)((Object)jobState));
        this.cleanup();
    }
}

