/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.commons.runtime;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;

public enum Framework {
    TENSORFLOW("tensorflow"),
    PYTORCH("pytorch"),
    MXNET("mxnet");

    private String value;

    private Framework(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static Framework parseByValue(String value) {
        for (Framework fw : Framework.values()) {
            if (!fw.value.equalsIgnoreCase(value)) continue;
            return fw;
        }
        return null;
    }

    public static String getValues() {
        List values = Lists.newArrayList((Object[])Framework.values()).stream().map(fw -> fw.value).collect(Collectors.toList());
        return String.join((CharSequence)",", values);
    }

    private static class Constants {
        static final String TENSORFLOW_NAME = "tensorflow";
        static final String PYTORCH_NAME = "pytorch";
        static final String MXNET_NAME = "mxnet";

        private Constants() {
        }
    }
}

