/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.submitter.k8s.util;

import io.kubernetes.client.models.V1DeleteOptions;
import io.kubernetes.client.models.V1DeleteOptionsBuilder;
import io.kubernetes.client.models.V1JobCondition;
import io.kubernetes.client.models.V1JobStatus;
import io.kubernetes.client.models.V1Status;
import io.kubernetes.client.models.V1StatusDetails;
import java.util.List;
import org.apache.submarine.server.api.experiment.Experiment;
import org.apache.submarine.server.submitter.k8s.model.MLJob;
import org.joda.time.DateTime;

public class MLJobConverter {
    public static Experiment toJobFromMLJob(MLJob mlJob) {
        V1JobStatus status;
        Experiment experiment = new Experiment();
        experiment.setUid(mlJob.getMetadata().getUid());
        experiment.setName(mlJob.getMetadata().getName());
        DateTime dateTime = mlJob.getMetadata().getCreationTimestamp();
        if (dateTime != null) {
            experiment.setAcceptedTime(dateTime.toString());
            experiment.setStatus(Experiment.Status.STATUS_ACCEPTED.getValue());
        }
        if ((status = mlJob.getStatus()) != null) {
            List conditions;
            dateTime = status.getStartTime();
            if (dateTime != null) {
                experiment.setCreatedTime(dateTime.toString());
                experiment.setStatus(Experiment.Status.STATUS_CREATED.getValue());
            }
            if ((conditions = status.getConditions()) != null && conditions.size() > 1) {
                experiment.setStatus(Experiment.Status.STATUS_RUNNING.getValue());
                for (V1JobCondition condition : conditions) {
                    if (!Boolean.parseBoolean(condition.getStatus()) || !condition.getType().toLowerCase().equals("running")) continue;
                    dateTime = condition.getLastTransitionTime();
                    experiment.setRunningTime(dateTime.toString());
                    break;
                }
            }
            if ((dateTime = status.getCompletionTime()) != null) {
                experiment.setFinishedTime(dateTime.toString());
                experiment.setStatus(Experiment.Status.STATUS_SUCCEEDED.getValue());
            }
        }
        return experiment;
    }

    public static Experiment toJobFromStatus(V1Status status) {
        Experiment experiment = new Experiment();
        V1StatusDetails details = status.getDetails();
        if (details != null) {
            experiment.setUid(details.getUid());
            experiment.setName(details.getName());
        }
        if (status.getStatus().toLowerCase().equals("success")) {
            experiment.setStatus(Experiment.Status.STATUS_DELETED.getValue());
        }
        return experiment;
    }

    public static V1DeleteOptions toDeleteOptionsFromMLJob(MLJob job) {
        return ((V1DeleteOptionsBuilder)new V1DeleteOptionsBuilder().withApiVersion(job.getApiVersion())).build();
    }
}

