/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.submitter.k8s.model;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.models.V1Container;
import io.kubernetes.client.models.V1PodTemplateSpec;
import java.math.BigDecimal;

public class MLJobReplicaSpec {
    @SerializedName(value="replicas")
    private Integer replicas;
    @SerializedName(value="template")
    private V1PodTemplateSpec template;
    @SerializedName(value="restartPolicy")
    private String restartPolicy = "OnFailure";

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public String getContainerCommand() {
        V1PodTemplateSpec podSpec = this.getTemplate();
        return String.join((CharSequence)" ", ((V1Container)podSpec.getSpec().getContainers().get(0)).getCommand());
    }

    public String getContainerMemMB() {
        V1PodTemplateSpec podSpec = this.getTemplate();
        return String.join((CharSequence)" ", ((Quantity)((V1Container)podSpec.getSpec().getContainers().get(0)).getResources().getLimits().get("memory")).getNumber().divide(BigDecimal.valueOf(1000000L)).toString() + "M");
    }

    public String getContainerCpu() {
        V1PodTemplateSpec podSpec = this.getTemplate();
        return ((Quantity)((V1Container)podSpec.getSpec().getContainers().get(0)).getResources().getLimits().get("cpu")).getNumber().toString();
    }

    public String getContainerImageName() {
        V1PodTemplateSpec podSpec = this.getTemplate();
        return ((V1Container)podSpec.getSpec().getContainers().get(0)).getImage();
    }
}

