/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.submitter.k8s;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.JSON;
import io.kubernetes.client.apis.CoreV1Api;
import io.kubernetes.client.apis.CustomObjectsApi;
import io.kubernetes.client.models.V1Pod;
import io.kubernetes.client.models.V1PodList;
import io.kubernetes.client.models.V1Status;
import io.kubernetes.client.util.ClientBuilder;
import io.kubernetes.client.util.KubeConfig;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.submarine.commons.utils.SubmarineConfiguration;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.apache.submarine.server.api.exception.InvalidSpecException;
import org.apache.submarine.server.api.experiment.Experiment;
import org.apache.submarine.server.api.experiment.ExperimentLog;
import org.apache.submarine.server.api.experiment.Submitter;
import org.apache.submarine.server.api.spec.ExperimentMeta;
import org.apache.submarine.server.api.spec.ExperimentSpec;
import org.apache.submarine.server.submitter.k8s.model.MLJob;
import org.apache.submarine.server.submitter.k8s.parser.ExperimentSpecParser;
import org.apache.submarine.server.submitter.k8s.util.MLJobConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sSubmitter
implements Submitter {
    private static final Logger LOG = LoggerFactory.getLogger(K8sSubmitter.class);
    private static final String KUBECONFIG_ENV = "KUBECONFIG";
    private static final String TF_JOB_SELECTOR_KEY = "tf-job-name=";
    private static final String PYTORCH_JOB_SELECTOR_KEY = "pytorch-job-name=";
    private CustomObjectsApi api;
    private CoreV1Api coreApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(SubmarineConfiguration conf) {
        ApiClient client = null;
        try {
            String path = System.getenv(KUBECONFIG_ENV);
            KubeConfig config = KubeConfig.loadKubeConfig((Reader)new FileReader(path));
            client = ClientBuilder.kubeconfig((KubeConfig)config).build();
        }
        catch (Exception e) {
            try {
                LOG.info("Maybe in cluster mode, try to initialize the client again.");
                try {
                    client = ClientBuilder.cluster().build();
                }
                catch (IOException e1) {
                    LOG.error("Initialize K8s submitter failed. " + e.getMessage(), (Throwable)e1);
                    throw new SubmarineRuntimeException(500, "Initialize K8s submitter failed.");
                }
            }
            catch (Throwable throwable) {
                Configuration.setDefaultApiClient(client);
                throw throwable;
            }
            Configuration.setDefaultApiClient((ApiClient)client);
        }
        Configuration.setDefaultApiClient((ApiClient)client);
        if (this.api == null) {
            this.api = new CustomObjectsApi();
        }
        if (this.coreApi == null) {
            this.coreApi = new CoreV1Api(client);
        }
    }

    public Experiment createExperiment(ExperimentSpec spec) throws SubmarineRuntimeException {
        Experiment experiment;
        try {
            MLJob mlJob = ExperimentSpecParser.parseJob(spec);
            Object object = this.api.createNamespacedCustomObject(mlJob.getGroup(), mlJob.getVersion(), mlJob.getMetadata().getNamespace(), mlJob.getPlural(), (Object)mlJob, "true");
            experiment = this.parseResponseObject(object, ParseOp.PARSE_OP_RESULT);
        }
        catch (InvalidSpecException e) {
            LOG.error("K8s submitter: parse Job object failed by " + e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException(200, e.getMessage());
        }
        catch (ApiException e) {
            LOG.error("K8s submitter: parse Job object failed by " + e.getMessage(), (Throwable)e);
            throw new SubmarineRuntimeException(e.getCode(), e.getMessage());
        }
        return experiment;
    }

    public Experiment findExperiment(ExperimentSpec spec) throws SubmarineRuntimeException {
        Experiment experiment;
        try {
            MLJob mlJob = ExperimentSpecParser.parseJob(spec);
            Object object = this.api.getNamespacedCustomObject(mlJob.getGroup(), mlJob.getVersion(), mlJob.getMetadata().getNamespace(), mlJob.getPlural(), mlJob.getMetadata().getName());
            experiment = this.parseResponseObject(object, ParseOp.PARSE_OP_RESULT);
        }
        catch (InvalidSpecException e) {
            throw new SubmarineRuntimeException(200, e.getMessage());
        }
        catch (ApiException e) {
            throw new SubmarineRuntimeException(e.getCode(), e.getMessage());
        }
        return experiment;
    }

    public Experiment patchExperiment(ExperimentSpec spec) throws SubmarineRuntimeException {
        Experiment experiment;
        try {
            MLJob mlJob = ExperimentSpecParser.parseJob(spec);
            Object object = this.api.patchNamespacedCustomObject(mlJob.getGroup(), mlJob.getVersion(), mlJob.getMetadata().getNamespace(), mlJob.getPlural(), mlJob.getMetadata().getName(), (Object)mlJob);
            experiment = this.parseResponseObject(object, ParseOp.PARSE_OP_RESULT);
        }
        catch (InvalidSpecException e) {
            throw new SubmarineRuntimeException(200, e.getMessage());
        }
        catch (ApiException e) {
            throw new SubmarineRuntimeException(e.getCode(), e.getMessage());
        }
        return experiment;
    }

    public Experiment deleteExperiment(ExperimentSpec spec) throws SubmarineRuntimeException {
        Experiment experiment;
        try {
            MLJob mlJob = ExperimentSpecParser.parseJob(spec);
            Object object = this.api.deleteNamespacedCustomObject(mlJob.getGroup(), mlJob.getVersion(), mlJob.getMetadata().getNamespace(), mlJob.getPlural(), mlJob.getMetadata().getName(), MLJobConverter.toDeleteOptionsFromMLJob(mlJob), null, null, null);
            experiment = this.parseResponseObject(object, ParseOp.PARSE_OP_DELETE);
        }
        catch (InvalidSpecException e) {
            throw new SubmarineRuntimeException(200, e.getMessage());
        }
        catch (ApiException e) {
            throw new SubmarineRuntimeException(e.getCode(), e.getMessage());
        }
        return experiment;
    }

    private Experiment parseResponseObject(Object object, ParseOp op) throws SubmarineRuntimeException {
        Gson gson = new JSON().getGson();
        String jsonString = gson.toJson(object);
        LOG.info("Upstream response JSON: {}", (Object)jsonString);
        try {
            if (op == ParseOp.PARSE_OP_RESULT) {
                MLJob mlJob = (MLJob)gson.fromJson(jsonString, MLJob.class);
                return MLJobConverter.toJobFromMLJob(mlJob);
            }
            if (op == ParseOp.PARSE_OP_DELETE) {
                V1Status status = (V1Status)gson.fromJson(jsonString, V1Status.class);
                return MLJobConverter.toJobFromStatus(status);
            }
        }
        catch (JsonSyntaxException e) {
            LOG.error("K8s submitter: parse response object failed by " + e.getMessage(), (Throwable)e);
        }
        throw new SubmarineRuntimeException(500, "K8s Submitter parse upstream response failed.");
    }

    public ExperimentLog getExperimentLogName(ExperimentSpec spec, String id) {
        ExperimentLog experimentLog = new ExperimentLog();
        experimentLog.setExperimentId(id);
        try {
            V1PodList podList = this.coreApi.listNamespacedPod(spec.getMeta().getNamespace(), "false", null, null, this.getJobLabelSelector(spec), null, null, null, null);
            for (V1Pod pod : podList.getItems()) {
                String podName = pod.getMetadata().getName();
                experimentLog.addPodLog(podName, null);
            }
        }
        catch (ApiException e) {
            LOG.error("Error when listing pod for experiment:" + spec.getMeta().getName(), (Object)e.getMessage());
        }
        return experimentLog;
    }

    public ExperimentLog getExperimentLog(ExperimentSpec spec, String id) {
        ExperimentLog experimentLog = new ExperimentLog();
        experimentLog.setExperimentId(id);
        try {
            V1PodList podList = this.coreApi.listNamespacedPod(spec.getMeta().getNamespace(), "false", null, null, this.getJobLabelSelector(spec), null, null, null, null);
            for (V1Pod pod : podList.getItems()) {
                String podName = pod.getMetadata().getName();
                String namespace = pod.getMetadata().getNamespace();
                String podLog = this.coreApi.readNamespacedPodLog(podName, namespace, null, Boolean.FALSE, Integer.valueOf(Integer.MAX_VALUE), null, Boolean.FALSE, Integer.valueOf(Integer.MAX_VALUE), null, Boolean.FALSE);
                experimentLog.addPodLog(podName, podLog);
            }
        }
        catch (ApiException e) {
            LOG.error("Error when listing pod for experiment:" + spec.getMeta().getName(), (Object)e.getMessage());
        }
        return experimentLog;
    }

    private String getJobLabelSelector(ExperimentSpec experimentSpec) {
        if (experimentSpec.getMeta().getFramework().equalsIgnoreCase(ExperimentMeta.SupportedMLFramework.TENSORFLOW.getName())) {
            return TF_JOB_SELECTOR_KEY + experimentSpec.getMeta().getName();
        }
        return PYTORCH_JOB_SELECTOR_KEY + experimentSpec.getMeta().getName();
    }

    private static enum ParseOp {
        PARSE_OP_RESULT,
        PARSE_OP_DELETE;

    }
}

