/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class VersionInfo {
    private static final Log LOG = LogFactory.getLog(VersionInfo.class);
    private static final String VERSION_INFO_FILE = "version-info.properties";
    private Properties versionInfo = new Properties();
    private static final VersionInfo COMMON_VERSION_INFO = new VersionInfo();

    private VersionInfo() {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(VERSION_INFO_FILE);){
            if (is == null) {
                LOG.warn((Object)"Could not open input stream to version-info.properties");
            } else {
                this.versionInfo.load(is);
            }
        }
        catch (IOException ex) {
            LOG.warn((Object)("Could not read 'version-info.properties', " + ex.toString()), (Throwable)ex);
        }
    }

    private String getVersionInternal() {
        return this.versionInfo.getProperty("version", "Unknown");
    }

    private String getRevisionInternal() {
        return this.versionInfo.getProperty("revision", "Unknown");
    }

    private String getBranchInternal() {
        return this.versionInfo.getProperty("branch", "Unknown");
    }

    private String getDateInternal() {
        return this.versionInfo.getProperty("date", "Unknown");
    }

    private String getUserInternal() {
        return this.versionInfo.getProperty("user", "Unknown");
    }

    private String getUrlInternal() {
        return this.versionInfo.getProperty("url", "Unknown");
    }

    private String getSrcChecksumInternal() {
        return this.versionInfo.getProperty("srcChecksum", "Unknown");
    }

    public static String getVersion() {
        return COMMON_VERSION_INFO.getVersionInternal();
    }

    public static String getRevision() {
        return COMMON_VERSION_INFO.getRevisionInternal();
    }

    public static String getBranch() {
        return COMMON_VERSION_INFO.getBranchInternal();
    }

    public static String getDate() {
        return COMMON_VERSION_INFO.getDateInternal();
    }

    public static String getUser() {
        return COMMON_VERSION_INFO.getUserInternal();
    }

    public static String getUrl() {
        return COMMON_VERSION_INFO.getUrlInternal();
    }

    public static String getSrcChecksum() {
        return COMMON_VERSION_INFO.getSrcChecksumInternal();
    }

    public static void injectVersionInfo(Configuration conf) {
        conf.set("tony.version-info.version", VersionInfo.getVersion());
        conf.set("tony.version-info.revision", VersionInfo.getRevision());
        conf.set("tony.version-info.branch", VersionInfo.getBranch());
        conf.set("tony.version-info.user", VersionInfo.getUser());
        conf.set("tony.version-info.date", VersionInfo.getDate());
        conf.set("tony.version-info.url", VersionInfo.getUrl());
        conf.set("tony.version-info.checksum", VersionInfo.getSrcChecksum());
    }

    public static void main(String[] args) {
        System.out.println("Version " + VersionInfo.getVersion());
        System.out.println("Git " + VersionInfo.getUrl() + " branch " + VersionInfo.getBranch() + " revision " + VersionInfo.getRevision());
        System.out.println("Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate());
        System.out.println("From source with checksum " + VersionInfo.getSrcChecksum());
    }
}

