/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.linkedin.tony.events.Event;
import com.linkedin.tony.models.JobConfig;
import com.linkedin.tony.models.JobEvent;
import com.linkedin.tony.models.JobLog;
import com.linkedin.tony.models.JobMetadata;
import com.linkedin.tony.util.HdfsUtils;
import com.linkedin.tony.util.JobLogMetaData;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.io.DatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ParserUtils {
    private static final Log LOG = LogFactory.getLog(ParserUtils.class);

    @VisibleForTesting
    public static boolean isValidHistFileName(String fileName, String jobIdRegex) {
        if (Strings.isNullOrEmpty((String)fileName)) {
            LOG.error((Object)"No filename provided!");
            return false;
        }
        String histFileNoExt = fileName.substring(0, fileName.indexOf(46));
        String[] metadataArr = histFileNoExt.split("-");
        if (metadataArr.length < 3) {
            LOG.error((Object)"Missing fields in metadata");
            return false;
        }
        if (fileName.endsWith("inprogress")) {
            return metadataArr[0].matches(jobIdRegex) && metadataArr[1].matches("\\d+") && metadataArr[2].matches(metadataArr[2].toLowerCase());
        }
        Preconditions.checkArgument((metadataArr.length == 5 ? 1 : 0) != 0);
        return metadataArr[0].matches(jobIdRegex) && metadataArr[1].matches("\\d+") && metadataArr[2].matches("\\d+") && metadataArr[3].matches(metadataArr[3].toLowerCase()) && metadataArr[4].equals(metadataArr[4].toUpperCase());
    }

    public static String getJhistFilePath(FileSystem fs, Path jobFolderPath) {
        try {
            List histFilePaths = Arrays.stream(fs.listStatus(jobFolderPath)).filter(f -> f.getPath().toString().contains("jhist")).map(f -> f.getPath().toString()).collect(Collectors.toList());
            if (histFilePaths.isEmpty()) {
                LOG.warn((Object)("No history files found in " + jobFolderPath));
                return null;
            }
            histFilePaths.sort((filePath1, filePath2) -> {
                long startTime2;
                long startTime1 = Long.parseLong(HdfsUtils.getLastComponent(filePath1).split("-")[1]);
                long difference = startTime1 - (startTime2 = Long.parseLong(HdfsUtils.getLastComponent(filePath2).split("-")[1]));
                if (difference < 0L) {
                    return -1;
                }
                if (difference > 0L) {
                    return 1;
                }
                return 0;
            });
            return (String)histFilePaths.get(histFilePaths.size() - 1);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to scan " + jobFolderPath), (Throwable)e);
            return null;
        }
    }

    public static long getCompletedTimeFromJhistFileName(String jhistFileName) {
        if (jhistFileName.lastIndexOf("/") >= 0) {
            jhistFileName = jhistFileName.substring(jhistFileName.lastIndexOf("/") + 1);
        }
        return Long.parseLong(jhistFileName.split("-")[2]);
    }

    public static JobMetadata parseMetadata(FileSystem fs, YarnConfiguration yarnConf, Path jobFolderPath, String jobIdRegex) {
        if (!HdfsUtils.pathExists(fs, jobFolderPath)) {
            return null;
        }
        String jhistFilePath = ParserUtils.getJhistFilePath(fs, jobFolderPath);
        if (Strings.isNullOrEmpty((String)jhistFilePath)) {
            return null;
        }
        String histFileName = HdfsUtils.getLastComponent(jhistFilePath);
        if (!ParserUtils.isValidHistFileName(histFileName, jobIdRegex)) {
            LOG.warn((Object)("Invalid history file name " + histFileName));
            return null;
        }
        LOG.debug((Object)"Successfully parsed metadata");
        return JobMetadata.newInstance(yarnConf, histFileName);
    }

    public static List<JobConfig> parseConfig(FileSystem fs, Path jobFolderPath) {
        if (!HdfsUtils.pathExists(fs, jobFolderPath)) {
            return Collections.emptyList();
        }
        Path configFilePath = new Path(jobFolderPath, "tony-final.xml");
        try {
            if (!fs.exists(configFilePath)) {
                configFilePath = new Path(jobFolderPath, "config.xml");
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Encountered exception while checking existence of " + configFilePath), (Throwable)e);
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        ArrayList<JobConfig> configs = new ArrayList<JobConfig>();
        try (FSDataInputStream inStrm = fs.open(configFilePath);){
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse((InputStream)inStrm);
            doc.getDocumentElement().normalize();
            NodeList properties = doc.getElementsByTagName("property");
            for (int i = 0; i < properties.getLength(); ++i) {
                Node property = properties.item(i);
                if (property.getNodeType() != 1) continue;
                Element p = (Element)property;
                JobConfig jobConf = new JobConfig();
                String name = ParserUtils.getNodeElementText(p, "name");
                String value = ParserUtils.getNodeElementText(p, "value");
                if (name == null || value == null) {
                    LOG.warn((Object)("Found config with null name or value. Name = " + name + ", value = " + value));
                    continue;
                }
                jobConf.setName(name);
                jobConf.setValue(value);
                String finalText = ParserUtils.getNodeElementText(p, "final");
                if (finalText != null && finalText.equalsIgnoreCase("true")) {
                    jobConf.setFinal(true);
                }
                jobConf.setSource(ParserUtils.getNodeElementText(p, "source"));
                configs.add(jobConf);
            }
        }
        catch (SAXException e) {
            LOG.error((Object)"Failed to parse config file", (Throwable)e);
            return Collections.emptyList();
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)"Failed to init XML parser", (Throwable)e);
            return Collections.emptyList();
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to read config file", (Throwable)e);
            return Collections.emptyList();
        }
        LOG.debug((Object)"Successfully parsed config");
        return configs;
    }

    private static String getNodeElementText(Element node, String tagName) {
        NodeList nodeList;
        if (node != null && (nodeList = node.getElementsByTagName(tagName)).getLength() > 0) {
            return nodeList.item(0).getTextContent();
        }
        return null;
    }

    public static List<Event> parseEvents(FileSystem fs, Path jobFolderPath) {
        if (!HdfsUtils.pathExists(fs, jobFolderPath)) {
            return Collections.emptyList();
        }
        String jhistFile = ParserUtils.getJhistFilePath(fs, jobFolderPath);
        if (Strings.isNullOrEmpty((String)jhistFile)) {
            return Collections.emptyList();
        }
        Path historyFile = new Path(jhistFile);
        ArrayList<Event> events = new ArrayList<Event>();
        try (FSDataInputStream in = fs.open(historyFile);){
            SpecificDatumReader datumReader = new SpecificDatumReader(Event.class);
            try (DataFileStream avroFileStream = new DataFileStream((InputStream)in, (DatumReader)datumReader);){
                while (avroFileStream.hasNext()) {
                    Event record = (Event)((Object)avroFileStream.next(null));
                    events.add(record);
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to read events from " + historyFile), (Throwable)e);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to open history file", (Throwable)e);
        }
        return events;
    }

    public static List<JobEvent> mapEventToJobEvent(List<Event> events) {
        return events.stream().map(JobEvent::convertEventToJobEvent).collect(Collectors.toList());
    }

    public static List<JobLog> mapEventToJobLog(List<Event> events, JobLogMetaData jobLogMetaData) {
        return events.stream().map(e -> JobLog.convertEventToJobLog(e, jobLogMetaData)).filter(jobLog -> jobLog.getContainerID() != null).collect(Collectors.toList());
    }

    public static String getYearMonthDayDirectory(Date date, ZoneId zoneId) {
        StringBuilder dirString = new StringBuilder();
        LocalDate localDate = date.toInstant().atZone(zoneId).toLocalDate();
        dirString.append(localDate.getYear());
        dirString.append("/").append(String.format("%02d", localDate.getMonthValue()));
        dirString.append("/").append(String.format("%02d", localDate.getDayOfMonth()));
        return dirString.toString();
    }

    private ParserUtils() {
    }
}

