/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.linkedin.tony.util.ParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;

public class HdfsUtils {
    private static final Log LOG = LogFactory.getLog(ParserUtils.class);

    public static boolean pathExists(FileSystem fs, Path filePath) {
        try {
            return fs.exists(filePath);
        }
        catch (IOException e) {
            LOG.error((Object)("Error when reading " + filePath.toString()), (Throwable)e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public static String contentOfHdfsFile(FileSystem fs, Path filePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getLastComponent(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return "";
        }
        String[] folderLayers = path.split("/");
        return folderLayers[folderLayers.length - 1];
    }

    @VisibleForTesting
    public static boolean isJobFolder(Path p, String regex) {
        return p != null && HdfsUtils.getLastComponent(p.toString()).matches(regex);
    }

    public static List<FileStatus> getDirectories(FileSystem fs, Path path) {
        try {
            return Arrays.stream(fs.listStatus(path)).filter(FileStatus::isDirectory).collect(Collectors.toList());
        }
        catch (IOException e) {
            LOG.error((Object)("Encountered exception listing directories in " + path), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    public static Path getJobDirPath(FileSystem fs, Path curr, String applicationId) {
        List<FileStatus> dirs = HdfsUtils.getDirectories(fs, curr);
        for (FileStatus dir : dirs) {
            if (!dir.getPath().getName().equals(applicationId)) continue;
            return dir.getPath();
        }
        for (FileStatus dir : dirs) {
            Path result = HdfsUtils.getJobDirPath(fs, dir.getPath(), applicationId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static List<Path> getJobDirs(FileSystem fs, Path curr, String regex) {
        ArrayList<Path> result = new ArrayList<Path>();
        List<FileStatus> dirs = HdfsUtils.getDirectories(fs, curr);
        dirs.forEach(dir -> {
            if (HdfsUtils.isJobFolder(dir.getPath(), regex)) {
                result.add(dir.getPath());
            }
            result.addAll(HdfsUtils.getJobDirs(fs, dir.getPath(), regex));
        });
        return result;
    }

    public static void copySrcToDest(Path src, Path dst, Configuration conf) throws IOException {
        Object srcFs = src.toUri().getScheme() == null ? FileSystem.getLocal((Configuration)conf) : src.getFileSystem(conf);
        FileSystem dstFs = dst.getFileSystem(conf);
        FileUtil.copy((FileSystem)srcFs, (Path)src, (FileSystem)dstFs, (Path)dst, (boolean)false, (boolean)true, (Configuration)conf);
    }

    private HdfsUtils() {
    }
}

