/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony.security;

import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;

public class TokenCache {
    private static final Log LOG = LogFactory.getLog(TokenCache.class);

    private TokenCache() {
    }

    public static void obtainTokensForNamenodes(Credentials credentials, Path[] paths, Configuration conf, String renewer) throws IOException {
        HashSet<FileSystem> fsSet = new HashSet<FileSystem>();
        for (Path path : paths) {
            fsSet.add(path.getFileSystem(conf));
        }
        for (FileSystem fs : fsSet) {
            TokenCache.obtainTokensForNamenodesInternal(fs, credentials, renewer);
        }
    }

    private static void obtainTokensForNamenodesInternal(FileSystem fs, Credentials credentials, String renewer) throws IOException {
        Token[] tokens = fs.addDelegationTokens(renewer, credentials);
        if (tokens != null) {
            for (Token token : tokens) {
                LOG.info((Object)("Got delegation token for " + fs.getUri() + "; " + token));
            }
        }
    }
}

