/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony.rpc.impl;

import com.linkedin.tony.events.Metric;
import com.linkedin.tony.rpc.MetricWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.io.Writable;

public class MetricsWritable
implements Writable {
    private MetricWritable[] metrics;

    public MetricsWritable() {
    }

    public MetricsWritable(int numMetrics) {
        this.metrics = new MetricWritable[numMetrics];
    }

    public MetricWritable getMetric(int index) {
        return this.metrics[index];
    }

    public void setMetric(int index, MetricWritable metric) {
        this.metrics[index] = metric;
    }

    public List<Metric> getMetricsAsList() {
        return Arrays.stream(this.metrics).map(metric -> new Metric(metric.getName(), metric.getValue())).collect(Collectors.toList());
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.metrics.length);
        for (MetricWritable metric : this.metrics) {
            metric.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.metrics = new MetricWritable[in.readInt()];
        for (int i = 0; i < this.metrics.length; ++i) {
            MetricWritable metric = new MetricWritable();
            metric.readFields(in);
            this.metrics[i] = metric;
        }
    }
}

