/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony.rpc;

import com.google.protobuf.BlockingService;
import com.linkedin.tony.TonyPolicyProvider;
import com.linkedin.tony.rpc.ApplicationRpc;
import com.linkedin.tony.rpc.Empty;
import com.linkedin.tony.rpc.GetClusterSpecRequest;
import com.linkedin.tony.rpc.GetClusterSpecResponse;
import com.linkedin.tony.rpc.GetTaskInfosRequest;
import com.linkedin.tony.rpc.GetTaskInfosResponse;
import com.linkedin.tony.rpc.HeartbeatRequest;
import com.linkedin.tony.rpc.HeartbeatResponse;
import com.linkedin.tony.rpc.RegisterExecutionResultRequest;
import com.linkedin.tony.rpc.RegisterExecutionResultResponse;
import com.linkedin.tony.rpc.RegisterTensorBoardUrlRequest;
import com.linkedin.tony.rpc.RegisterTensorBoardUrlResponse;
import com.linkedin.tony.rpc.RegisterWorkerSpecRequest;
import com.linkedin.tony.rpc.RegisterWorkerSpecResponse;
import com.linkedin.tony.rpc.TensorFlowCluster;
import com.linkedin.tony.rpc.TensorFlowClusterPB;
import com.linkedin.tony.rpc.impl.pb.service.TensorFlowClusterPBServiceImpl;
import com.linkedin.tony.rpc.proto.TensorFlowCluster;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenSecretManager;

public class ApplicationRpcServer
extends Thread
implements TensorFlowCluster {
    private static final RecordFactory RECORD_FACTORY = RecordFactoryProvider.getRecordFactory(null);
    private static final Random RANDOM_NUMBER_GENERATOR = new Random();
    private final int rpcPort;
    private final String rpcAddress;
    private final ApplicationRpc appRpc;
    private ClientToAMTokenSecretManager secretManager;
    private Server server;
    private Configuration conf;

    public ApplicationRpcServer(String hostname, ApplicationRpc rpc, Configuration conf) throws IOException {
        this.rpcAddress = hostname;
        ServerSocket rpcSocket = new ServerSocket(0);
        this.rpcPort = rpcSocket.getLocalPort();
        rpcSocket.close();
        this.appRpc = rpc;
        this.conf = conf;
    }

    @Override
    public GetTaskInfosResponse getTaskInfos(GetTaskInfosRequest request) throws IOException, YarnException {
        GetTaskInfosResponse response = (GetTaskInfosResponse)RECORD_FACTORY.newRecordInstance(GetTaskInfosResponse.class);
        response.setTaskInfos(this.appRpc.getTaskInfos());
        return response;
    }

    @Override
    public GetClusterSpecResponse getClusterSpec(GetClusterSpecRequest request) throws YarnException, IOException {
        GetClusterSpecResponse response = (GetClusterSpecResponse)RECORD_FACTORY.newRecordInstance(GetClusterSpecResponse.class);
        response.setClusterSpec(this.appRpc.getClusterSpec());
        return response;
    }

    @Override
    public RegisterWorkerSpecResponse registerWorkerSpec(RegisterWorkerSpecRequest request) throws YarnException, IOException {
        RegisterWorkerSpecResponse response = (RegisterWorkerSpecResponse)RECORD_FACTORY.newRecordInstance(RegisterWorkerSpecResponse.class);
        String clusterSpec = this.appRpc.registerWorkerSpec(request.getWorker(), request.getSpec());
        response.setSpec(clusterSpec);
        return response;
    }

    @Override
    public RegisterTensorBoardUrlResponse registerTensorBoardUrl(RegisterTensorBoardUrlRequest request) throws Exception {
        RegisterTensorBoardUrlResponse response = (RegisterTensorBoardUrlResponse)RECORD_FACTORY.newRecordInstance(RegisterTensorBoardUrlResponse.class);
        String clusterSpec = this.appRpc.registerTensorBoardUrl(request.getSpec());
        response.setSpec(clusterSpec);
        return response;
    }

    @Override
    public RegisterExecutionResultResponse registerExecutionResult(RegisterExecutionResultRequest request) throws Exception {
        RegisterExecutionResultResponse response = (RegisterExecutionResultResponse)RECORD_FACTORY.newRecordInstance(RegisterExecutionResultResponse.class);
        String msg = this.appRpc.registerExecutionResult(request.getExitCode(), request.getJobName(), request.getJobIndex(), request.getSessionId());
        response.setMessage(msg);
        return response;
    }

    @Override
    public Empty finishApplication(Empty request) throws IOException, YarnException {
        Empty response = (Empty)RECORD_FACTORY.newRecordInstance(Empty.class);
        this.appRpc.finishApplication();
        return response;
    }

    @Override
    public HeartbeatResponse taskExecutorHeartbeat(HeartbeatRequest request) throws YarnException, IOException {
        HeartbeatResponse response = (HeartbeatResponse)RECORD_FACTORY.newRecordInstance(HeartbeatResponse.class);
        this.appRpc.taskExecutorHeartbeat(request.getTaskId());
        return response;
    }

    public void reset() {
        this.appRpc.reset();
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public void setSecretManager(ClientToAMTokenSecretManager secretManager) {
        this.secretManager = secretManager;
    }

    @Override
    public void run() {
        try {
            RPC.setProtocolEngine((Configuration)this.conf, TensorFlowClusterPB.class, ProtobufRpcEngine.class);
            TensorFlowClusterPBServiceImpl translator = new TensorFlowClusterPBServiceImpl(this);
            BlockingService service = TensorFlowCluster.TensorFlowClusterService.newReflectiveBlockingService(translator);
            this.server = new RPC.Builder(this.conf).setProtocol(TensorFlowClusterPB.class).setInstance((Object)service).setBindAddress(this.rpcAddress).setPort(this.rpcPort).setSecretManager((SecretManager)this.secretManager).build();
            this.server.start();
            if (this.conf.getBoolean("hadoop.security.authorization", false)) {
                this.refreshServiceAcls(this.conf, new TonyPolicyProvider());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAclWithLoadedConfiguration(configuration, policyProvider);
    }

    public long getProtocolVersion(String protocol, long version) throws IOException {
        return 1L;
    }

    public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        return ProtocolSignature.getProtocolSignature((VersionedProtocol)this, (String)protocol, (long)clientVersion, (int)clientMethodsHash);
    }
}

