/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TonyConfigurationKeys {
    public static final String TONY_PREFIX = "tony.";
    public static final String TONY_VERSION_INFO_PREFIX = "tony.version-info.";
    public static final String TONY_VERSION_INFO_VERSION = "tony.version-info.version";
    public static final String TONY_VERSION_INFO_REVISION = "tony.version-info.revision";
    public static final String TONY_VERSION_INFO_BRANCH = "tony.version-info.branch";
    public static final String TONY_VERSION_INFO_USER = "tony.version-info.user";
    public static final String TONY_VERSION_INFO_DATE = "tony.version-info.date";
    public static final String TONY_VERSION_INFO_URL = "tony.version-info.url";
    public static final String TONY_VERSION_INFO_CHECKSUM = "tony.version-info.checksum";
    public static final String OTHER_NAMENODES_TO_ACCESS = "tony.other.namenodes";
    public static final String TONY_HISTORY_PREFIX = "tony.history.";
    public static final String TONY_HISTORY_LOCATION = "tony.history.location";
    public static final String DEFAULT_TONY_HISTORY_LOCATION = "/path/to/tony-history";
    public static final String TONY_HISTORY_INTERMEDIATE = "tony.history.intermediate";
    public static final String DEFAULT_TONY_HISTORY_INTERMEDIATE = "/path/to/tony-history/intermediate";
    public static final String TONY_HISTORY_FINISHED = "tony.history.finished";
    public static final String DEFAULT_TONY_HISTORY_FINISHED = "/path/to/tony-history/finished";
    public static final String TONY_HISTORY_MOVER_INTERVAL_MS = "tony.history.mover-interval-ms";
    public static final int DEFAULT_TONY_HISTORY_MOVER_INTERVAL_MS = 300000;
    public static final String TONY_HISTORY_FINISHED_DIR_TIMEZONE = "tony.history.finished-dir-timezone";
    public static final String DEFAULT_TONY_HISTORY_FINISHED_DIR_TIMEZONE = "UTC";
    public static final String TONY_HISTORY_RETENTION_SECONDS = "tony.history.retention-sec";
    public static final int DEFAULT_TONY_HISTORY_RETENTION_SECONDS = 2592000;
    public static final String TONY_HISTORY_PURGER_INTERVAL_MS = "tony.history.purger-interval-ms";
    public static final int DEFAULT_TONY_HISTORY_PURGER_INTERVAL_MS = 21600000;
    public static final String TONY_PORTAL_CACHE_MAX_ENTRIES = "tony.portal.cache.max-entries";
    public static final String DEFAULT_TONY_PORTAL_CACHE_MAX_ENTRIES = "10000";
    public static final String TONY_KEYTAB_USER = "tony.keytab.user";
    public static final String DEFAULT_TONY_KEYTAB_USER = "user";
    public static final String TONY_KEYTAB_LOCATION = "tony.keytab.location";
    public static final String DEFAULT_TONY_KEYTAB_LOCATION = "/path/to/tony.keytab";
    public static final String TONY_HTTPS_PORT = "tony.https.port";
    public static final String DEFAULT_TONY_HTTPS_PORT = "19886";
    public static final String TONY_HTTPS_KEYSTORE_PATH = "tony.https.keystore.path";
    public static final String DEFAULT_TONY_HTTPS_KEYSTORE_PATH = "/path/to/keystore.jks";
    public static final String TONY_HTTPS_KEYSTORE_TYPE = "tony.https.keystore.type";
    public static final String DEFAULT_TONY_HTTPS_KEYSTORE_TYPE = "JKS";
    public static final String TONY_HTTPS_KEYSTORE_PASSWORD = "tony.https.keystore.password";
    public static final String DEFAULT_TONY_HTTPS_KEYSTORE_PASSWORD = "password";
    public static final String TONY_HTTPS_KEYSTORE_ALGORITHM = "tony.https.keystore.algorithm";
    public static final String DEFAULT_TONY_HTTPS_KEYSTORE_ALGORITHM = "SunX509";
    public static final String TONY_HTTP_PORT = "tony.http.port";
    public static final String DEFAULT_TONY_HTTP_PORT = "disabled";
    public static final String TONY_SECRET_KEY = "tony.secret.key";
    public static final String DEFAULT_TONY_SECRET_KEY = "changeme";
    public static final String TONY_PORTAL_URL = "tony.portal.url";
    public static final String DEFAULT_TONY_PORTAL_URL = "https://localhost:19886";
    public static final String YARN_QUEUE_NAME = "tony.yarn.queue";
    public static final String DEFAULT_YARN_QUEUE_NAME = "default";
    public static final String TONY_APPLICATION_PREFIX = "tony.application.";
    public static final String APPLICATION_NAME = "tony.application.name";
    public static final String DEFAULT_APPLICATION_NAME = "TonyApplication";
    public static final String APPLICATION_TYPE = "tony.application.type";
    public static final String DEFAULT_APPLICATION_TYPE = "TONY";
    public static final String FRAMEWORK_NAME = "tony.application.framework";
    public static final String DEFAULT_FRAMEWORK_NAME = "tensorflow";
    public static final String APPLICATION_NODE_LABEL = "tony.application.node-label";
    public static final String ENABLE_PREPROCESSING_JOB = "tony.application.enable-preprocess";
    public static final boolean DEFAULT_ENABLE_PREPROCESSING_JOB = false;
    public static final String APPLICATION_TIMEOUT = "tony.application.timeout";
    public static final int DEFAULT_APPLICATION_TIMEOUT = 0;
    public static final String RM_CLIENT_CONNECT_RETRY_MULTIPLIER = "tony.application.num-client-rm-connect-retries";
    public static final int DEFAULT_RM_CLIENT_CONNECT_RETRY_MULTIPLIER = 3;
    public static final String APPLICATION_TAGS = "tony.application.tags";
    public static final String APPLICATION_PREPARE_STAGE = "tony.application.prepare-stage";
    public static final String APPLICATION_TRAINING_STAGE = "tony.application.training-stage";
    public static final String TONY_TASK_PREFIX = "tony.task.";
    public static final String MAX_TOTAL_INSTANCES = "tony.task.max-total-instances";
    public static final int DEFAULT_MAX_TOTAL_INSTANCES = -1;
    public static final String TASK_AM_JVM_OPTS = "tony.task.am.jvm.opts";
    public static final String TASK_EXECUTOR_JVM_OPTS = "tony.task.executor.jvm.opts";
    public static final String DEFAULT_TASK_EXECUTOR_JVM_OPTS = "-Xmx1536m";
    public static final String TASK_HEARTBEAT_INTERVAL_MS = "tony.task.heartbeat-interval-ms";
    public static final int DEFAULT_TASK_HEARTBEAT_INTERVAL_MS = 1000;
    public static final String TASK_MAX_MISSED_HEARTBEATS = "tony.task.max-missed-heartbeats";
    public static final int DEFAULT_TASK_MAX_MISSED_HEARTBEATS = 25;
    public static final String TASK_METRICS_UPDATE_INTERVAL_MS = "tony.task.metrics-interval-ms";
    public static final int DEFAULT_TASK_METRICS_UPDATE_INTERVAL_MS = 5000;
    public static final String TASK_GPU_METRICS_ENABLED = "tony.task.gpu-metrics.enabled";
    public static final boolean DEFAULT_TASK_GPU_METRICS_ENABLED = true;
    public static final String AM_PREFIX = "tony.am.";
    public static final String AM_RETRY_COUNT = "tony.am.retry-count";
    public static final int DEFAULT_AM_RETRY_COUNT = 0;
    public static final String AM_MEMORY = "tony.am.memory";
    public static final String DEFAULT_AM_MEMORY = "2g";
    public static final String AM_VCORES = "tony.am.vcores";
    public static final int DEFAULT_AM_VCORES = 1;
    public static final String AM_GPUS = "tony.am.gpus";
    public static final int DEFAULT_AM_GPUS = 0;
    public static final String INSTANCES_REGEX = "tony\\.([a-z]+)\\.instances";
    public static final String MAX_TOTAL_RESOURCES_REGEX = "tony.task.max-total-([a-z]+)";
    public static final String RESOURCES_REGEX = "tony\\.([a-z]+)\\.resources";
    public static final String DEFAULT_MEMORY = "2g";
    public static final int DEFAULT_VCORES = 1;
    public static final int DEFAULT_GPUS = 0;
    public static final String CONTAINER_PREFIX = "tony.container.";
    public static final String CONTAINER_ALLOCATION_TIMEOUT = "tony.container.allocation.timeout";
    public static final int DEFAULT_CONTAINER_ALLOCATION_TIMEOUT = 900000;
    public static final String WORKER_PREFIX = "tony.worker.";
    public static final String WORKER_TIMEOUT = "tony.worker.timeout";
    public static final int DEFAULT_WORKER_TIMEOUT = 0;
    public static final String UNTRACKED_JOBTYPES = "tony.application.untracked.jobtypes";
    public static final String UNTRACKED_JOBTYPES_DEFAULT = "ps";
    public static final String STOP_ON_FAILURE_JOBTYPES = "tony.application.stop-on-failure-jobtypes";
    public static final String FAIL_ON_WORKER_FAILURE_ENABLED = "tony.application.fail-on-worker-failure-enabled";
    public static final boolean DEFAULT_FAIL_ON_WORKER_FAILURE_ENABLED = false;
    public static final String CHIEF_PREFIX = "tony.chief.";
    public static final String DOCKER_PREFIX = "tony.docker.";
    public static final String DOCKER_ENABLED = "tony.docker.enabled";
    public static final boolean DEFAULT_DOCKER_ENABLED = false;
    public static final String CONTAINER_LAUNCH_ENV = "tony.containers.envs";
    public static final String EXECUTION_ENV = "tony.execution.envs";
    public static final String GPU_PATH_TO_EXEC = "tony.gpu-exec-path";
    public static final String DEFAULT_GPU_PATH_TO_EXEC = "nvidia-smi";
    public static final String SECURITY_ENABLED = "tony.application.security.enabled";
    public static final boolean DEFAULT_SECURITY_ENABLED = true;
    public static final String HDFS_CONF_LOCATION = "tony.application.hdfs-conf-path";
    public static final String YARN_CONF_LOCATION = "tony.application.yarn-conf-path";
    public static final List<String> MULTI_VALUE_CONF = Collections.unmodifiableList(Arrays.asList("tony.containers.envs", "tony.execution.envs", TonyConfigurationKeys.getContainerResourcesKey()));

    private TonyConfigurationKeys() {
    }

    public static String getInstancesKey(String jobName) {
        return String.format("tony.%s.instances", jobName);
    }

    public static String getMaxInstancesKey(String jobName) {
        return String.format("tony.%s.max-instances", jobName);
    }

    public static String getResourceKey(String jobName, String resource) {
        return String.format("tony.%s.%s", jobName, resource);
    }

    public static String getNodeLabelKey(String jobName) {
        return String.format("tony.%s.node-label", jobName);
    }

    public static String getDependsOnKey(String jobName) {
        return String.format("tony.%s.depends-on", jobName);
    }

    public static String getMaxTotalResourceKey(String resource) {
        return String.format("tony.task.max-total-%s", resource);
    }

    public static String getResourcesKey(String jobName) {
        return String.format("tony.%s.resources", jobName);
    }

    public static String getContainerResourcesKey() {
        return "tony.containers.resources";
    }

    public static String getExecuteCommandKey(String jobName) {
        return String.format("tony.%s.command", jobName);
    }

    public static String getContainerExecuteCommandKey() {
        return "tony.containers.command";
    }

    public static String getDockerImageKey(String jobName) {
        return String.format("tony.docker.%s.image", jobName);
    }

    public static String getContainerDockerKey() {
        return "tony.docker.containers.image";
    }

    public static enum MLFramework {
        TENSORFLOW,
        PYTORCH,
        HOROVOD,
        MXNET;

    }
}

