/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony;

import azkaban.jobtype.HadoopConfigurationInjector;
import azkaban.utils.Props;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.linkedin.tony.Constants;
import com.linkedin.tony.LocalizableResource;
import com.linkedin.tony.TonyConfigurationKeys;
import com.linkedin.tony.client.CallbackHandler;
import com.linkedin.tony.client.TaskUpdateListener;
import com.linkedin.tony.rpc.TaskInfo;
import com.linkedin.tony.rpc.impl.ApplicationRpcClient;
import com.linkedin.tony.security.TokenCache;
import com.linkedin.tony.tensorflow.JobContainerRequest;
import com.linkedin.tony.util.HdfsUtils;
import com.linkedin.tony.util.Utils;
import com.linkedin.tony.util.VersionInfo;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;

public class TonyClient
implements AutoCloseable {
    private static final Log LOG = LogFactory.getLog(TonyClient.class);
    private YarnClient yarnClient;
    private HdfsConfiguration hdfsConf = new HdfsConfiguration();
    private YarnConfiguration yarnConf = new YarnConfiguration();
    private Options opts;
    private String amHost;
    private int amRpcPort;
    private boolean amRpcServerInitialized = false;
    private ApplicationRpcClient amRpcClient;
    private String hdfsConfAddress = null;
    private String yarnConfAddress = null;
    private long amMemory;
    private int amVCores;
    private int amGpus;
    private String taskParams = null;
    private String pythonBinaryPath = null;
    private String pythonVenv = null;
    private String srcDir = null;
    private Set<String> applicationTags;
    private String hdfsClasspath = null;
    private String executes;
    private long appTimeout;
    private boolean secureMode;
    private Map<String, String> containerEnv = new HashMap<String, String>();
    private String tonyFinalConfPath;
    private Configuration tonyConf;
    private final long clientStartTime = System.currentTimeMillis();
    private ApplicationId appId;
    private org.apache.hadoop.fs.Path appResourcesPath;
    private int hbInterval;
    private int maxHbMisses;
    private boolean isTaskUrlsPrinted = false;
    private CallbackHandler callbackHandler;
    private CopyOnWriteArrayList<TaskUpdateListener> listeners = new CopyOnWriteArrayList();
    private Set<TaskInfo> taskInfos = new HashSet<TaskInfo>();

    public TonyClient() {
        this(new Configuration(false));
    }

    public TonyClient(Configuration conf) {
        this(null, conf);
    }

    public TonyClient(CallbackHandler handler, Configuration conf) {
        this.initOptions();
        this.callbackHandler = handler;
        this.tonyConf = conf;
        VersionInfo.injectVersionInfo(this.tonyConf);
    }

    private boolean run() throws IOException, InterruptedException, URISyntaxException, YarnException, ParseException {
        int maxVCores;
        LOG.info((Object)"Starting client..");
        this.yarnClient.start();
        YarnClientApplication app = this.yarnClient.createApplication();
        GetNewApplicationResponse appResponse = app.getNewApplicationResponse();
        long maxMem = appResponse.getMaximumResourceCapability().getMemory();
        if (this.amMemory > maxMem) {
            LOG.warn((Object)("Truncating requested AM memory: " + this.amMemory + " to cluster's max: " + maxMem));
            this.amMemory = maxMem;
        }
        if (this.amVCores > (maxVCores = appResponse.getMaximumResourceCapability().getVirtualCores())) {
            LOG.warn((Object)("Truncating requested AM vcores: " + this.amVCores + " to cluster's max: " + maxVCores));
            this.amVCores = maxVCores;
        }
        FileSystem fs = FileSystem.get((Configuration)this.hdfsConf);
        ApplicationSubmissionContext appContext = app.getApplicationSubmissionContext();
        this.appId = appContext.getApplicationId();
        if (this.callbackHandler != null) {
            this.callbackHandler.onApplicationIdReceived(this.appId);
        }
        this.appResourcesPath = new org.apache.hadoop.fs.Path(fs.getHomeDirectory(), ".tony/" + this.appId.toString());
        this.tonyFinalConfPath = this.processFinalTonyConf();
        this.submitApplication(appContext);
        return this.monitorApplication();
    }

    @VisibleForTesting
    public String processFinalTonyConf() throws IOException, ParseException {
        java.net.URL coreSiteUrl;
        FileSystem fs = FileSystem.get((Configuration)this.hdfsConf);
        if (this.srcDir != null) {
            if (Utils.isArchive(this.srcDir)) {
                Utils.uploadFileAndSetConfResources(this.appResourcesPath, new org.apache.hadoop.fs.Path(this.srcDir), "tony_src.zip", this.tonyConf, fs, LocalResourceType.FILE, TonyConfigurationKeys.getContainerResourcesKey());
            } else {
                Utils.zipFolder(Paths.get(this.srcDir, new String[0]), Paths.get("tony_src.zip", new String[0]));
                Utils.uploadFileAndSetConfResources(this.appResourcesPath, new org.apache.hadoop.fs.Path("tony_src.zip"), "tony_src.zip", this.tonyConf, fs, LocalResourceType.FILE, TonyConfigurationKeys.getContainerResourcesKey());
            }
        }
        if (this.pythonVenv != null) {
            Utils.uploadFileAndSetConfResources(this.appResourcesPath, new org.apache.hadoop.fs.Path(this.pythonVenv), "venv.zip", this.tonyConf, fs, LocalResourceType.FILE, TonyConfigurationKeys.getContainerResourcesKey());
        }
        if ((coreSiteUrl = this.yarnConf.getResource("core-site.xml")) != null) {
            Utils.uploadFileAndSetConfResources(this.appResourcesPath, new org.apache.hadoop.fs.Path(coreSiteUrl.getPath()), "core-site.xml", this.tonyConf, fs, LocalResourceType.FILE, TonyConfigurationKeys.getContainerResourcesKey());
        }
        this.addConfToResources((Configuration)this.yarnConf, this.yarnConfAddress, "yarn-site.xml");
        this.addConfToResources((Configuration)this.hdfsConf, this.hdfsConfAddress, "hdfs-site.xml");
        this.processTonyConfResources(this.tonyConf, fs);
        String tonyFinalConf = Utils.getClientResourcesPath(this.appId.toString(), "tony-final.xml");
        try (FileOutputStream os = new FileOutputStream(tonyFinalConf);){
            this.tonyConf.writeXml((OutputStream)os);
        }
        catch (IOException exception) {
            LOG.error((Object)("Failed to write tony final conf to: " + tonyFinalConf), (Throwable)exception);
        }
        return tonyFinalConf;
    }

    @VisibleForTesting
    public void submitApplication(ApplicationSubmissionContext appContext) throws YarnException, IOException {
        String appName = this.tonyConf.get("tony.application.name", "TonyApplication");
        appContext.setApplicationName(appName);
        String appType = this.tonyConf.get("tony.application.type", "TONY");
        appContext.setApplicationType(appType);
        if (!this.applicationTags.isEmpty()) {
            appContext.setApplicationTags(this.applicationTags);
        }
        Resource capability = Resource.newInstance((int)((int)this.amMemory), (int)this.amVCores);
        Utils.setCapabilityGPU(capability, this.amGpus);
        appContext.setResource(capability);
        String yarnQueue = this.tonyConf.get("tony.yarn.queue", "default");
        appContext.setQueue(yarnQueue);
        ContainerLaunchContext amSpec = this.createAMContainerSpec(this.amMemory, this.getTokens());
        appContext.setAMContainerSpec(amSpec);
        String nodeLabel = this.tonyConf.get("tony.application.node-label");
        if (nodeLabel != null) {
            appContext.setNodeLabelExpression(nodeLabel);
        }
        LOG.info((Object)"Submitting YARN application");
        this.yarnClient.submitApplication(appContext);
        ApplicationReport report = this.yarnClient.getApplicationReport(this.appId);
        this.logTrackingAndRMUrls(report);
    }

    private void addConfToResources(Configuration conf, String confAddress, String confFileName) throws IOException {
        org.apache.hadoop.fs.Path confSitePath = null;
        if (confAddress != null) {
            confSitePath = new org.apache.hadoop.fs.Path(confAddress);
        } else {
            java.net.URL confSiteUrl = conf.getResource(confFileName);
            if (confSiteUrl != null) {
                confSitePath = new org.apache.hadoop.fs.Path(confSiteUrl.getPath());
            }
        }
        if (confSitePath != null) {
            Utils.uploadFileAndSetConfResources(this.appResourcesPath, confSitePath, confFileName, this.tonyConf, FileSystem.get((Configuration)this.hdfsConf), LocalResourceType.FILE, TonyConfigurationKeys.getContainerResourcesKey());
        }
    }

    private void logTrackingAndRMUrls(ApplicationReport report) {
        LOG.info((Object)("URL to track running application (will proxy to TensorBoard once it has started): " + report.getTrackingUrl()));
        LOG.info((Object)("ResourceManager web address for application: " + Utils.buildRMUrl((Configuration)this.yarnConf, report.getApplicationId().toString())));
    }

    private void initHdfsConf() {
        if (System.getenv(Constants.HADOOP_CONF_DIR) != null) {
            this.hdfsConf.addResource(new org.apache.hadoop.fs.Path(System.getenv(Constants.HADOOP_CONF_DIR) + File.separatorChar + "core-site.xml"));
            this.hdfsConf.addResource(new org.apache.hadoop.fs.Path(System.getenv(Constants.HADOOP_CONF_DIR) + File.separatorChar + "hdfs-site.xml"));
        }
        if (this.hdfsConfAddress != null) {
            this.hdfsConf.addResource(new org.apache.hadoop.fs.Path(this.hdfsConfAddress));
        }
    }

    private void createYarnClient() {
        if (System.getenv(Constants.HADOOP_CONF_DIR) != null) {
            this.yarnConf.addResource(new org.apache.hadoop.fs.Path(System.getenv(Constants.HADOOP_CONF_DIR) + File.separatorChar + "core-site.xml"));
            this.yarnConf.addResource(new org.apache.hadoop.fs.Path(System.getenv(Constants.HADOOP_CONF_DIR) + File.separatorChar + "yarn-site.xml"));
        }
        if (this.yarnConfAddress != null) {
            this.yarnConf.addResource(new org.apache.hadoop.fs.Path(this.yarnConfAddress));
        }
        int numRMConnectRetries = this.tonyConf.getInt("tony.application.num-client-rm-connect-retries", 3);
        long rmMaxWaitMS = this.yarnConf.getLong("yarn.resourcemanager.connect.retry-interval.ms", 30000L) * (long)numRMConnectRetries;
        this.yarnConf.setLong("yarn.resourcemanager.connect.max-wait.ms", rmMaxWaitMS);
        this.yarnClient = YarnClient.createYarnClient();
        this.yarnClient.init((Configuration)this.yarnConf);
    }

    private void initOptions() {
        this.opts = Utils.getCommonOptions();
        this.opts.addOption("executes", true, "The file to execute on workers.");
        this.opts.addOption("task_params", true, "The task params to pass into python entry point.");
        this.opts.addOption("shell_env", true, "Environment for shell script, specified as env_key=env_val pairs");
        this.opts.addOption("container_env", true, "Environment for the worker containers, specified as key=val pairs");
        this.opts.addOption("conf", true, "User specified configuration, as key=val pairs");
        this.opts.addOption("conf_file", true, "Name of user specified conf file, on the classpath");
        this.opts.addOption("src_dir", true, "Name of directory of source files.");
        this.opts.addOption("help", false, "Print usage");
    }

    private void printUsage() {
        new HelpFormatter().printHelp("TonyClient", this.opts);
    }

    public boolean init(String[] args) throws ParseException, IOException {
        String[] envs;
        CommandLine cliParser = new GnuParser().parse(this.opts, args, true);
        if (cliParser.hasOption("help")) {
            this.printUsage();
            return false;
        }
        this.initTonyConf(this.tonyConf, cliParser);
        TonyClient.validateTonyConf(this.tonyConf);
        String amMemoryString = this.tonyConf.get("tony.am.memory", "2g");
        this.amMemory = Integer.parseInt(Utils.parseMemoryString(amMemoryString));
        this.amVCores = this.tonyConf.getInt("tony.am.vcores", 1);
        this.amGpus = this.tonyConf.getInt("tony.am.gpus", 0);
        this.secureMode = this.tonyConf.getBoolean("tony.application.security.enabled", true);
        this.hbInterval = this.tonyConf.getInt("tony.task.heartbeat-interval-ms", 1000);
        this.maxHbMisses = this.tonyConf.getInt("tony.task.max-missed-heartbeats", 25);
        LOG.info((Object)("TonY heartbeat interval [" + this.hbInterval + "]"));
        LOG.info((Object)("TonY max heartbeat misses allowed [" + this.maxHbMisses + "]"));
        this.hdfsConfAddress = this.tonyConf.get("tony.application.hdfs-conf-path");
        this.yarnConfAddress = this.tonyConf.get("tony.application.yarn-conf-path");
        this.initHdfsConf();
        this.createYarnClient();
        this.taskParams = cliParser.getOptionValue("task_params");
        this.pythonBinaryPath = cliParser.getOptionValue("python_binary_path");
        this.pythonVenv = cliParser.getOptionValue("python_venv");
        this.executes = cliParser.getOptionValue("executes");
        this.executes = TonyClient.buildTaskCommand(this.pythonVenv, this.pythonBinaryPath, this.executes, this.taskParams);
        if (this.executes != null) {
            this.tonyConf.set(TonyConfigurationKeys.getContainerExecuteCommandKey(), this.executes);
        }
        this.srcDir = cliParser.getOptionValue("src_dir");
        this.applicationTags = new HashSet<String>(this.tonyConf.getStringCollection("tony.application.tags"));
        this.hdfsClasspath = cliParser.getOptionValue("hdfs_classpath");
        if (this.hdfsClasspath != null && !this.hdfsClasspath.startsWith(FileSystem.get((Configuration)this.hdfsConf).getScheme())) {
            this.hdfsClasspath = FileSystem.getDefaultUri((Configuration)this.hdfsConf) + this.hdfsClasspath;
        }
        Utils.appendConfResources(TonyConfigurationKeys.getContainerResourcesKey(), this.hdfsClasspath, this.tonyConf);
        if (this.amMemory < 0L) {
            throw new IllegalArgumentException("Invalid memory specified for application master, exiting. Specified memory=" + this.amMemory);
        }
        if (this.amVCores < 0) {
            throw new IllegalArgumentException("Invalid virtual cores specified for application master, exiting. Specified virtual cores=" + this.amVCores);
        }
        if (Utils.getNumTotalTasks(this.tonyConf) == 0 && this.amGpus > 0) {
            LOG.warn((Object)("It seems you reserved " + this.amGpus + " GPUs in application master (driver, which doesn't perform training) during distributed training."));
        }
        this.appTimeout = this.tonyConf.getInt("tony.application.timeout", 0);
        ArrayList<String> executionEnvPair = new ArrayList<String>();
        if (this.tonyConf.get("tony.execution.envs") != null) {
            envs = this.tonyConf.getStrings("tony.execution.envs");
            executionEnvPair.addAll(Arrays.asList(envs));
        }
        if (cliParser.hasOption("shell_env")) {
            envs = cliParser.getOptionValues("shell_env");
            executionEnvPair.addAll(Arrays.asList(envs));
        }
        if (!executionEnvPair.isEmpty()) {
            this.tonyConf.setStrings("tony.execution.envs", executionEnvPair.toArray(new String[0]));
        }
        Map<String, String> dockerEnv = Utils.getContainerEnvForDocker(this.tonyConf, "am");
        this.containerEnv.putAll(dockerEnv);
        ArrayList<String> containerEnvPair = new ArrayList<String>();
        if (this.tonyConf.get("tony.containers.envs") != null) {
            String[] envs2 = this.tonyConf.getStrings("tony.containers.envs");
            containerEnvPair.addAll(Arrays.asList(envs2));
            this.containerEnv.putAll(Utils.parseKeyValue(envs2));
        }
        if (cliParser.hasOption("container_env")) {
            String[] containerEnvs = cliParser.getOptionValues("container_env");
            containerEnvPair.addAll(Arrays.asList(containerEnvs));
            this.containerEnv.putAll(Utils.parseKeyValue(containerEnvs));
        }
        if (!this.containerEnv.isEmpty()) {
            this.tonyConf.setStrings("tony.containers.envs", containerEnvPair.toArray(new String[0]));
        }
        return true;
    }

    @VisibleForTesting
    static String buildTaskCommand(String pythonVenv, String pythonBinaryPath, String execute, String taskParams) {
        if (execute == null) {
            return null;
        }
        String baseTaskCommand = execute;
        if (pythonBinaryPath != null) {
            String pythonInterpreter = pythonBinaryPath.startsWith("/") || pythonVenv == null ? pythonBinaryPath : "venv" + File.separatorChar + pythonBinaryPath;
            baseTaskCommand = pythonInterpreter + " " + execute;
        }
        if (taskParams != null) {
            baseTaskCommand = baseTaskCommand + " " + taskParams;
        }
        return baseTaskCommand;
    }

    public void initTonyConf(Configuration tonyConf, CommandLine cliParser) throws IOException {
        String tonyConfDir;
        tonyConf.addResource("tony-default.xml");
        if (cliParser.hasOption("conf_file")) {
            org.apache.hadoop.fs.Path confFilePath = new org.apache.hadoop.fs.Path(cliParser.getOptionValue("conf_file"));
            if (confFilePath.toUri().getScheme() == null) {
                tonyConf.addResource(confFilePath);
            } else {
                tonyConf.addResource((InputStream)confFilePath.getFileSystem((Configuration)this.hdfsConf).open(confFilePath));
            }
        } else {
            tonyConf.addResource("tony.xml");
        }
        if (cliParser.hasOption("conf")) {
            String[] confs = cliParser.getOptionValues("conf");
            for (Map.Entry<String, String> cliConf : Utils.parseKeyValue(confs).entrySet()) {
                String[] existingValue = tonyConf.getStrings(cliConf.getKey());
                if (existingValue != null && TonyConfigurationKeys.MULTI_VALUE_CONF.contains(cliConf.getKey())) {
                    ArrayList<String> newValues = new ArrayList<String>(Arrays.asList(existingValue));
                    newValues.add(cliConf.getValue());
                    tonyConf.setStrings(cliConf.getKey(), newValues.toArray(new String[0]));
                    continue;
                }
                tonyConf.set(cliConf.getKey(), cliConf.getValue());
            }
        }
        if ((tonyConfDir = System.getenv("TONY_CONF_DIR")) == null) {
            tonyConfDir = "/export/apps/tony/conf";
        }
        tonyConf.addResource(new org.apache.hadoop.fs.Path(tonyConfDir + File.separatorChar + "tony-site.xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void processTonyConfResources(Configuration tonyConf, FileSystem fs) throws IOException, ParseException {
        Set resourceKeys = tonyConf.getValByRegex("tony\\.([a-z]+)\\.resources").keySet();
        for (String resourceKey : resourceKeys) {
            String[] resources = tonyConf.getStrings(resourceKey);
            if (resources == null) continue;
            for (String resource : resources) {
                LocalizableResource lr = new LocalizableResource(resource, fs);
                if (!lr.isLocalFile()) continue;
                org.apache.hadoop.fs.Path localFilePath = lr.getSourceFilePath();
                File file = new File(localFilePath.toString());
                if (!file.exists()) {
                    LOG.fatal((Object)(localFilePath + " doesn't exist in local filesystem"));
                    throw new IOException(localFilePath + " doesn't exist in local filesystem.");
                }
                if (file.isFile()) {
                    if (lr.isArchive()) {
                        Utils.uploadFileAndSetConfResources(this.appResourcesPath, localFilePath, lr.getLocalizedFileName(), tonyConf, fs, LocalResourceType.ARCHIVE, resourceKey);
                        continue;
                    }
                    Utils.uploadFileAndSetConfResources(this.appResourcesPath, localFilePath, lr.getLocalizedFileName(), tonyConf, fs, LocalResourceType.FILE, resourceKey);
                    continue;
                }
                File tmpDir = Files.createTempDir();
                tmpDir.deleteOnExit();
                try {
                    Path dest = Paths.get(tmpDir.getAbsolutePath(), file.getName());
                    Utils.zipFolder(Paths.get(resource, new String[0]), dest);
                    Utils.uploadFileAndSetConfResources(this.appResourcesPath, new org.apache.hadoop.fs.Path(dest.toString()), lr.getLocalizedFileName(), tonyConf, fs, LocalResourceType.ARCHIVE, resourceKey);
                }
                finally {
                    try {
                        FileUtils.deleteDirectory((File)tmpDir);
                    }
                    catch (IOException ex) {
                        LOG.warn((Object)("Failed to delete temp directory " + tmpDir), (Throwable)ex);
                    }
                }
            }
            resources = tonyConf.getStrings(resourceKey);
            resources = (String[])Stream.of(resources).filter(filePath -> new org.apache.hadoop.fs.Path(filePath).toUri().getScheme() != null).toArray(String[]::new);
            tonyConf.setStrings(resourceKey, resources);
        }
    }

    @VisibleForTesting
    static void validateTonyConf(Configuration tonyConf) {
        TonyClient.enforceTaskInstanceLimits(tonyConf);
        TonyClient.enforceResourceLimits(tonyConf);
    }

    private static void enforceTaskInstanceLimits(Configuration tonyConf) {
        Map<String, JobContainerRequest> containerRequestMap = Utils.parseContainerRequests(tonyConf);
        for (Map.Entry<String, JobContainerRequest> entry : containerRequestMap.entrySet()) {
            int numInstancesRequested = entry.getValue().getNumInstances();
            int maxAllowedInstances = tonyConf.getInt(TonyConfigurationKeys.getMaxInstancesKey(entry.getKey()), -1);
            if (maxAllowedInstances < 0 || numInstancesRequested <= maxAllowedInstances) continue;
            throw new RuntimeException("Job requested " + numInstancesRequested + " " + entry.getKey() + " task instances but the limit is " + maxAllowedInstances + " " + entry.getKey() + " task instances.");
        }
        int maxTotalInstances = tonyConf.getInt("tony.task.max-total-instances", -1);
        int totalRequestedInstances = containerRequestMap.values().stream().mapToInt(JobContainerRequest::getNumInstances).sum();
        if (maxTotalInstances >= 0 && totalRequestedInstances > maxTotalInstances) {
            throw new RuntimeException("Job requested " + totalRequestedInstances + " total task instances but limit is " + maxTotalInstances + ".");
        }
    }

    private static void enforceResourceLimits(Configuration tonyConf) {
        Set<String> jobTypes = Utils.getAllJobTypes(tonyConf);
        for (Map.Entry entry : tonyConf.getValByRegex("tony.task.max-total-([a-z]+)").entrySet()) {
            Pattern pattern;
            Matcher matcher;
            String maxResourceKey = (String)entry.getKey();
            long maxResourceValue = Long.parseLong((String)entry.getValue());
            if (maxResourceValue < 0L || !(matcher = (pattern = Pattern.compile("tony.task.max-total-([a-z]+)")).matcher(maxResourceKey)).matches()) continue;
            String resource = matcher.group(1);
            long totalRequested = 0L;
            for (String jobType : jobTypes) {
                int instances = tonyConf.getInt(TonyConfigurationKeys.getInstancesKey(jobType), 0);
                String value = tonyConf.get(TonyConfigurationKeys.getResourceKey(jobType, resource), null);
                if (value == null) continue;
                long amountPerTask = resource.equals("memory") ? Long.parseLong(Utils.parseMemoryString(value)) : Long.parseLong(value);
                totalRequested += amountPerTask * (long)instances;
            }
            if (totalRequested <= maxResourceValue) continue;
            throw new RuntimeException("Total amount of " + resource + " (" + totalRequested + ") requested exceeds maximum allowed of " + maxResourceValue);
        }
    }

    public Configuration getTonyConf() {
        return this.tonyConf;
    }

    public ContainerLaunchContext createAMContainerSpec(long amMemory, ByteBuffer tokens) throws IOException {
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        FileSystem fs = FileSystem.get((Configuration)this.hdfsConf);
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        this.addResource(fs, this.tonyFinalConfPath, LocalResourceType.FILE, "tony-final.xml", localResources);
        String[] amResources = this.tonyConf.getStrings(TonyConfigurationKeys.getResourcesKey("am"));
        Utils.addResources(amResources, localResources, fs);
        amResources = this.tonyConf.getStrings(TonyConfigurationKeys.getContainerResourcesKey());
        Utils.addResources(amResources, localResources, fs);
        this.setAMEnvironment(localResources, fs);
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>(2);
        acls.put(ApplicationAccessType.VIEW_APP, "*");
        acls.put(ApplicationAccessType.MODIFY_APP, " ");
        amContainer.setApplicationACLs(acls);
        String command = this.buildCommand(amMemory);
        LOG.info((Object)("Completed setting up Application Master command " + command));
        amContainer.setCommands((List)ImmutableList.of((Object)command));
        if (tokens != null) {
            amContainer.setTokens(tokens);
        }
        amContainer.setEnvironment(this.containerEnv);
        amContainer.setLocalResources(localResources);
        return amContainer;
    }

    @VisibleForTesting
    String buildCommand(long amMemory) {
        ArrayList<String> arguments = new ArrayList<String>(30);
        arguments.add(ApplicationConstants.Environment.JAVA_HOME.$$() + "/bin/java");
        arguments.add("-Xmx" + (int)((float)amMemory * 0.8f) + "m");
        arguments.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        String amJvm = this.tonyConf.get("tony.task.am.jvm.opts");
        if (StringUtils.isNotBlank((CharSequence)amJvm)) {
            arguments.add(amJvm);
        }
        arguments.add("com.linkedin.tony.ApplicationMaster");
        arguments.add("1><LOG_DIR>" + File.separatorChar + "amstdout.log");
        arguments.add("2><LOG_DIR>" + File.separatorChar + "amstderr.log");
        return String.join((CharSequence)" ", arguments);
    }

    private void addResource(FileSystem fs, String srcPath, LocalResourceType resourceType, String dstPath, Map<String, LocalResource> localResources) throws IOException {
        org.apache.hadoop.fs.Path src = new org.apache.hadoop.fs.Path(srcPath);
        org.apache.hadoop.fs.Path dst = new org.apache.hadoop.fs.Path(this.appResourcesPath, dstPath);
        HdfsUtils.copySrcToDest(src, dst, (Configuration)this.hdfsConf);
        fs.setPermission(dst, new FsPermission(504));
        FileStatus scFileStatus = fs.getFileStatus(dst);
        LocalResource scRsrc = LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromURI((URI)dst.toUri()), (LocalResourceType)resourceType, (LocalResourceVisibility)LocalResourceVisibility.PRIVATE, (long)scFileStatus.getLen(), (long)scFileStatus.getModificationTime());
        localResources.put(dstPath, scRsrc);
    }

    private void setAMEnvironment(Map<String, LocalResource> localResources, FileSystem fs) throws IOException {
        LocalResource tonyConfResource = localResources.get("tony-final.xml");
        Utils.addEnvironmentForResource(tonyConfResource, fs, "TONY_CONF", this.containerEnv);
        StringBuilder classPathEnv = new StringBuilder(ApplicationConstants.Environment.CLASSPATH.$$()).append("<CPS>").append("./*");
        for (String c : this.yarnConf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_CROSS_PLATFORM_APPLICATION_CLASSPATH)) {
            classPathEnv.append("<CPS>");
            classPathEnv.append(c.trim());
        }
        this.containerEnv.put("CLASSPATH", classPathEnv.toString());
    }

    private ByteBuffer getTokens() throws IOException, YarnException {
        if (!this.secureMode) {
            return null;
        }
        LOG.info((Object)"Running with secure cluster mode. Fetching delegation tokens..");
        Credentials cred = new Credentials();
        String fileLocation = System.getenv("HADOOP_TOKEN_FILE_LOCATION");
        if (fileLocation != null) {
            cred = Credentials.readTokenStorageFile((File)new File(fileLocation), (Configuration)this.hdfsConf);
        } else {
            String[] otherNamenodes;
            LOG.info((Object)"Fetching RM delegation token..");
            String tokenRenewer = TonyClient.getRmPrincipal((Configuration)this.yarnConf);
            if (tokenRenewer == null) {
                throw new RuntimeException("Failed to get RM principal.");
            }
            Token rmToken = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)this.yarnClient.getRMDelegationToken(new Text(tokenRenewer)), (InetSocketAddress)this.yarnConf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032));
            cred.addToken(rmToken.getService(), rmToken);
            LOG.info((Object)"RM delegation token fetched.");
            LOG.info((Object)"Fetching HDFS delegation tokens for default, history and other namenodes...");
            ArrayList<org.apache.hadoop.fs.Path> pathList = new ArrayList<org.apache.hadoop.fs.Path>();
            pathList.add(this.appResourcesPath);
            String tonyHistoryLocation = this.tonyConf.get("tony.history.location");
            if (tonyHistoryLocation != null) {
                pathList.add(new org.apache.hadoop.fs.Path(tonyHistoryLocation));
            }
            if ((otherNamenodes = this.tonyConf.getStrings("tony.other.namenodes")) != null) {
                for (String nnUri : otherNamenodes) {
                    pathList.add(new org.apache.hadoop.fs.Path(nnUri.trim()));
                }
            }
            org.apache.hadoop.fs.Path[] paths = pathList.toArray(new org.apache.hadoop.fs.Path[0]);
            TokenCache.obtainTokensForNamenodes(cred, paths, (Configuration)this.hdfsConf, tokenRenewer);
            LOG.info((Object)"Fetched HDFS delegation token.");
        }
        LOG.info((Object)"Successfully fetched tokens.");
        DataOutputBuffer buffer = new DataOutputBuffer();
        cred.writeTokenStorageToStream((DataOutputStream)buffer);
        return ByteBuffer.wrap(buffer.getData(), 0, buffer.getLength());
    }

    @VisibleForTesting
    public boolean monitorApplication() throws YarnException, IOException, InterruptedException {
        boolean result;
        block4: {
            do {
                Thread.sleep(1000L);
                ApplicationReport report = this.yarnClient.getApplicationReport(this.appId);
                YarnApplicationState appState = report.getYarnApplicationState();
                FinalApplicationStatus finalApplicationStatus = report.getFinalApplicationStatus();
                this.initRpcClientAndLogAMUrl(report);
                this.updateTaskInfos();
                if (YarnApplicationState.KILLED == appState) {
                    LOG.warn((Object)("Application " + this.appId.getId() + " was killed. YarnState: " + appState + ". FinalApplicationStatus = " + finalApplicationStatus + "."));
                    this.amRpcClient = null;
                    result = false;
                } else {
                    if (YarnApplicationState.FINISHED != appState && YarnApplicationState.FAILED != appState) continue;
                    this.updateTaskInfos();
                    LOG.info((Object)("Application " + this.appId.getId() + " finished with YarnState=" + appState + ", DSFinalStatus=" + finalApplicationStatus + ", breaking monitoring loop."));
                    String tonyPortalUrl = this.tonyConf.get("tony.portal.url", "https://localhost:19886");
                    Utils.printTonyPortalUrl(tonyPortalUrl, this.appId.toString(), LOG);
                    result = FinalApplicationStatus.SUCCEEDED == finalApplicationStatus;
                }
                break block4;
            } while (this.appTimeout <= 0L || System.currentTimeMillis() <= this.clientStartTime + this.appTimeout);
            LOG.info((Object)("Reached client specified timeout for application. Killing application. Breaking monitoring loop : ApplicationId:" + this.appId.getId()));
            this.forceKillApplication();
            result = false;
        }
        if (this.amRpcClient != null) {
            this.amRpcClient.finishApplication();
            LOG.info((Object)"Sent message to AM to stop.");
            this.amRpcClient = null;
        }
        return result;
    }

    private void updateTaskInfos() throws IOException, YarnException {
        if (this.amRpcClient != null) {
            Set<TaskInfo> receivedInfos = this.amRpcClient.getTaskInfos();
            Set taskInfoDiff = receivedInfos.stream().filter(taskInfo -> !this.taskInfos.contains(taskInfo)).collect(Collectors.toSet());
            if (!taskInfoDiff.isEmpty()) {
                for (TaskInfo taskInfo2 : taskInfoDiff) {
                    LOG.info((Object)("Task status updated: " + taskInfo2));
                }
                for (TaskUpdateListener listener : this.listeners) {
                    listener.onTaskInfosUpdated(receivedInfos);
                }
                this.taskInfos = receivedInfos;
            }
            if (this.amRpcServerInitialized && !this.isTaskUrlsPrinted && !this.taskInfos.isEmpty()) {
                new TreeSet<TaskInfo>(this.taskInfos).forEach(task -> Utils.printTaskUrl(task, LOG));
                this.isTaskUrlsPrinted = true;
            }
        }
    }

    private void initRpcClientAndLogAMUrl(ApplicationReport report) throws IOException {
        if (!this.amRpcServerInitialized && report.getRpcPort() != -1) {
            try {
                ContainerReport amContainerReport = this.yarnClient.getContainers(report.getCurrentApplicationAttemptId()).stream().min(Comparator.comparingLong(x -> x.getContainerId().getContainerId())).orElseThrow(YarnException::new);
                LOG.info((Object)("Driver (application master) log url: " + amContainerReport.getLogUrl()));
            }
            catch (IOException | YarnException e) {
                LOG.warn((Object)("Failed to get containers for attemptId: " + report.getCurrentApplicationAttemptId()), e);
            }
            this.amRpcPort = report.getRpcPort();
            this.amHost = report.getHost();
            LOG.info((Object)("AM host: " + report.getHost()));
            LOG.info((Object)("AM RPC port: " + report.getRpcPort()));
            this.addClientToAMTokenToUGI(report);
            this.amRpcClient = ApplicationRpcClient.getInstance(this.amHost, this.amRpcPort, (Configuration)this.yarnConf);
            this.amRpcServerInitialized = true;
        }
    }

    private void addClientToAMTokenToUGI(ApplicationReport report) throws IOException {
        InetSocketAddress serviceAddr = NetUtils.createSocketAddrForHost((String)report.getHost(), (int)report.getRpcPort());
        if (UserGroupInformation.isSecurityEnabled()) {
            org.apache.hadoop.yarn.api.records.Token clientToAMToken = report.getClientToAMToken();
            Token token = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)clientToAMToken, (InetSocketAddress)serviceAddr);
            UserGroupInformation.getCurrentUser().addToken(token);
        }
    }

    public void forceKillApplication() throws YarnException, IOException {
        if (this.appId != null) {
            this.yarnClient.killApplication(this.appId);
        }
    }

    @VisibleForTesting
    public CopyOnWriteArrayList<TaskUpdateListener> getListener() {
        return this.listeners;
    }

    protected ApplicationRpcClient getAMRpcClient() {
        return this.amRpcClient;
    }

    @Override
    public void close() {
        Utils.cleanupHDFSPath((Configuration)this.hdfsConf, this.appResourcesPath);
    }

    @VisibleForTesting
    public int start() {
        boolean result;
        try {
            result = this.run();
        }
        catch (IOException | InterruptedException | URISyntaxException | ParseException | YarnException e) {
            LOG.fatal((Object)"Failed to run TonyClient", e);
            result = false;
        }
        if (result) {
            LOG.info((Object)"Application completed successfully");
            return 0;
        }
        LOG.error((Object)"Application failed to complete successfully");
        return -1;
    }

    public static String getRmPrincipal(Configuration conf) throws IOException {
        String principal = conf.get("yarn.resourcemanager.principal");
        String prepared = null;
        if (principal != null) {
            prepared = TonyClient.getRmPrincipal(principal, conf);
        }
        return prepared;
    }

    public static String getRmPrincipal(String rmPrincipal, Configuration conf) throws IOException {
        if (rmPrincipal == null) {
            throw new IllegalArgumentException("RM principal string is null");
        }
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            conf = TonyClient.getYarnConfWithRmHaId(conf);
        }
        String hostname = conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032).getHostName();
        return SecurityUtil.getServerPrincipal((String)rmPrincipal, (String)hostname);
    }

    @VisibleForTesting
    static YarnConfiguration getYarnConfWithRmHaId(Configuration conf) throws IOException {
        YarnConfiguration yarnConf = new YarnConfiguration(conf);
        if (yarnConf.get("yarn.resourcemanager.ha.id") == null) {
            String[] rmIds = yarnConf.getStrings("yarn.resourcemanager.ha.rm-ids");
            if (rmIds != null && rmIds.length > 0) {
                yarnConf.set("yarn.resourcemanager.ha.id", rmIds[0]);
            } else {
                throw new IOException("RM_HA_IDS property is not set for HA resource manager");
            }
        }
        return yarnConf;
    }

    public void addListener(TaskUpdateListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TaskUpdateListener listener) {
        this.listeners.remove(listener);
    }

    public static void main(String[] args) {
        int exitCode;
        HadoopConfigurationInjector.injectResources((Props)new Props());
        try (TonyClient client = new TonyClient(new Configuration());){
            boolean sanityCheck = client.init(args);
            if (!sanityCheck) {
                LOG.fatal((Object)"Failed to init client.");
                exitCode = -1;
            } else {
                exitCode = client.start();
            }
        }
        catch (IOException | ParseException e) {
            LOG.fatal((Object)"Encountered exception while initializing client or finishing application.", e);
            exitCode = -1;
        }
        System.exit(exitCode);
    }
}

