/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class LocalizableResource {
    private String completeResourceString;
    private boolean isDirectory;
    private LocalResourceType resourceType;
    private FileStatus sourceFileStatus;
    private Path sourceFilePath;
    private String localizedFileName;

    private LocalizableResource() {
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isLocalFile() {
        return new Path(this.completeResourceString).toUri().getScheme() == null;
    }

    public boolean isArchive() {
        return this.resourceType == LocalResourceType.ARCHIVE;
    }

    public Path getSourceFilePath() {
        return this.sourceFilePath;
    }

    public String getLocalizedFileName() {
        return this.localizedFileName;
    }

    public LocalizableResource(String completeResourceString, FileSystem fs) throws ParseException, IOException {
        this.completeResourceString = completeResourceString;
        this.parse(fs);
    }

    private void parse(FileSystem fs) throws ParseException, IOException {
        String[] tuple;
        String filePath = this.completeResourceString;
        this.resourceType = LocalResourceType.FILE;
        if (this.completeResourceString.toLowerCase().endsWith("#archive")) {
            this.resourceType = LocalResourceType.ARCHIVE;
            filePath = this.completeResourceString.substring(0, this.completeResourceString.length() - "#archive".length());
        }
        if ((tuple = filePath.split("::")).length > 2) {
            throw new ParseException("Failed to parse file: " + this.completeResourceString);
        }
        this.sourceFilePath = new Path(tuple[0]);
        if (this.isLocalFile()) {
            LocalFileSystem localFs = FileSystem.getLocal((Configuration)fs.getConf());
            this.sourceFileStatus = localFs.getFileStatus(this.sourceFilePath);
        } else {
            this.sourceFileStatus = fs.getFileStatus(this.sourceFilePath);
        }
        this.localizedFileName = this.sourceFilePath.getName();
        if (tuple.length == 2) {
            this.localizedFileName = tuple[1];
        }
        if (this.sourceFileStatus.isDirectory()) {
            this.isDirectory = true;
        }
    }

    public LocalResource toLocalResource() {
        if (this.isDirectory) {
            throw new RuntimeException("Resource is directory and cannot be converted to LocalResource.");
        }
        return LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromURI((URI)URI.create(this.sourceFileStatus.getPath().toString())), (LocalResourceType)this.resourceType, (LocalResourceVisibility)LocalResourceVisibility.PRIVATE, (long)this.sourceFileStatus.getLen(), (long)this.sourceFileStatus.getModificationTime());
    }
}

