/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.client.cli.remote;

import org.apache.submarine.client.cli.remote.JobSubmitterRpcImpl;
import org.apache.submarine.commons.runtime.ClientContext;
import org.apache.submarine.commons.runtime.JobMonitor;
import org.apache.submarine.commons.runtime.JobSubmitter;
import org.apache.submarine.commons.runtime.RuntimeFactory;
import org.apache.submarine.commons.runtime.fs.MemorySubmarineStorage;
import org.apache.submarine.commons.runtime.fs.SubmarineStorage;
import org.apache.submarine.commons.utils.SubmarineConfVars;

public class RpcRuntimeFactory
extends RuntimeFactory {
    private JobSubmitterRpcImpl submitter;

    public RpcRuntimeFactory(ClientContext clientContext) {
        super(clientContext);
        String remoteHost = clientContext.getSubmarineConfig().getServerAddress();
        int port = clientContext.getSubmarineConfig().getInt(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_RPC_PORT);
        this.submitter = new JobSubmitterRpcImpl(remoteHost, port, clientContext);
    }

    protected JobSubmitter internalCreateJobSubmitter() {
        return this.submitter;
    }

    protected JobMonitor internalCreateJobMonitor() {
        return null;
    }

    protected SubmarineStorage internalCreateSubmarineStorage() {
        return new MemorySubmarineStorage();
    }
}

