/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.client.cli.remote;

import java.util.HashMap;
import java.util.Map;
import org.apache.submarine.commons.runtime.ClientContext;
import org.apache.submarine.commons.utils.SubmarineConfVars;
import org.apache.submarine.commons.utils.SubmarineConfiguration;

public class RpcContext {
    private Map<String, String> submarineJobConfigMap = new HashMap<String, String>();

    public static RpcContext convertClientContextToRpcContext(ClientContext clientContext) {
        SubmarineConfiguration submarineConfig = clientContext.getSubmarineConfig();
        RpcContext rpcContext = new RpcContext();
        rpcContext.addSubmarineJobConfiguration(rpcContext, submarineConfig);
        return rpcContext;
    }

    private void addSubmarineJobConfiguration(RpcContext rpcContext, SubmarineConfiguration submarineConfig) {
        rpcContext.getSubmarineJobConfigMap().put(SubmarineConfVars.ConfVars.SUBMARINE_RUNTIME_CLASS.getVarName(), submarineConfig.getString(SubmarineConfVars.ConfVars.SUBMARINE_RUNTIME_CLASS));
    }

    public Map<String, String> getSubmarineJobConfigMap() {
        return this.submarineJobConfigMap;
    }

    public RpcContext setSubmarineJobConfigMap(Map<String, String> submarineJobConfigMap) {
        this.submarineJobConfigMap = submarineJobConfigMap;
        return this;
    }
}

