/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.client.cli.remote;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.submarine.client.cli.remote.ClientProto;
import org.apache.submarine.client.cli.remote.RpcContext;
import org.apache.submarine.commons.rpc.ApplicationIdProto;
import org.apache.submarine.commons.rpc.ParameterProto;
import org.apache.submarine.commons.rpc.SubmarineServerProtocolGrpc;
import org.apache.submarine.commons.runtime.ClientContext;
import org.apache.submarine.commons.runtime.JobSubmitter;
import org.apache.submarine.commons.runtime.param.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSubmitterRpcImpl
implements JobSubmitter {
    private static final Logger LOG = LoggerFactory.getLogger((String)JobSubmitterRpcImpl.class.getName());
    private final ManagedChannel channel;
    private final SubmarineServerProtocolGrpc.SubmarineServerProtocolBlockingStub blockingStub;
    private final SubmarineServerProtocolGrpc.SubmarineServerProtocolStub asyncStub;
    private final RpcContext rpcContext;

    public JobSubmitterRpcImpl(String host, int port, ClientContext clientContext) {
        this(ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext(), clientContext);
    }

    public JobSubmitterRpcImpl(ManagedChannelBuilder<?> channelBuilder, ClientContext clientContext) {
        this.channel = channelBuilder.build();
        this.blockingStub = SubmarineServerProtocolGrpc.newBlockingStub((Channel)this.channel);
        this.asyncStub = SubmarineServerProtocolGrpc.newStub((Channel)this.channel);
        this.rpcContext = RpcContext.convertClientContextToRpcContext(clientContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationId submitJob(Parameter parameters) throws IOException, YarnException {
        ParameterProto request = ClientProto.convertParameterToParameterProto(parameters, this.rpcContext);
        ApplicationId applicationId = null;
        try {
            ApplicationIdProto applicationIdProto = this.blockingStub.submitJob(request);
            applicationId = ClientProto.convertApplicationIdProtoToApplicationId(applicationIdProto);
        }
        catch (StatusRuntimeException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.shutdown();
        }
        return applicationId;
    }

    public void shutdown() {
        try {
            this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

