/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.client.cli.param.runjob;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.submarine.client.cli.CliUtils;
import org.apache.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.submarine.client.cli.runjob.RoleParameters;
import org.apache.submarine.commons.runtime.ClientContext;
import org.apache.submarine.commons.runtime.api.Role;
import org.apache.submarine.commons.runtime.api.TensorFlowRole;
import org.apache.submarine.commons.runtime.param.Parameter;
import org.apache.submarine.commons.runtime.resource.ResourceUtils;

public class TensorFlowRunJobParameters
extends RunJobParameters {
    private boolean tensorboardEnabled;
    private static final String CANNOT_BE_DEFINED_FOR_TF = "cannot be defined for TensorFlow jobs!";
    private RoleParameters psParameters = RoleParameters.createEmpty((Role)TensorFlowRole.PS);
    private RoleParameters tensorBoardParameters = RoleParameters.createEmpty((Role)TensorFlowRole.TENSORBOARD);

    @Override
    public void updateParameters(Parameter parametersHolder, ClientContext clientContext) throws ParseException, IOException, YarnException {
        this.checkArguments(parametersHolder);
        super.updateParameters(parametersHolder, clientContext);
        String input = parametersHolder.getOptionValue("input_path");
        this.workerParameters = this.generateWorkerParameters(clientContext, parametersHolder, input);
        this.psParameters = this.getPSParameters(clientContext, parametersHolder);
        this.distributed = this.determineIfDistributed(this.workerParameters.getReplicas(), this.psParameters.getReplicas());
        if (parametersHolder.hasOption("tensorboard")) {
            this.tensorboardEnabled = true;
            this.tensorBoardParameters = this.getTensorBoardParameters(parametersHolder, clientContext);
        }
        this.executePostOperations(clientContext);
    }

    @Override
    void executePostOperations(ClientContext clientContext) throws IOException {
        this.setDefaultDirs(clientContext);
        this.replacePatternsInParameters(clientContext);
    }

    private void checkArguments(Parameter parametersHolder) throws YarnException, ParseException {
        if (parametersHolder.getOptionValue("num_schedulers") != null) {
            throw new ParseException(this.getParamCannotBeDefinedErrorMessage("num_schedulers"));
        }
        if (parametersHolder.getOptionValue("scheduler_resources") != null) {
            throw new ParseException(this.getParamCannotBeDefinedErrorMessage("scheduler_resources"));
        }
        if (parametersHolder.getOptionValue("scheduler_docker_image") != null) {
            throw new ParseException(this.getParamCannotBeDefinedErrorMessage("scheduler_docker_image"));
        }
        if (parametersHolder.getOptionValue("scheduler_launch_cmd") != null) {
            throw new ParseException(this.getParamCannotBeDefinedErrorMessage("scheduler_launch_cmd"));
        }
    }

    private String getParamCannotBeDefinedErrorMessage(String cliName) {
        return String.format("Parameter '%s' cannot be defined for TensorFlow jobs!", cliName);
    }

    private void replacePatternsInParameters(ClientContext clientContext) throws IOException {
        String afterReplace;
        if (StringUtils.isNotEmpty((CharSequence)this.getPSLaunchCmd())) {
            afterReplace = CliUtils.replacePatternsInLaunchCommand(this.getPSLaunchCmd(), this, clientContext.getRemoteDirectoryManager());
            this.setPSLaunchCmd(afterReplace);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getWorkerLaunchCmd())) {
            afterReplace = CliUtils.replacePatternsInLaunchCommand(this.getWorkerLaunchCmd(), this, clientContext.getRemoteDirectoryManager());
            this.setWorkerLaunchCmd(afterReplace);
        }
    }

    @Override
    public List<String> getLaunchCommands() {
        return Lists.newArrayList((Object[])new String[]{this.getWorkerLaunchCmd(), this.getPSLaunchCmd()});
    }

    private boolean determineIfDistributed(int nWorkers, int nPS) throws ParseException {
        if (nWorkers >= 2 && nPS > 0) {
            return true;
        }
        if (nWorkers <= 1 && nPS > 0) {
            throw new ParseException("Only specified one worker but non-zero PS, please double check.");
        }
        return false;
    }

    private RoleParameters getPSParameters(ClientContext clientContext, Parameter parametersHolder) throws YarnException, IOException, ParseException {
        int nPS = this.getNumberOfPS(parametersHolder);
        Resource psResource = this.determinePSResource(parametersHolder, nPS, clientContext);
        String psDockerImage = parametersHolder.getOptionValue("ps_docker_image");
        String psLaunchCommand = parametersHolder.getOptionValue("ps_launch_cmd");
        return new RoleParameters((Role)TensorFlowRole.PS, nPS, psLaunchCommand, psDockerImage, psResource);
    }

    private Resource determinePSResource(Parameter parametersHolder, int nPS, ClientContext clientContext) throws ParseException, YarnException, IOException {
        if (nPS > 0) {
            String psResourceStr = parametersHolder.getOptionValue("ps_resources");
            if (psResourceStr == null) {
                throw new ParseException("--ps_resources is absent.");
            }
            return ResourceUtils.createResourceFromString((String)psResourceStr);
        }
        return null;
    }

    private int getNumberOfPS(Parameter parametersHolder) throws YarnException {
        int nPS = 0;
        if (parametersHolder.getOptionValue("num_ps") != null) {
            nPS = Integer.parseInt(parametersHolder.getOptionValue("num_ps"));
        }
        return nPS;
    }

    private RoleParameters getTensorBoardParameters(Parameter parametersHolder, ClientContext clientContext) throws YarnException, IOException {
        String tensorboardResourceStr = parametersHolder.getOptionValue("tensorboard_resources");
        if (tensorboardResourceStr == null || tensorboardResourceStr.isEmpty()) {
            tensorboardResourceStr = "memory=4G,vcores=1";
        }
        Resource tensorboardResource = ResourceUtils.createResourceFromString((String)tensorboardResourceStr);
        String tensorboardDockerImage = parametersHolder.getOptionValue("tensorboard_docker_image");
        return new RoleParameters((Role)TensorFlowRole.TENSORBOARD, 1, null, tensorboardDockerImage, tensorboardResource);
    }

    public RoleParameters getPsParameters() {
        return this.psParameters;
    }

    public void setPsParameters(RoleParameters parameters) {
        this.psParameters = parameters;
    }

    public int getNumPS() {
        return this.psParameters.getReplicas();
    }

    public void setNumPS(int numPS) {
        this.psParameters.setReplicas(numPS);
    }

    public Resource getPsResource() {
        return this.psParameters.getResource();
    }

    public void setPsResource(Resource resource) {
        this.psParameters.setResource(resource);
    }

    public String getPsDockerImage() {
        return this.psParameters.getDockerImage();
    }

    public void setPsDockerImage(String image) {
        this.psParameters.setDockerImage(image);
    }

    public String getPSLaunchCmd() {
        return this.psParameters.getLaunchCommand();
    }

    public void setPSLaunchCmd(String launchCmd) {
        this.psParameters.setLaunchCommand(launchCmd);
    }

    public RoleParameters getTensorBoardParameters() {
        return this.tensorBoardParameters;
    }

    public void setTensorBoardParameters(RoleParameters tensorBoardParameters) {
        this.tensorBoardParameters = tensorBoardParameters;
    }

    public boolean isTensorboardEnabled() {
        return this.tensorboardEnabled;
    }

    public void setTensorboardEnabled(boolean tensorboardEnabled) {
        this.tensorboardEnabled = tensorboardEnabled;
    }

    public Resource getTensorboardResource() {
        return this.tensorBoardParameters.getResource();
    }

    public void setTensorboardResource(Resource resource) {
        this.tensorBoardParameters.setResource(resource);
    }

    public String getTensorboardDockerImage() {
        return this.tensorBoardParameters.getDockerImage();
    }

    public void setTensorboardDockerImage(String image) {
        this.tensorBoardParameters.setDockerImage(image);
    }
}

