/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.client.cli.param.runjob;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.submarine.client.cli.CliUtils;
import org.apache.submarine.client.cli.param.Localization;
import org.apache.submarine.client.cli.param.Quicklink;
import org.apache.submarine.client.cli.param.RunParameters;
import org.apache.submarine.client.cli.runjob.RoleParameters;
import org.apache.submarine.commons.runtime.ClientContext;
import org.apache.submarine.commons.runtime.api.Role;
import org.apache.submarine.commons.runtime.api.TensorFlowRole;
import org.apache.submarine.commons.runtime.fs.RemoteDirectoryManager;
import org.apache.submarine.commons.runtime.param.Parameter;
import org.apache.submarine.commons.runtime.resource.ResourceUtils;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public abstract class RunJobParameters
extends RunParameters {
    private String input;
    private String checkpointPath;
    private List<Quicklink> quicklinks = new ArrayList<Quicklink>();
    private List<Localization> localizations = new ArrayList<Localization>();
    private boolean waitJobFinish = false;
    protected boolean distributed = false;
    private boolean securityDisabled = false;
    private String keytab;
    private String principal;
    private boolean distributeKeytab = false;
    private List<String> confPairs = new ArrayList<String>();
    RoleParameters workerParameters = RoleParameters.createEmpty((Role)TensorFlowRole.WORKER);

    @Override
    public void updateParameters(Parameter parametersHolder, ClientContext clientContext) throws ParseException, IOException, YarnException {
        List localizationsStr;
        List quicklinkStrs;
        String input = parametersHolder.getOptionValue("input_path");
        String jobDir = parametersHolder.getOptionValue("checkpoint_path");
        if (parametersHolder.hasOption("insecure")) {
            this.setSecurityDisabled(true);
        }
        String kerberosKeytab = parametersHolder.getOptionValue("keytab");
        String kerberosPrincipal = parametersHolder.getOptionValue("principal");
        CliUtils.doLoginIfSecure(kerberosKeytab, kerberosPrincipal);
        if (parametersHolder.hasOption("wait_job_finish")) {
            this.waitJobFinish = true;
        }
        if ((quicklinkStrs = parametersHolder.getOptionValues("quicklink")) != null) {
            for (Object ql : quicklinkStrs) {
                Quicklink quicklink = new Quicklink();
                quicklink.parse((String)ql);
                this.quicklinks.add(quicklink);
            }
        }
        if (null != (localizationsStr = parametersHolder.getOptionValues("localization"))) {
            for (String loc : localizationsStr) {
                Localization localization = new Localization();
                localization.parse(loc);
                this.localizations.add(localization);
            }
        }
        boolean distributeKerberosKeytab = parametersHolder.hasOption("distribute_keytab");
        List configPairs = parametersHolder.getOptionValues("conf");
        this.setInputPath(input).setCheckpointPath(jobDir).setKeytab(kerberosKeytab).setPrincipal(kerberosPrincipal).setDistributeKeytab(distributeKerberosKeytab).setConfPairs(configPairs);
        super.updateParameters(parametersHolder, clientContext);
    }

    abstract void executePostOperations(ClientContext var1) throws IOException;

    void setDefaultDirs(ClientContext clientContext) throws IOException {
        String savedModelDir;
        String jobDir = this.getCheckpointPath();
        if (jobDir == null) {
            jobDir = this.getJobDir(clientContext);
            this.setCheckpointPath(jobDir);
        }
        if (this.getNumWorkers() > 0 && (savedModelDir = this.getSavedModelPath()) == null) {
            savedModelDir = jobDir;
            this.setSavedModelPath(savedModelDir);
        }
    }

    private String getJobDir(ClientContext clientContext) throws IOException {
        RemoteDirectoryManager rdm = clientContext.getRemoteDirectoryManager();
        if (this.getNumWorkers() > 0) {
            return rdm.getJobCheckpointDir(this.getName(), true).toString();
        }
        return rdm.getUserRootFolder().toString();
    }

    public abstract List<String> getLaunchCommands();

    public String getInputPath() {
        return this.input;
    }

    public RunJobParameters setInputPath(String input) {
        this.input = input;
        return this;
    }

    public String getCheckpointPath() {
        return this.checkpointPath;
    }

    public RunJobParameters setCheckpointPath(String checkpointPath) {
        this.checkpointPath = checkpointPath;
        return this;
    }

    public boolean isWaitJobFinish() {
        return this.waitJobFinish;
    }

    public RunJobParameters setWaitJobFinish(boolean waitJobFinish) {
        this.waitJobFinish = waitJobFinish;
        return this;
    }

    public List<Quicklink> getQuicklinks() {
        return this.quicklinks;
    }

    public RunJobParameters setQuicklinks(List<Quicklink> quicklinks) {
        this.quicklinks = quicklinks;
        return this;
    }

    public List<Localization> getLocalizations() {
        return this.localizations;
    }

    public RunJobParameters setLocalizations(List<Localization> localizations) {
        this.localizations = localizations;
        return this;
    }

    public String getKeytab() {
        return this.keytab;
    }

    public RunJobParameters setKeytab(String kerberosKeytab) {
        this.keytab = kerberosKeytab;
        return this;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public RunJobParameters setPrincipal(String kerberosPrincipal) {
        this.principal = kerberosPrincipal;
        return this;
    }

    public boolean isSecurityDisabled() {
        return this.securityDisabled;
    }

    public RunJobParameters setSecurityDisabled(boolean securityDisabled) {
        this.securityDisabled = securityDisabled;
        return this;
    }

    public boolean isDistributeKeytab() {
        return this.distributeKeytab;
    }

    public RunJobParameters setDistributeKeytab(boolean distributeKerberosKeytab) {
        this.distributeKeytab = distributeKerberosKeytab;
        return this;
    }

    public List<String> getConfPairs() {
        return this.confPairs;
    }

    public RunJobParameters setConfPairs(List<String> confPairs) {
        this.confPairs = confPairs;
        return this;
    }

    public RunJobParameters setDistributed(boolean distributed) {
        this.distributed = distributed;
        return this;
    }

    RoleParameters generateWorkerParameters(ClientContext clientContext, Parameter parametersHolder, String input) throws ParseException, YarnException, IOException {
        int nWorkers = this.getNumberOfWorkers(parametersHolder, input);
        Resource workerResource = this.determineWorkerResource(parametersHolder, nWorkers, clientContext);
        String workerDockerImage = parametersHolder.getOptionValue("worker_docker_image");
        String workerLaunchCmd = parametersHolder.getOptionValue("worker_launch_cmd");
        return new RoleParameters((Role)TensorFlowRole.WORKER, nWorkers, workerLaunchCmd, workerDockerImage, workerResource);
    }

    private Resource determineWorkerResource(Parameter parametersHolder, int nWorkers, ClientContext clientContext) throws ParseException, YarnException, IOException {
        if (nWorkers > 0) {
            String workerResourceStr = parametersHolder.getOptionValue("worker_resources");
            if (workerResourceStr == null) {
                throw new ParseException("--worker_resources is absent.");
            }
            return ResourceUtils.createResourceFromString((String)workerResourceStr);
        }
        return null;
    }

    private int getNumberOfWorkers(Parameter parametersHolder, String input) throws ParseException, YarnException {
        int nWorkers = 1;
        if (parametersHolder.getOptionValue("num_workers") != null) {
            nWorkers = Integer.parseInt(parametersHolder.getOptionValue("num_workers"));
            if (null == input && 0 != nWorkers) {
                throw new ParseException("\"--input_path\" is absent");
            }
        }
        return nWorkers;
    }

    public RoleParameters getWorkerParameter() {
        return this.workerParameters;
    }

    public RunJobParameters setWorkerParameter(RoleParameters workerParameters) {
        this.workerParameters = workerParameters;
        return this;
    }

    public String getWorkerLaunchCmd() {
        return this.workerParameters.getLaunchCommand();
    }

    public void setWorkerLaunchCmd(String launchCmd) {
        this.workerParameters.setLaunchCommand(launchCmd);
    }

    public int getNumWorkers() {
        return this.workerParameters.getReplicas();
    }

    public void setNumWorkers(int numWorkers) {
        this.workerParameters.setReplicas(numWorkers);
    }

    public Resource getWorkerResource() {
        return this.workerParameters.getResource();
    }

    public void setWorkerResource(Resource resource) {
        this.workerParameters.setResource(resource);
    }

    public String getWorkerDockerImage() {
        return this.workerParameters.getDockerImage();
    }

    public void setWorkerDockerImage(String image) {
        this.workerParameters.setDockerImage(image);
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    @VisibleForTesting
    public static class UnderscoreConverterPropertyUtils
    extends PropertyUtils {
        public Property getProperty(Class<? extends Object> type, String name) throws IntrospectionException {
            if (name.indexOf(95) > -1) {
                name = UnderscoreConverterPropertyUtils.convertName(name);
            }
            return super.getProperty(type, name);
        }

        private static String convertName(String name) {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
        }
    }
}

