/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.client.cli.param.runjob;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.submarine.client.cli.CliUtils;
import org.apache.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.submarine.client.cli.runjob.RoleParameters;
import org.apache.submarine.commons.runtime.ClientContext;
import org.apache.submarine.commons.runtime.api.MXNetRole;
import org.apache.submarine.commons.runtime.api.Role;
import org.apache.submarine.commons.runtime.param.Parameter;
import org.apache.submarine.commons.runtime.resource.ResourceUtils;

public class MXNetRunJobParameters
extends RunJobParameters {
    private RoleParameters psParameters = RoleParameters.createEmpty((Role)MXNetRole.PS);
    private RoleParameters schedulerParameters = RoleParameters.createEmpty((Role)MXNetRole.SCHEDULER);
    private static final String CANNOT_BE_DEFINED_FOR_MXNET = "cannot be defined for MXNet jobs!";

    @Override
    public void updateParameters(Parameter parametersHolder, ClientContext clientContext) throws ParseException, IOException, YarnException {
        this.checkArguments(parametersHolder);
        super.updateParameters(parametersHolder, clientContext);
        String input = parametersHolder.getOptionValue("input_path");
        this.workerParameters = this.generateWorkerParameters(clientContext, parametersHolder, input);
        this.psParameters = this.getPSParameters(parametersHolder);
        this.schedulerParameters = this.getSchedulerParameters(parametersHolder);
        this.distributed = this.determineIfDistributed(this.workerParameters.getReplicas(), this.psParameters.getReplicas(), this.schedulerParameters.getReplicas());
        this.executePostOperations(clientContext);
    }

    @Override
    void executePostOperations(ClientContext clientContext) throws IOException {
        this.setDefaultDirs(clientContext);
        this.replacePatternsInParameters(clientContext);
    }

    @Override
    public List<String> getLaunchCommands() {
        return Lists.newArrayList((Object[])new String[]{this.getWorkerLaunchCmd(), this.getPSLaunchCmd(), this.getSchedulerLaunchCmd()});
    }

    private void replacePatternsInParameters(ClientContext clientContext) throws IOException {
        String afterReplace;
        if (StringUtils.isNotEmpty((CharSequence)this.getPSLaunchCmd())) {
            afterReplace = CliUtils.replacePatternsInLaunchCommand(this.getPSLaunchCmd(), this, clientContext.getRemoteDirectoryManager());
            this.setPSLaunchCmd(afterReplace);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getWorkerLaunchCmd())) {
            afterReplace = CliUtils.replacePatternsInLaunchCommand(this.getWorkerLaunchCmd(), this, clientContext.getRemoteDirectoryManager());
            this.setWorkerLaunchCmd(afterReplace);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getSchedulerLaunchCmd())) {
            afterReplace = CliUtils.replacePatternsInLaunchCommand(this.getSchedulerLaunchCmd(), this, clientContext.getRemoteDirectoryManager());
            this.setSchedulerLaunchCmd(afterReplace);
        }
    }

    private void checkArguments(Parameter parametersHolder) throws YarnException, ParseException {
        if (parametersHolder.hasOption("tensorboard")) {
            throw new ParseException(this.getParamCannotBeDefinedErrorMessage("tensorboard"));
        }
        if (parametersHolder.getOptionValue("tensorboard_resources") != null) {
            throw new ParseException(this.getParamCannotBeDefinedErrorMessage("tensorboard_resources"));
        }
        if (parametersHolder.getOptionValue("tensorboard_docker_image") != null) {
            throw new ParseException(this.getParamCannotBeDefinedErrorMessage("tensorboard_docker_image"));
        }
    }

    private boolean determineIfDistributed(int nWorkers, int nPS, int nSchedulers) {
        return nWorkers >= 2 && nPS > 0 && nSchedulers == 1;
    }

    private String getParamCannotBeDefinedErrorMessage(String cliName) {
        return String.format("Parameter '%s' cannot be defined for MXNet jobs!", cliName);
    }

    private RoleParameters getPSParameters(Parameter parametersHolder) throws YarnException, ParseException {
        int nPS = this.getNumberOfPS(parametersHolder);
        Resource psResource = this.determinePSResource(parametersHolder, nPS);
        String psDockerImage = parametersHolder.getOptionValue("ps_docker_image");
        String psLaunchCommand = parametersHolder.getOptionValue("ps_launch_cmd");
        return new RoleParameters((Role)MXNetRole.PS, nPS, psLaunchCommand, psDockerImage, psResource);
    }

    private Resource determinePSResource(Parameter parametersHolder, int nPS) throws ParseException, YarnException {
        if (nPS > 0) {
            String psResourceStr = parametersHolder.getOptionValue("ps_resources");
            if (psResourceStr == null) {
                throw new ParseException("--ps_resources is absent.");
            }
            return ResourceUtils.createResourceFromString((String)psResourceStr);
        }
        return null;
    }

    public String getPSLaunchCmd() {
        return this.psParameters.getLaunchCommand();
    }

    public void setPSLaunchCmd(String launchCmd) {
        this.psParameters.setLaunchCommand(launchCmd);
    }

    private int getNumberOfPS(Parameter parametersHolder) throws YarnException {
        int nPS = 0;
        if (parametersHolder.getOptionValue("num_ps") != null) {
            nPS = Integer.parseInt(parametersHolder.getOptionValue("num_ps"));
        }
        return nPS;
    }

    private RoleParameters getSchedulerParameters(Parameter parametersHolder) throws YarnException, ParseException {
        int nSchedulers = this.getNumberOfScheduler(parametersHolder);
        Resource schedulerResource = this.determineSchedulerResource(parametersHolder, nSchedulers);
        String schedulerDockerImage = parametersHolder.getOptionValue("scheduler_docker_image");
        String schedulerLaunchCommand = parametersHolder.getOptionValue("scheduler_launch_cmd");
        return new RoleParameters((Role)MXNetRole.SCHEDULER, nSchedulers, schedulerLaunchCommand, schedulerDockerImage, schedulerResource);
    }

    private Resource determineSchedulerResource(Parameter parametersHolder, int nSchedulers) throws ParseException, YarnException {
        if (nSchedulers > 0) {
            String schedulerResourceStr = parametersHolder.getOptionValue("scheduler_resources");
            if (schedulerResourceStr == null) {
                throw new ParseException("--scheduler_resources is absent.");
            }
            return ResourceUtils.createResourceFromString((String)schedulerResourceStr);
        }
        return null;
    }

    private int getNumberOfScheduler(Parameter parametersHolder) throws ParseException, YarnException {
        int nSchedulers = 0;
        if (parametersHolder.getOptionValue("num_schedulers") != null && ((nSchedulers = Integer.parseInt(parametersHolder.getOptionValue("num_schedulers"))) > 1 || nSchedulers < 0)) {
            throw new ParseException("--num_schedulers should be 1 or 0");
        }
        return nSchedulers;
    }

    public String getSchedulerLaunchCmd() {
        return this.schedulerParameters.getLaunchCommand();
    }

    public void setSchedulerLaunchCmd(String launchCmd) {
        this.schedulerParameters.setLaunchCommand(launchCmd);
    }

    public int getNumPS() {
        return this.psParameters.getReplicas();
    }

    public Resource getPsResource() {
        return this.psParameters.getResource();
    }

    public String getPsDockerImage() {
        return this.psParameters.getDockerImage();
    }

    public int getNumSchedulers() {
        return this.schedulerParameters.getReplicas();
    }

    public Resource getSchedulerResource() {
        return this.schedulerParameters.getResource();
    }

    public String getSchedulerDockerImage() {
        return this.schedulerParameters.getDockerImage();
    }
}

