/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.client.cli.param;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.submarine.client.cli.param.ParametersHolder;
import org.apache.submarine.commons.runtime.ClientContext;
import org.apache.submarine.commons.runtime.param.BaseParameters;
import org.apache.submarine.commons.runtime.param.Parameter;

public abstract class RunParameters
extends BaseParameters {
    private String savedModelPath;
    private String dockerImageName;
    private List<String> envars = new ArrayList<String>();
    private String queue;

    public void updateParameters(Parameter parametersHolder, ClientContext clientContext) throws ParseException, IOException, YarnException {
        String savedModelPath = parametersHolder.getOptionValue("saved_model_path");
        this.setSavedModelPath(savedModelPath);
        List<String> envVars = this.getEnvVars((ParametersHolder)parametersHolder);
        this.setEnvars(envVars);
        String queue = parametersHolder.getOptionValue("queue");
        this.setQueue(queue);
        String dockerImage = parametersHolder.getOptionValue("docker_image");
        this.setDockerImageName(dockerImage);
        super.updateParameters(parametersHolder, clientContext);
    }

    private List<String> getEnvVars(ParametersHolder parametersHolder) throws YarnException {
        ArrayList<String> result = new ArrayList<String>();
        List<String> envVarsArray = parametersHolder.getOptionValues("env");
        if (envVarsArray != null) {
            result.addAll(envVarsArray);
        }
        return result;
    }

    public String getQueue() {
        return this.queue;
    }

    public RunParameters setQueue(String queue) {
        this.queue = queue;
        return this;
    }

    public String getDockerImageName() {
        return this.dockerImageName;
    }

    public RunParameters setDockerImageName(String dockerImageName) {
        this.dockerImageName = dockerImageName;
        return this;
    }

    public List<String> getEnvars() {
        return this.envars;
    }

    public RunParameters setEnvars(List<String> envars) {
        this.envars = envars;
        return this;
    }

    public String getSavedModelPath() {
        return this.savedModelPath;
    }

    public RunParameters setSavedModelPath(String savedModelPath) {
        this.savedModelPath = savedModelPath;
        return this;
    }
}

