/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.client.cli;

import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.submarine.client.cli.CliUtils;
import org.apache.submarine.client.cli.ShowJobCli;
import org.apache.submarine.client.cli.remote.RpcRuntimeFactory;
import org.apache.submarine.client.cli.runjob.RunJobCli;
import org.apache.submarine.commons.runtime.ClientContext;
import org.apache.submarine.commons.runtime.RuntimeFactory;
import org.apache.submarine.commons.utils.SubmarineConfVars;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cli {
    private static final Logger LOG = LoggerFactory.getLogger(Cli.class);

    private static void printHelp() {
        StringBuilder helpMsg = new StringBuilder();
        helpMsg.append("\n\nUsage: <object> [<action>] [<args>]\n");
        helpMsg.append("  Below are all objects / actions:\n");
        helpMsg.append("    job \n");
        helpMsg.append("       run : run a job, please see 'job run --help' for usage \n");
        helpMsg.append("       show : get status of job, please see 'job show --help' for usage \n");
        System.out.println(helpMsg.toString());
    }

    private static ClientContext getClientContext() {
        RpcRuntimeFactory runtimeFactory;
        ClientContext clientContext = new ClientContext();
        if (clientContext.getSubmarineConfig().getBoolean(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_RPC_ENABLED)) {
            runtimeFactory = new RpcRuntimeFactory(clientContext);
        } else {
            YarnConfiguration conf = new YarnConfiguration();
            clientContext.setYarnConfig((Configuration)conf);
            runtimeFactory = RuntimeFactory.getRuntimeFactory((ClientContext)clientContext, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        clientContext.setRuntimeFactory((RuntimeFactory)runtimeFactory);
        return clientContext;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void main(String[] args) throws Exception {
        System.out.println("              _                              _              \n             | |                            (_)             \n  ___  _   _ | |__   _ __ ___    __ _  _ __  _  _ __    ___ \n / __|| | | || '_ \\ | '_ ` _ \\  / _` || '__|| || '_ \\  / _ \\\n \\__ \\| |_| || |_) || | | | | || (_| || |   | || | | ||  __/\n |___/ \\__,_||_.__/ |_| |_| |_| \\__,_||_|   |_||_| |_| \\___|\n                                                    \n                             ?\n ~~~~~~~~~~~~~~~~~~~~~~~~~~~|^\"~~~~~~~~~~~~~~~~~~~~~~~~~o~~~~~~~~~~~\n        o                   |                  o      __o\n         o                  |                 o     |X__>\n       ___o                 |                __o\n     (X___>--             __|__            |X__>     o\n                         |     \\                   __o\n                         |      \\                |X__>\n  _______________________|_______\\________________\n <                                                \\____________   _\n  \\                                                            \\ (_)\n   \\    O       O       O                                       >=)\n    \\__________________________________________________________/ (_)\n\n");
        if (CliUtils.argsForHelp(args)) {
            Cli.printHelp();
            System.exit(0);
        }
        if (args.length < 2) {
            LOG.error("Bad parameters specified.");
            Cli.printHelp();
            System.exit(-1);
        }
        String[] moduleArgs = Arrays.copyOfRange(args, 2, args.length);
        ClientContext clientContext = Cli.getClientContext();
        if (!args[0].equals("job")) {
            Cli.printHelp();
            throw new IllegalArgumentException("Bad parameters <TODO>");
        }
        String subCmd = args[1];
        if (subCmd.equals("run")) {
            new RunJobCli(clientContext).run(moduleArgs);
            return;
        }
        if (subCmd.equals("show")) {
            new ShowJobCli(clientContext).run(moduleArgs);
            return;
        }
        Cli.printHelp();
        throw new IllegalArgumentException("Unknown option for job");
    }
}

