/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.ResponseBody;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.JSON;
import io.kubernetes.client.models.V1Status;
import io.kubernetes.client.util.Watchable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Watch<T>
implements Watchable<T> {
    private static final Logger log = LoggerFactory.getLogger(Watch.class);
    Type watchType;
    ResponseBody response;
    JSON json;
    Call call;

    public static <T> Watch<T> createWatch(ApiClient client, Call call, Type watchType) throws ApiException {
        if (client.isDebugging()) {
            log.warn("Watch is (for now) incompatible with debugging mode active. Watches will not return data until the watch connection terminates");
            throw new ApiException("Watch is incompatible with debugging mode active.");
        }
        try {
            com.squareup.okhttp.Response response = call.execute();
            if (!response.isSuccessful()) {
                String respBody = null;
                try (ResponseBody body = response.body();){
                    if (body != null) {
                        respBody = response.body().string();
                    }
                }
                catch (IOException e) {
                    throw new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
                }
                throw new ApiException(response.message(), response.code(), response.headers().toMultimap(), respBody);
            }
            return new Watch<T>(client.getJSON(), response.body(), watchType, call);
        }
        catch (IOException e) {
            throw new ApiException((Throwable)e);
        }
    }

    protected Watch(JSON json, ResponseBody body, Type watchType, Call call) {
        this.response = body;
        this.watchType = watchType;
        this.json = json;
        this.call = call;
    }

    @Override
    public Response<T> next() {
        try {
            String line = this.response.source().readUtf8Line();
            if (line == null) {
                throw new RuntimeException("Null response from the server.");
            }
            return this.parseLine(line);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception during next method.", e);
        }
    }

    protected boolean isStatus(String line) throws IOException {
        boolean found = false;
        JsonReader reader = new JsonReader((Reader)new StringReader(line));
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("object")) {
                found = true;
                break;
            }
            reader.skipValue();
        }
        if (!found) {
            return false;
        }
        String kind = null;
        String apiVersion = null;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("kind")) {
                kind = reader.nextString();
            } else if (name.equals("apiVersion")) {
                apiVersion = reader.nextString();
            } else {
                reader.skipValue();
            }
            if (apiVersion == null || kind == null) continue;
            break;
        }
        return "Status".equals(kind) && "v1".equals(apiVersion);
    }

    protected Response<T> parseLine(String line) throws IOException {
        if (!this.isStatus(line)) {
            return (Response)this.json.deserialize(line, this.watchType);
        }
        Type statusType = new TypeToken<Response<V1Status>>(){}.getType();
        Response status = (Response)this.json.deserialize(line, statusType);
        return new Response(status.type, (V1Status)status.object);
    }

    @Override
    public boolean hasNext() {
        try {
            return !this.response.source().exhausted();
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception during hasNext method.", e);
        }
    }

    @Override
    public Iterator<Response<T>> iterator() {
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void close() throws IOException {
        this.call.cancel();
        this.response.close();
    }

    public static class Response<T> {
        @SerializedName(value="type")
        public String type;
        @SerializedName(value="object")
        public T object;
        public V1Status status;

        public Response(String type, T object) {
            this.type = type;
            this.object = object;
            this.status = null;
        }

        public Response(String type, V1Status status) {
            this.type = type;
            this.object = null;
            this.status = status;
        }
    }
}

