/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer.cache;

import com.google.common.base.Strings;
import io.kubernetes.client.informer.cache.Indexer;
import java.util.List;

public class Lister<ApiType> {
    private String namespace;
    private String indexName;
    private Indexer<ApiType> indexer;

    public Lister(Indexer<ApiType> indexer) {
        this(indexer, null, "namespace");
    }

    public Lister(Indexer<ApiType> indexer, String namespace) {
        this(indexer, namespace, "namespace");
    }

    public Lister(Indexer<ApiType> indexer, String namespace, String indexName) {
        this.indexer = indexer;
        this.namespace = namespace;
        this.indexName = indexName;
    }

    public List<ApiType> list() {
        if (Strings.isNullOrEmpty((String)this.namespace)) {
            return this.indexer.list();
        }
        return this.indexer.byIndex(this.indexName, this.namespace);
    }

    public ApiType get(String name) {
        String key = name;
        if (!Strings.isNullOrEmpty((String)this.namespace)) {
            key = this.namespace + "/" + name;
        }
        return this.indexer.getByKey(key);
    }

    public Lister<ApiType> namespace(String namespace) {
        return new Lister<ApiType>(this.indexer, namespace, "namespace");
    }
}

