/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.entity;

import org.apache.submarine.server.workbench.entity.Role;

public class UserInfo {
    private final String id;
    private final String name;
    private final String username;
    private final String password;
    private final String avatar;
    private final int status;
    private final String telephone;
    private final String lastLoginIp;
    private final long lastLoginTime;
    private final String creatorId;
    private final long createTime;
    private final String merchantCode;
    private final int deleted;
    private final String roleId;
    private final Role role;

    private UserInfo(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.username = builder.username;
        this.password = builder.password;
        this.avatar = builder.avatar;
        this.status = builder.status;
        this.telephone = builder.telephone;
        this.lastLoginIp = builder.lastLoginIp;
        this.lastLoginTime = builder.lastLoginTime;
        this.creatorId = builder.creatorId;
        this.createTime = builder.createTime;
        this.deleted = builder.deleted;
        this.roleId = builder.roleId;
        this.merchantCode = builder.merchantCode;
        this.role = builder.role;
    }

    public String toString() {
        return "User{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", username=" + this.username + ", password='" + this.password + '\'' + ", avatar=" + this.avatar + ", status='" + this.status + '\'' + ", telephone='" + this.telephone + '\'' + ", lastLoginIp=" + this.lastLoginIp + ", creatorId='" + this.creatorId + '\'' + ", createTime='" + this.createTime + '\'' + ", deleted='" + this.deleted + '\'' + ", roleId='" + this.roleId + '\'' + ", lang='" + this.merchantCode + '\'' + ", role='" + this.role.toString() + '\'' + '}';
    }

    public static class Builder {
        private final String id;
        private final String name;
        private String username;
        private String password;
        private String avatar;
        private int status = 0;
        private String telephone;
        private String lastLoginIp;
        private long lastLoginTime;
        private String creatorId;
        private long createTime;
        private String merchantCode;
        private int deleted = 0;
        private String roleId;
        private Role role;

        public Builder(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder avatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public Builder lastLoginIp(String lastLoginIp) {
            this.lastLoginIp = lastLoginIp;
            return this;
        }

        public Builder lastLoginTime(long lastLoginTime) {
            this.lastLoginTime = lastLoginTime;
            return this;
        }

        public Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public Builder telephone(String telephone) {
            this.telephone = telephone;
            return this;
        }

        public Builder createTime(long createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder deleted(int deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public Builder merchantCode(String merchantCode) {
            this.merchantCode = merchantCode;
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            return this;
        }

        public UserInfo build() {
            return new UserInfo(this);
        }
    }
}

