/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.database.service;

import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.submarine.server.workbench.database.MyBatisUtil;
import org.apache.submarine.server.workbench.database.entity.Job;
import org.apache.submarine.server.workbench.database.mappers.JobMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobService {
    private static final Logger LOG = LoggerFactory.getLogger(JobService.class);

    public List<Job> queryJobList(String userName, String column, String order, int pageNo, int pageSize) throws Exception {
        LOG.info("queryJobList owner:{}, column:{}, order:{}, pageNo:{}, pageSize:{}", new Object[]{userName, column, order, pageNo, pageSize});
        List<Job> list = null;
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            JobMapper projectMapper = (JobMapper)sqlSession.getMapper(JobMapper.class);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("userName", userName);
            where.put("column", column);
            where.put("order", order);
            list = projectMapper.selectAll(where, new RowBounds(pageNo, pageSize));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return list;
    }

    public Job selectByJobId(String jobId) throws Exception {
        Job job;
        LOG.info("select a job by jobid {}", (Object)jobId);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            JobMapper projectMapper = (JobMapper)sqlSession.getMapper(JobMapper.class);
            job = projectMapper.selectByJobId(jobId);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return job;
    }

    public Job selectById(String id) throws Exception {
        Job job;
        LOG.info("select a job by id {}", (Object)id);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            JobMapper projectMapper = (JobMapper)sqlSession.getMapper(JobMapper.class);
            job = projectMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return job;
    }

    public boolean add(Job job) throws Exception {
        LOG.info("add({})", (Object)job.toString());
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            JobMapper jobMapper = (JobMapper)sqlSession.getMapper(JobMapper.class);
            jobMapper.insert(job);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public boolean updateByPrimaryKeySelective(Job job) throws Exception {
        LOG.info("updateByPrimaryKeySelective({})", (Object)job.toString());
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            JobMapper jobMapper = (JobMapper)sqlSession.getMapper(JobMapper.class);
            jobMapper.updateByPrimaryKeySelective(job);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public boolean delete(String id) throws Exception {
        LOG.info("delete jobs by id {}", (Object)id);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            JobMapper jobMapper = (JobMapper)sqlSession.getMapper(JobMapper.class);
            jobMapper.deleteByPrimaryKey(id);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public boolean deleteByJobId(String jobId) throws Exception {
        LOG.info("delete jobs by jobId {}", (Object)jobId);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            JobMapper jobMapper = (JobMapper)sqlSession.getMapper(JobMapper.class);
            jobMapper.deleteByJobId(jobId);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }
}

