/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.utils;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHttpRequest {
    private static final Logger LOG = LoggerFactory.getLogger(GitHttpRequest.class);

    public static String sendHttpRequest(String url, Map<String, String> headParams, byte[] parameter, String method) {
        Throwable throwable;
        URLConnection urlConnection = null;
        try {
            urlConnection = new URL(url).openConnection();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        StringBuilder stringBuilder = new StringBuilder();
        HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        try {
            httpURLConnection.setRequestMethod(method);
        }
        catch (ProtocolException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if (parameter != null) {
            httpURLConnection.setRequestProperty("Content-Length", String.valueOf(parameter.length));
        }
        httpURLConnection.setRequestProperty("Content-Type", "application/json;charset=utf-8");
        httpURLConnection.setRequestProperty("accept", "application/json");
        httpURLConnection.setRequestProperty("connection", "Keep-Alive");
        httpURLConnection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
        httpURLConnection.setRequestProperty("timestamp", String.valueOf(new Date().getTime() / 1000L));
        if (headParams != null) {
            for (String key : headParams.keySet()) {
                httpURLConnection.setRequestProperty(key, headParams.get(key));
            }
        }
        httpURLConnection.setUseCaches(false);
        if (parameter != null) {
            try {
                throwable = null;
                try (BufferedOutputStream outputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());){
                    outputStream.write(parameter);
                    outputStream.flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            throwable = null;
            try (InputStreamReader inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream(), "utf-8");
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuilder.append(line);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        LOG.info("result:{}", (Object)stringBuilder.toString());
        return stringBuilder.toString();
    }
}

