/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.rest;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.submarine.commons.metastore.SubmarineMetaStore;
import org.apache.submarine.commons.utils.SubmarineConfiguration;
import org.apache.submarine.server.response.JsonResponse;
import org.apache.submarine.server.workbench.annotation.SubmarineApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="v1/metastore")
@Produces(value={"application/json"})
@Singleton
public class MetaStoreRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(MetaStoreRestApi.class);
    private static final Gson gson = new Gson();
    private static final SubmarineConfiguration submarineConf = SubmarineConfiguration.getInstance();
    private SubmarineMetaStore submarineMetaStore = new SubmarineMetaStore(submarineConf);

    @Inject
    public MetaStoreRestApi() {
    }

    @POST
    @Path(value="/database/create")
    @SubmarineApi
    public Response createDatabase(@QueryParam(value="database") String databaseJson) {
        try {
            Database database = (Database)gson.fromJson(databaseJson, Database.class);
            this.submarineMetaStore.createDatabase(database);
        }
        catch (MetaException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.INTERNAL_SERVER_ERROR).success(false).build();
        }
        catch (JsonSyntaxException | InvalidObjectException e) {
            LOG.error(e.getMessage(), e);
            return new JsonResponse.Builder(Response.Status.BAD_REQUEST).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).build();
    }

    @POST
    @Path(value="/table/create")
    @SubmarineApi
    public Response createTable(@QueryParam(value="database") String tableJson) {
        try {
            Table table = (Table)gson.fromJson(tableJson, Table.class);
            this.submarineMetaStore.createTable(table);
        }
        catch (MetaException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.INTERNAL_SERVER_ERROR).success(false).build();
        }
        catch (JsonSyntaxException | InvalidObjectException e) {
            LOG.error(e.getMessage(), e);
            return new JsonResponse.Builder(Response.Status.BAD_REQUEST).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).build();
    }

    @GET
    @Path(value="/database/count")
    @SubmarineApi
    public Response getDatabaseCount() {
        int databaseCount = -1;
        try {
            databaseCount = this.submarineMetaStore.getDatabaseCount();
        }
        catch (MetaException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.INTERNAL_SERVER_ERROR).success(false).result(databaseCount).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(databaseCount).build();
    }

    @GET
    @Path(value="/database/list")
    @SubmarineApi
    public Response listDatabases() {
        List allDatabases;
        try {
            allDatabases = this.submarineMetaStore.getAllDatabases();
        }
        catch (MetaException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.INTERNAL_SERVER_ERROR).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(allDatabases).build();
    }

    @GET
    @Path(value="/database")
    @SubmarineApi
    public Response getDatabase(@QueryParam(value="database") String name) {
        Database database;
        try {
            database = this.submarineMetaStore.getDatabase(name);
        }
        catch (NoSuchObjectException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.NOT_FOUND).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(database).build();
    }

    @DELETE
    @Path(value="/database")
    @SubmarineApi
    public Response dropDatabase(@QueryParam(value="database") String name) {
        try {
            this.submarineMetaStore.dropDatabase(name);
        }
        catch (MetaException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.INTERNAL_SERVER_ERROR).success(false).build();
        }
        catch (NoSuchObjectException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.NOT_FOUND).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).build();
    }

    @GET
    @Path(value="/table/list")
    @SubmarineApi
    public Response listTables(@QueryParam(value="database") String databaseName) {
        List tables;
        try {
            tables = this.submarineMetaStore.getAllTables(databaseName);
        }
        catch (MetaException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.INTERNAL_SERVER_ERROR).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(tables).build();
    }

    @GET
    @Path(value="/table/count")
    @SubmarineApi
    public Response getTableCount() {
        int tableCount;
        try {
            tableCount = this.submarineMetaStore.getTableCount();
        }
        catch (MetaException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.INTERNAL_SERVER_ERROR).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(tableCount).build();
    }

    @GET
    @Path(value="/table")
    @SubmarineApi
    public Response getTable(@QueryParam(value="database") String databaseName, @QueryParam(value="table") String tableName) {
        Table table;
        try {
            table = this.submarineMetaStore.getTable(databaseName, tableName);
        }
        catch (MetaException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.INTERNAL_SERVER_ERROR).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(table).build();
    }

    @DELETE
    @Path(value="/table")
    @SubmarineApi
    public Response dropTable(@QueryParam(value="database") String databaseName, @QueryParam(value="table") String tableName) {
        try {
            this.submarineMetaStore.dropTable(databaseName, tableName);
        }
        catch (MetaException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.INTERNAL_SERVER_ERROR).success(false).build();
        }
        catch (NoSuchObjectException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.NOT_FOUND).success(false).build();
        }
        catch (InvalidInputException | InvalidObjectException e) {
            LOG.error(e.getMessage(), e);
            return new JsonResponse.Builder(Response.Status.BAD_REQUEST).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).build();
    }
}

