/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.experiment;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.Response;
import org.apache.submarine.commons.utils.exception.SubmarineRuntimeException;
import org.apache.submarine.server.SubmarineServer;
import org.apache.submarine.server.SubmitterManager;
import org.apache.submarine.server.api.experiment.Experiment;
import org.apache.submarine.server.api.experiment.ExperimentId;
import org.apache.submarine.server.api.experiment.ExperimentLog;
import org.apache.submarine.server.api.experiment.Submitter;
import org.apache.submarine.server.api.spec.ExperimentSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentManager {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentManager.class);
    private static volatile ExperimentManager manager;
    private final AtomicInteger experimentCounter = new AtomicInteger(0);
    private final ConcurrentMap<String, Experiment> cachedExperimentMap = new ConcurrentHashMap<String, Experiment>();
    private final Submitter submitter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExperimentManager getInstance() {
        if (manager != null) return manager;
        Class<ExperimentManager> clazz = ExperimentManager.class;
        synchronized (ExperimentManager.class) {
            if (manager != null) return manager;
            manager = new ExperimentManager(SubmitterManager.loadSubmitter());
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    private ExperimentManager(Submitter submitter) {
        this.submitter = submitter;
    }

    public Experiment createExperiment(ExperimentSpec spec) throws SubmarineRuntimeException {
        this.checkSpec(spec);
        Experiment experiment = this.submitter.createExperiment(spec);
        experiment.setExperimentId(this.generateExperimentId());
        experiment.setSpec(spec);
        this.cachedExperimentMap.putIfAbsent(experiment.getExperimentId().toString(), experiment);
        return experiment;
    }

    private ExperimentId generateExperimentId() {
        return ExperimentId.newInstance((long)SubmarineServer.getServerTimeStamp(), (int)this.experimentCounter.incrementAndGet());
    }

    public Experiment getExperiment(String id) throws SubmarineRuntimeException {
        this.checkExperimentId(id);
        Experiment experiment = (Experiment)this.cachedExperimentMap.get(id);
        ExperimentSpec spec = experiment.getSpec();
        Experiment patchExperiment = this.submitter.findExperiment(spec);
        experiment.rebuild(patchExperiment);
        return experiment;
    }

    public List<Experiment> listExperimentsByStatus(String status) throws SubmarineRuntimeException {
        ArrayList<Experiment> experimentList = new ArrayList<Experiment>();
        for (Map.Entry entry : this.cachedExperimentMap.entrySet()) {
            Experiment experiment = (Experiment)entry.getValue();
            ExperimentSpec spec = experiment.getSpec();
            Experiment patchExperiment = this.submitter.findExperiment(spec);
            LOG.info("Found experiment: {}", (Object)patchExperiment.getStatus());
            if (status != null && !status.toLowerCase().equals(patchExperiment.getStatus().toLowerCase())) continue;
            experiment.rebuild(patchExperiment);
            experimentList.add(experiment);
        }
        LOG.info("List experiment: {}", (Object)experimentList.size());
        return experimentList;
    }

    public Experiment patchExperiment(String id, ExperimentSpec spec) throws SubmarineRuntimeException {
        this.checkExperimentId(id);
        this.checkSpec(spec);
        Experiment experiment = (Experiment)this.cachedExperimentMap.get(id);
        Experiment patchExperiment = this.submitter.patchExperiment(spec);
        experiment.setSpec(spec);
        experiment.rebuild(patchExperiment);
        return experiment;
    }

    public Experiment deleteExperiment(String id) throws SubmarineRuntimeException {
        this.checkExperimentId(id);
        Experiment experiment = (Experiment)this.cachedExperimentMap.remove(id);
        ExperimentSpec spec = experiment.getSpec();
        Experiment patchExperiment = this.submitter.deleteExperiment(spec);
        experiment.rebuild(patchExperiment);
        return experiment;
    }

    public List<ExperimentLog> listExperimentLogsByStatus(String status) throws SubmarineRuntimeException {
        ArrayList<ExperimentLog> experimentLogList = new ArrayList<ExperimentLog>();
        for (Map.Entry entry : this.cachedExperimentMap.entrySet()) {
            String id = (String)entry.getKey();
            Experiment experiment = (Experiment)entry.getValue();
            ExperimentSpec spec = experiment.getSpec();
            Experiment patchExperiment = this.submitter.findExperiment(spec);
            LOG.info("Found experiment: {}", (Object)patchExperiment.getStatus());
            if (status != null && !status.toLowerCase().equals(patchExperiment.getStatus().toLowerCase())) continue;
            experiment.rebuild(patchExperiment);
            experimentLogList.add(this.submitter.getExperimentLogName(spec, id));
        }
        return experimentLogList;
    }

    public ExperimentLog getExperimentLog(String id) throws SubmarineRuntimeException {
        this.checkExperimentId(id);
        Experiment experiment = (Experiment)this.cachedExperimentMap.get(id);
        ExperimentSpec spec = experiment.getSpec();
        Experiment patchExperiment = this.submitter.findExperiment(spec);
        experiment.rebuild(patchExperiment);
        return this.submitter.getExperimentLog(spec, id);
    }

    private void checkSpec(ExperimentSpec spec) throws SubmarineRuntimeException {
        if (spec == null) {
            throw new SubmarineRuntimeException(Response.Status.OK.getStatusCode(), "Invalid experiment spec.");
        }
    }

    private void checkExperimentId(String id) throws SubmarineRuntimeException {
        ExperimentId experimentId = ExperimentId.fromString((String)id);
        if (experimentId == null || !this.cachedExperimentMap.containsKey(id)) {
            throw new SubmarineRuntimeException(Response.Status.NOT_FOUND.getStatusCode(), "Not found experiment.");
        }
    }
}

