/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.XmlElement;

public class RowBoundsPlugin
extends PluginAdapter {
    private FullyQualifiedJavaType rowBounds = new FullyQualifiedJavaType("org.apache.ibatis.session.RowBounds");
    private Map<FullyQualifiedTable, List<XmlElement>> elementsToAdd = new HashMap<FullyQualifiedTable, List<XmlElement>>();

    @Override
    public boolean validate(List<String> warnings) {
        return true;
    }

    @Override
    public boolean clientSelectByExampleWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3) {
            this.copyAndAddMethod(method, interfaze);
        } else if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3_DSQL) {
            this.copyAndAddSelectByExampleMethodForDSQL(method, interfaze);
        }
        return true;
    }

    @Override
    public boolean clientSelectByExampleWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3) {
            this.copyAndAddMethod(method, interfaze);
        }
        return true;
    }

    @Override
    public boolean sqlMapSelectByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3) {
            this.copyAndSaveElement(element, introspectedTable.getFullyQualifiedTable());
        }
        return true;
    }

    @Override
    public boolean sqlMapSelectByExampleWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3) {
            this.copyAndSaveElement(element, introspectedTable.getFullyQualifiedTable());
        }
        return true;
    }

    @Override
    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        List<XmlElement> elements = this.elementsToAdd.get(introspectedTable.getFullyQualifiedTable());
        if (elements != null) {
            for (XmlElement element : elements) {
                document.getRootElement().addElement(element);
            }
        }
        return true;
    }

    @Override
    public boolean clientBasicSelectManyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        this.copyAndAddSelectManyMethod(method, interfaze);
        this.addNewComposedFunction(interfaze, introspectedTable, method.getReturnType());
        return true;
    }

    private void addNewComposedFunction(Interface interfaze, IntrospectedTable introspectedTable, FullyQualifiedJavaType baseMethodReturnType) {
        interfaze.addImportedType(new FullyQualifiedJavaType("java.util.function.Function"));
        FullyQualifiedJavaType returnType = new FullyQualifiedJavaType("Function<SelectStatementProvider, " + baseMethodReturnType.getShortName() + ">");
        Method method = new Method("selectManyWithRowbounds");
        method.setDefault(true);
        method.setReturnType(returnType);
        method.addParameter(new Parameter(this.rowBounds, "rowBounds"));
        method.addBodyLine("return selectStatement -> selectManyWithRowbounds(selectStatement, rowBounds);");
        this.context.getCommentGenerator().addGeneralMethodAnnotation(method, introspectedTable, interfaze.getImportedTypes());
        interfaze.addMethod(method);
    }

    private void copyAndAddMethod(Method method, Interface interfaze) {
        Method newMethod = new Method(method);
        newMethod.setName(method.getName() + "WithRowbounds");
        newMethod.addParameter(new Parameter(this.rowBounds, "rowBounds"));
        interfaze.addMethod(newMethod);
        interfaze.addImportedType(this.rowBounds);
    }

    private void copyAndAddSelectManyMethod(Method method, Interface interfaze) {
        ArrayList<String> annotations = new ArrayList<String>(method.getAnnotations());
        boolean inResultsAnnotation = false;
        String resultMapId = null;
        Iterator iter = annotations.iterator();
        while (iter.hasNext()) {
            String annotation = (String)iter.next();
            if (inResultsAnnotation) {
                if (annotation.equals("})")) {
                    inResultsAnnotation = false;
                }
                iter.remove();
                continue;
            }
            if (!annotation.startsWith("@Results(")) continue;
            inResultsAnnotation = true;
            iter.remove();
            int index = annotation.indexOf("id=\"");
            int startIndex = index + "id=\"".length();
            int endIndex = annotation.indexOf(34, startIndex + 1);
            resultMapId = annotation.substring(startIndex, endIndex);
        }
        if (resultMapId != null) {
            interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.ResultMap"));
            annotations.add("@ResultMap(\"" + resultMapId + "\")");
        }
        Method newMethod = new Method(method);
        newMethod.getAnnotations().clear();
        for (String annotation : annotations) {
            newMethod.addAnnotation(annotation);
        }
        newMethod.setName(method.getName() + "WithRowbounds");
        newMethod.addParameter(new Parameter(this.rowBounds, "rowBounds"));
        interfaze.addMethod(newMethod);
        interfaze.addImportedType(this.rowBounds);
    }

    private void copyAndAddSelectByExampleMethodForDSQL(Method method, Interface interfaze) {
        Method newMethod = new Method(method);
        newMethod.addParameter(new Parameter(this.rowBounds, "rowBounds"));
        interfaze.addMethod(newMethod);
        interfaze.addImportedType(this.rowBounds);
        for (int i = 0; i < newMethod.getBodyLines().size(); ++i) {
            String bodyLine = newMethod.getBodyLines().get(i);
            if (!bodyLine.contains("this::selectMany")) continue;
            bodyLine = bodyLine.replace("this::selectMany", "selectManyWithRowbounds(rowBounds)");
            newMethod.getBodyLines().set(i, bodyLine);
            break;
        }
    }

    private void copyAndSaveElement(XmlElement element, FullyQualifiedTable fqt) {
        List<XmlElement> elements;
        XmlElement newElement = new XmlElement(element);
        Iterator<Attribute> iterator = newElement.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (!"id".equals(attribute.getName())) continue;
            iterator.remove();
            Attribute newAttribute = new Attribute("id", attribute.getValue() + "WithRowbounds");
            newElement.addAttribute(newAttribute);
            break;
        }
        if ((elements = this.elementsToAdd.get(fqt)) == null) {
            elements = new ArrayList<XmlElement>();
            this.elementsToAdd.put(fqt, elements);
        }
        elements.add(newElement);
    }
}

