/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.api.experiment;

public class ExperimentId
implements Comparable<ExperimentId> {
    private static final String EXPERIMENT_ID_PREFIX = "experiment_";
    private static final int EXPERIMENT_ID_MIN_DIGITS = 4;
    private int id;
    private long serverTimestamp;

    public static ExperimentId fromString(String jobId) {
        if (jobId == null) {
            return null;
        }
        String[] components = jobId.split("\\_");
        if (components.length != 3) {
            return null;
        }
        return ExperimentId.newInstance(Long.parseLong(components[1]), Integer.parseInt(components[2]));
    }

    public static ExperimentId newInstance(long serverTimestamp, int id) {
        ExperimentId experimentId = new ExperimentId();
        experimentId.setServerTimestamp(serverTimestamp);
        experimentId.setId(id);
        return experimentId;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getServerTimestamp() {
        return this.serverTimestamp;
    }

    public void setServerTimestamp(long timestamp) {
        this.serverTimestamp = timestamp;
    }

    @Override
    public int compareTo(ExperimentId o) {
        return this.getId() > o.getId() ? 1 : 0;
    }

    public int hashCode() {
        int prime = 371237;
        int result = 6521;
        result = 371237 * result + (int)(this.serverTimestamp ^ this.serverTimestamp >>> 32);
        result = 371237 * result + this.getId();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ExperimentId other = (ExperimentId)obj;
        if (this.getServerTimestamp() != other.getServerTimestamp()) {
            return false;
        }
        return this.getId() == other.getId();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(EXPERIMENT_ID_PREFIX).append(this.serverTimestamp).append("_");
        this.format(sb, this.getId());
        return sb.toString();
    }

    private void format(StringBuilder sb, long value) {
        int minimumDigits = 4;
        if (value < 0L) {
            sb.append('-');
            value = -value;
        }
        long tmp = value;
        while (--minimumDigits > 0 && (tmp /= 10L) > 0L) {
        }
        for (int i = minimumDigits; i > 0; --i) {
            sb.append('0');
        }
        sb.append(value);
    }
}

