/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="CSINodeDriver holds information about the specification of one CSI driver installed on a node")
public class V1beta1CSINodeDriver {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="nodeID")
    private String nodeID = null;
    @SerializedName(value="topologyKeys")
    private List<String> topologyKeys = null;

    public V1beta1CSINodeDriver name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="This is the name of the CSI driver that this object refers to. This MUST be the same name returned by the CSI GetPluginName() call for that driver.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1beta1CSINodeDriver nodeID(String nodeID) {
        this.nodeID = nodeID;
        return this;
    }

    @ApiModelProperty(required=true, value="nodeID of the node from the driver point of view. This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as \"node1\", but the storage system may refer to the same node as \"nodeA\". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. \"nodeA\" instead of \"node1\". This field is required.")
    public String getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    public V1beta1CSINodeDriver topologyKeys(List<String> topologyKeys) {
        this.topologyKeys = topologyKeys;
        return this;
    }

    public V1beta1CSINodeDriver addTopologyKeysItem(String topologyKeysItem) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        this.topologyKeys.add(topologyKeysItem);
        return this;
    }

    @ApiModelProperty(value="topologyKeys is the list of keys supported by the driver. When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. \"company.com/zone\", \"company.com/region\"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.")
    public List<String> getTopologyKeys() {
        return this.topologyKeys;
    }

    public void setTopologyKeys(List<String> topologyKeys) {
        this.topologyKeys = topologyKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CSINodeDriver v1beta1CSINodeDriver = (V1beta1CSINodeDriver)o;
        return Objects.equals(this.name, v1beta1CSINodeDriver.name) && Objects.equals(this.nodeID, v1beta1CSINodeDriver.nodeID) && Objects.equals(this.topologyKeys, v1beta1CSINodeDriver.topologyKeys);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.nodeID, this.topologyKeys);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CSINodeDriver {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nodeID: ").append(this.toIndentedString(this.nodeID)).append("\n");
        sb.append("    topologyKeys: ").append(this.toIndentedString(this.topologyKeys)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

