/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="APIServiceCondition describes the state of an APIService at a particular point")
public class V1beta1APIServiceCondition {
    @SerializedName(value="lastTransitionTime")
    private DateTime lastTransitionTime = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="reason")
    private String reason = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="type")
    private String type = null;

    public V1beta1APIServiceCondition lastTransitionTime(DateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
        return this;
    }

    @ApiModelProperty(value="Last time the condition transitioned from one status to another.")
    public DateTime getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public void setLastTransitionTime(DateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
    }

    public V1beta1APIServiceCondition message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(value="Human-readable message indicating details about last transition.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V1beta1APIServiceCondition reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="Unique, one-word, CamelCase reason for the condition's last transition.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1beta1APIServiceCondition status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="Status is the status of the condition. Can be True, False, Unknown.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public V1beta1APIServiceCondition type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type is the type of the condition.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1APIServiceCondition v1beta1APIServiceCondition = (V1beta1APIServiceCondition)o;
        return Objects.equals(this.lastTransitionTime, v1beta1APIServiceCondition.lastTransitionTime) && Objects.equals(this.message, v1beta1APIServiceCondition.message) && Objects.equals(this.reason, v1beta1APIServiceCondition.reason) && Objects.equals(this.status, v1beta1APIServiceCondition.status) && Objects.equals(this.type, v1beta1APIServiceCondition.type);
    }

    public int hashCode() {
        return Objects.hash(this.lastTransitionTime, this.message, this.reason, this.status, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1APIServiceCondition {\n");
        sb.append("    lastTransitionTime: ").append(this.toIndentedString(this.lastTransitionTime)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

