/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ListMeta describes metadata that synthetic resources must have, including lists and various status objects. A resource may have only one of {ObjectMeta, ListMeta}.")
public class V1ListMeta {
    @SerializedName(value="continue")
    private String _continue = null;
    @SerializedName(value="resourceVersion")
    private String resourceVersion = null;
    @SerializedName(value="selfLink")
    private String selfLink = null;

    public V1ListMeta _continue(String _continue) {
        this._continue = _continue;
        return this;
    }

    @ApiModelProperty(value="continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.")
    public String getContinue() {
        return this._continue;
    }

    public void setContinue(String _continue) {
        this._continue = _continue;
    }

    public V1ListMeta resourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return this;
    }

    @ApiModelProperty(value="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency")
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    public V1ListMeta selfLink(String selfLink) {
        this.selfLink = selfLink;
        return this;
    }

    @ApiModelProperty(value="selfLink is a URL representing this object. Populated by the system. Read-only.")
    public String getSelfLink() {
        return this.selfLink;
    }

    public void setSelfLink(String selfLink) {
        this.selfLink = selfLink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ListMeta v1ListMeta = (V1ListMeta)o;
        return Objects.equals(this._continue, v1ListMeta._continue) && Objects.equals(this.resourceVersion, v1ListMeta.resourceVersion) && Objects.equals(this.selfLink, v1ListMeta.selfLink);
    }

    public int hashCode() {
        return Objects.hash(this._continue, this.resourceVersion, this.selfLink);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ListMeta {\n");
        sb.append("    _continue: ").append(this.toIndentedString(this._continue)).append("\n");
        sb.append("    resourceVersion: ").append(this.toIndentedString(this.resourceVersion)).append("\n");
        sb.append("    selfLink: ").append(this.toIndentedString(this.selfLink)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

