/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.rpc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.submarine.client.cli.param.Localization;
import org.apache.submarine.client.cli.param.ParametersHolder;
import org.apache.submarine.client.cli.param.Quicklink;
import org.apache.submarine.client.cli.param.ShowJobParameters;
import org.apache.submarine.client.cli.param.runjob.PyTorchRunJobParameters;
import org.apache.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.submarine.client.cli.param.runjob.TensorFlowRunJobParameters;
import org.apache.submarine.client.cli.remote.RpcContext;
import org.apache.submarine.client.cli.runjob.RoleParameters;
import org.apache.submarine.commons.rpc.ApplicationIdProto;
import org.apache.submarine.commons.rpc.CommandLineProto;
import org.apache.submarine.commons.rpc.ListOfString;
import org.apache.submarine.commons.rpc.LocalizationProto;
import org.apache.submarine.commons.rpc.OptionProto;
import org.apache.submarine.commons.rpc.ParameterProto;
import org.apache.submarine.commons.rpc.PyTorchRunJobParameterProto;
import org.apache.submarine.commons.rpc.QuicklinkProto;
import org.apache.submarine.commons.rpc.ResourceProto;
import org.apache.submarine.commons.rpc.RoleParameterProto;
import org.apache.submarine.commons.rpc.RunParameterProto;
import org.apache.submarine.commons.rpc.ShowJobParameterProto;
import org.apache.submarine.commons.rpc.TensorFlowRunJobParameterProto;
import org.apache.submarine.commons.runtime.Framework;
import org.apache.submarine.commons.runtime.api.PyTorchRole;
import org.apache.submarine.commons.runtime.api.TensorFlowRole;
import org.apache.submarine.commons.runtime.param.BaseParameters;
import org.apache.submarine.commons.runtime.param.Parameter;
import org.apache.submarine.commons.runtime.resource.ResourceUtils;
import org.apache.submarine.shaded.rpc.com.google.protobuf.ProtocolStringList;

public class SubmarineRpcServerProto {
    public static Parameter convertParameterProtoToParameter(ParameterProto parameterProto) {
        Parameter parameter = null;
        if (parameterProto.hasPytorchRunJobParameter()) {
            parameter = SubmarineRpcServerProto.convertParameterProtoToPyTorchRunJob(parameterProto);
        } else if (parameterProto.hasTensorflowRunJobParameter()) {
            parameter = SubmarineRpcServerProto.convertParameterProtoToTensorFlowRunJob(parameterProto);
        } else if (parameterProto.hasShowJobParameter()) {
            parameter = SubmarineRpcServerProto.convertParameterProtoToShowJob(parameterProto);
        }
        SubmarineRpcServerProto.setCommandLineYamlConfigIfNeeded(parameter, parameterProto);
        return parameter;
    }

    public static void setCommandLineYamlConfigIfNeeded(Parameter parameter, ParameterProto parameterProto) {
        if (parameter instanceof ParametersHolder) {
            ParametersHolder parametersHolder = (ParametersHolder)parameter;
            CommandLine commandLine = SubmarineRpcServerProto.convertCommandLineProtoToCommandLine(parameterProto.getCommandLine());
            parametersHolder.setParsedCommandLine(commandLine);
            parametersHolder.setYamlStringConfigs(parameterProto.getYamlStringConfigsMap());
            parametersHolder.setYamlListConfigs(SubmarineRpcServerProto.covertYamlListConfigs(parameterProto.getYamlListConfigsMap()));
        }
    }

    public static Map<String, List<String>> covertYamlListConfigs(Map<String, ListOfString> yamlListConfigs) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry<String, ListOfString> entry : yamlListConfigs.entrySet()) {
            ProtocolStringList value = entry.getValue().getValuesList();
            map.put(entry.getKey(), (List<String>)value);
        }
        return map;
    }

    public static CommandLine convertCommandLineProtoToCommandLine(CommandLineProto commandLineProto) {
        CommandLine commandLine;
        Class<CommandLine> clz = CommandLine.class;
        try {
            Constructor c = clz.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            commandLine = (CommandLine)c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        for (OptionProto optionProto : commandLineProto.getOptionsList()) {
            Option option = new Option(optionProto.getOpt(), "");
            try {
                Class<Option> optionClass = Option.class;
                Method add = optionClass.getDeclaredMethod("add", String.class);
                add.setAccessible(true);
                for (String value : optionProto.getValuesList()) {
                    add.invoke((Object)option, value);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e.getCause());
            }
            try {
                Method getOption = clz.getDeclaredMethod("addOption", Option.class);
                getOption.setAccessible(true);
                getOption.invoke((Object)commandLine, option);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return commandLine;
    }

    public static Parameter convertParameterProtoToPyTorchRunJob(ParameterProto parameterProto) {
        Framework framework = Framework.parseByValue((String)parameterProto.getFramework());
        PyTorchRunJobParameterProto pyTorchRunJobParameterProto = parameterProto.getPytorchRunJobParameter();
        PyTorchRunJobParameters runJobParameters = new PyTorchRunJobParameters();
        Parameter parameter = SubmarineRpcServerProto.convertRunParametersProtoToParameter((RunJobParameters)runJobParameters, pyTorchRunJobParameterProto.getRunParameterProto(), framework);
        return parameter;
    }

    public static Parameter convertParameterProtoToTensorFlowRunJob(ParameterProto parameterProto) {
        TensorFlowRunJobParameterProto tensorFlowRunJobParameterProto = parameterProto.getTensorflowRunJobParameter();
        Framework framework = Framework.parseByValue((String)parameterProto.getFramework());
        TensorFlowRunJobParameters runJobParameters = new TensorFlowRunJobParameters();
        runJobParameters.setTensorboardEnabled(tensorFlowRunJobParameterProto.getTensorboardEnabled());
        runJobParameters.setPsParameters(SubmarineRpcServerProto.convertRoleParameterProtoToRoleParameters(tensorFlowRunJobParameterProto.getPsParameter(), framework));
        runJobParameters.setTensorBoardParameters(SubmarineRpcServerProto.convertRoleParameterProtoToRoleParameters(tensorFlowRunJobParameterProto.getTensorBoardParameter(), framework));
        Parameter parameter = SubmarineRpcServerProto.convertRunParametersProtoToParameter((RunJobParameters)runJobParameters, tensorFlowRunJobParameterProto.getRunParameterProto(), framework);
        parameter.setFramework(framework);
        return parameter;
    }

    public static Parameter convertParameterProtoToShowJob(ParameterProto parameterProto) {
        Framework framework = Framework.parseByValue((String)parameterProto.getFramework());
        ShowJobParameterProto showJobParameterProto = parameterProto.getShowJobParameter();
        ShowJobParameters showJobParameters = new ShowJobParameters();
        showJobParameters.setName(showJobParameterProto.getName());
        ParametersHolder parameter = ParametersHolder.create();
        parameter.setParameters((BaseParameters)showJobParameters);
        parameter.setFramework(framework);
        return parameter;
    }

    public static RpcContext convertParameterProtoToRpcContext(ParameterProto parameterProto) {
        RpcContext rpcContext = new RpcContext();
        if (parameterProto.getSubmarineJobConfigMapMap() != null) {
            rpcContext.setSubmarineJobConfigMap(parameterProto.getSubmarineJobConfigMapMap());
        }
        return rpcContext;
    }

    public static Parameter convertRunParametersProtoToParameter(RunJobParameters runJobParameters, RunParameterProto runJobParameterProto, Framework framework) {
        if (StringUtils.isNotBlank((CharSequence)runJobParameterProto.getCheckpointPath())) {
            runJobParameters.setCheckpointPath(runJobParameterProto.getCheckpointPath());
        }
        if (StringUtils.isNotBlank((CharSequence)runJobParameterProto.getDockerImageName())) {
            runJobParameters.setDockerImageName(runJobParameterProto.getDockerImageName());
        }
        if (StringUtils.isNotBlank((CharSequence)runJobParameterProto.getInput())) {
            runJobParameters.setInputPath(runJobParameterProto.getInput());
        }
        if (StringUtils.isNotBlank((CharSequence)runJobParameterProto.getKeytab())) {
            runJobParameters.setKeytab(runJobParameterProto.getKeytab());
        }
        if (StringUtils.isNotBlank((CharSequence)runJobParameterProto.getName())) {
            runJobParameters.setName(runJobParameterProto.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)runJobParameterProto.getPrincipal())) {
            runJobParameters.setPrincipal(runJobParameterProto.getPrincipal());
        }
        if (StringUtils.isNotBlank((CharSequence)runJobParameterProto.getQueue())) {
            runJobParameters.setQueue(runJobParameterProto.getQueue());
        }
        if (StringUtils.isNotBlank((CharSequence)runJobParameterProto.getSavedModelPath())) {
            runJobParameters.setSavedModelPath(runJobParameterProto.getSavedModelPath());
        }
        runJobParameters.setConfPairs((List)runJobParameterProto.getConfPairsList()).setDistributed(runJobParameterProto.getDistributed()).setDistributeKeytab(runJobParameterProto.getDistributeKeytab()).setLocalizations(SubmarineRpcServerProto.convertLocalizationProtoToLocalization(runJobParameterProto.getLocalizationsList())).setQuicklinks(SubmarineRpcServerProto.convertQuicklinkProtoToQuicklink(runJobParameterProto.getQuicklinksList())).setSecurityDisabled(runJobParameterProto.getSecurityDisabled()).setWaitJobFinish(runJobParameterProto.getWaitJobFinish()).setWorkerParameter(SubmarineRpcServerProto.convertRoleParameterProtoToRoleParameters(runJobParameterProto.getWorkerParameter(), framework));
        runJobParameters.setEnvars((List)runJobParameterProto.getEnvarsList());
        ParametersHolder parameter = ParametersHolder.create();
        parameter.setParameters((BaseParameters)runJobParameters);
        parameter.setFramework(framework);
        return parameter;
    }

    public static RoleParameters convertRoleParameterProtoToRoleParameters(RoleParameterProto roleParameterProto, Framework framework) {
        TensorFlowRole role = null;
        switch (framework) {
            case TENSORFLOW: {
                role = TensorFlowRole.valueOf((String)roleParameterProto.getRole());
                break;
            }
            case PYTORCH: {
                role = PyTorchRole.valueOf((String)roleParameterProto.getRole());
            }
        }
        RoleParameters roleParameters = RoleParameters.createEmpty(role);
        if (StringUtils.isNotBlank((CharSequence)roleParameterProto.getDockerImage())) {
            roleParameters.setDockerImage(roleParameterProto.getDockerImage());
        }
        if (StringUtils.isNotBlank((CharSequence)roleParameterProto.getLaunchCommand())) {
            roleParameters.setLaunchCommand(roleParameterProto.getLaunchCommand());
        }
        roleParameters.setReplicas(roleParameterProto.getReplicas()).setResource(SubmarineRpcServerProto.convertResourceProtoToResource(roleParameterProto.getResourceProto()));
        return roleParameters;
    }

    public static List<Localization> convertLocalizationProtoToLocalization(List<LocalizationProto> localizationsList) {
        ArrayList<Localization> localizations = new ArrayList<Localization>();
        for (LocalizationProto localizationProto : localizationsList) {
            Localization localization = new Localization();
            localization.setLocalPath(localizationProto.getLocalPath()).setMountPermission(localizationProto.getMountPermission()).setRemoteUri(localizationProto.getRemoteUri());
            localizations.add(localization);
        }
        return localizations;
    }

    public static List<Quicklink> convertQuicklinkProtoToQuicklink(List<QuicklinkProto> quicklinksList) {
        ArrayList<Quicklink> quicklinks = new ArrayList<Quicklink>();
        for (QuicklinkProto quicklinkProto : quicklinksList) {
            Quicklink quicklink = new Quicklink();
            quicklink.setLabel(quicklinkProto.getLabel()).setComponentInstanceName(quicklinkProto.getComponentInstanceName()).setProtocol(quicklinkProto.getProtocol()).setPort(quicklinkProto.getPort());
            quicklinks.add(quicklink);
        }
        return quicklinks;
    }

    public static Resource convertResourceProtoToResource(ResourceProto resourceProto) {
        Resource resource = ResourceUtils.createResource((Map)resourceProto.getResourceMapMap());
        return resource;
    }

    public ParameterProto convertShowJobToParameterProto(Parameter parameters) {
        ShowJobParameterProto showJobproto = ShowJobParameterProto.newBuilder().setName(parameters.getParameters().getName()).build();
        ParameterProto parameterProto = ParameterProto.newBuilder().setShowJobParameter(showJobproto).setFramework(parameters.getFramework().getValue()).build();
        return parameterProto;
    }

    public static ApplicationIdProto convertApplicationIdToApplicationIdProto(ApplicationId applicationId) {
        String application = applicationId != null ? applicationId.toString() : "";
        ApplicationIdProto applicationIdProto = ApplicationIdProto.newBuilder().setApplicationId(application).build();
        return applicationIdProto;
    }
}

