/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassInfo;
import io.github.classgraph.HierarchicalTypeSignature;
import io.github.classgraph.ReferenceTypeSignature;
import io.github.classgraph.ScanResult;
import io.github.classgraph.utils.Parser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class TypeArgument
extends HierarchicalTypeSignature {
    private final Wildcard wildcard;
    private final ReferenceTypeSignature typeSignature;

    private TypeArgument(Wildcard wildcard, ReferenceTypeSignature typeSignature) {
        this.wildcard = wildcard;
        this.typeSignature = typeSignature;
    }

    public Wildcard getWildcard() {
        return this.wildcard;
    }

    public ReferenceTypeSignature getTypeSignature() {
        return this.typeSignature;
    }

    private static TypeArgument parse(Parser parser, String definingClassName) throws Parser.ParseException {
        char peek = parser.peek();
        if (peek == '*') {
            parser.expect('*');
            return new TypeArgument(Wildcard.ANY, null);
        }
        if (peek == '+') {
            parser.expect('+');
            ReferenceTypeSignature typeSignature = ReferenceTypeSignature.parseReferenceTypeSignature(parser, definingClassName);
            if (typeSignature == null) {
                throw new Parser.ParseException(parser, "Missing '+' type bound");
            }
            return new TypeArgument(Wildcard.EXTENDS, typeSignature);
        }
        if (peek == '-') {
            parser.expect('-');
            ReferenceTypeSignature typeSignature = ReferenceTypeSignature.parseReferenceTypeSignature(parser, definingClassName);
            if (typeSignature == null) {
                throw new Parser.ParseException(parser, "Missing '-' type bound");
            }
            return new TypeArgument(Wildcard.SUPER, typeSignature);
        }
        ReferenceTypeSignature typeSignature = ReferenceTypeSignature.parseReferenceTypeSignature(parser, definingClassName);
        if (typeSignature == null) {
            throw new Parser.ParseException(parser, "Missing type bound");
        }
        return new TypeArgument(Wildcard.NONE, typeSignature);
    }

    static List<TypeArgument> parseList(Parser parser, String definingClassName) throws Parser.ParseException {
        if (parser.peek() == '<') {
            parser.expect('<');
            ArrayList<TypeArgument> typeArguments = new ArrayList<TypeArgument>(2);
            while (parser.peek() != '>') {
                if (!parser.hasMore()) {
                    throw new Parser.ParseException(parser, "Missing '>'");
                }
                typeArguments.add(TypeArgument.parse(parser, definingClassName));
            }
            parser.expect('>');
            return typeArguments;
        }
        return Collections.emptyList();
    }

    @Override
    protected String getClassName() {
        throw new IllegalArgumentException("getClassName() cannot be called here");
    }

    @Override
    protected ClassInfo getClassInfo() {
        throw new IllegalArgumentException("getClassInfo() cannot be called here");
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        super.setScanResult(scanResult);
        if (this.typeSignature != null) {
            this.typeSignature.setScanResult(scanResult);
        }
    }

    @Override
    void getClassNamesFromTypeDescriptors(Set<String> classNameListOut) {
        if (this.typeSignature != null) {
            this.typeSignature.getClassNamesFromTypeDescriptors(classNameListOut);
        }
    }

    public int hashCode() {
        return this.typeSignature.hashCode() + 7 * this.wildcard.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TypeArgument)) {
            return false;
        }
        TypeArgument o = (TypeArgument)obj;
        return o.typeSignature.equals(this.typeSignature) && o.wildcard.equals((Object)this.wildcard);
    }

    public String toString() {
        String typeSigStr = this.typeSignature == null ? null : this.typeSignature.toString();
        switch (this.wildcard) {
            case ANY: {
                return "?";
            }
            case EXTENDS: {
                return typeSigStr.equals("java.lang.Object") ? "?" : "? extends " + typeSigStr;
            }
            case SUPER: {
                return "? super " + typeSigStr;
            }
            case NONE: {
                return typeSigStr;
            }
        }
        throw new RuntimeException("Unknown wildcard type");
    }

    public static enum Wildcard {
        NONE,
        ANY,
        EXTENDS,
        SUPER;

    }
}

