/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.util.Set;

abstract class ScanResultObject {
    protected transient ScanResult scanResult;
    private transient ClassInfo classInfo;
    private transient Class<?> classRef;

    ScanResultObject() {
    }

    void setScanResult(ScanResult scanResult) {
        this.scanResult = scanResult;
    }

    abstract void getClassNamesFromTypeDescriptors(Set<String> var1);

    protected abstract String getClassName();

    ClassInfo getClassInfo() {
        if (this.classInfo == null) {
            if (this.scanResult == null) {
                return null;
            }
            String className = this.getClassName();
            if (className == null) {
                throw new IllegalArgumentException("Class name is not set");
            }
            this.classInfo = this.scanResult.getClassInfo(className);
        }
        return this.classInfo;
    }

    <T> Class<T> loadClass(Class<T> superclassOrInterfaceType, boolean ignoreExceptions) {
        if (this.classRef == null) {
            ClassInfo classInfo = this.getClassInfo();
            String className = classInfo != null ? classInfo.getName() : this.getClassName();
            if (className == null) {
                throw new IllegalArgumentException("Class name is not set");
            }
            this.classRef = this.scanResult.loadClass(className, superclassOrInterfaceType, ignoreExceptions);
        }
        Class<?> classT = this.classRef;
        return classT;
    }

    <T> Class<T> loadClass(Class<T> superclassOrInterfaceType) {
        return this.loadClass(superclassOrInterfaceType, false);
    }

    Class<?> loadClass(boolean ignoreExceptions) {
        if (this.classRef == null) {
            ClassInfo classInfo = this.getClassInfo();
            String className = classInfo != null ? classInfo.getName() : this.getClassName();
            if (className == null) {
                throw new IllegalArgumentException("Class name is not set");
            }
            this.classRef = this.scanResult.loadClass(className, ignoreExceptions);
        }
        return this.classRef;
    }

    Class<?> loadClass() {
        return this.loadClass(false);
    }
}

