/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResourceList
extends ArrayList<Resource>
implements AutoCloseable {
    ResourceList() {
    }

    ResourceList(int sizeHint) {
        super(sizeHint);
    }

    ResourceList(Collection<Resource> collection) {
        super(collection);
    }

    public List<String> getPaths() {
        ArrayList<String> resourcePaths = new ArrayList<String>(this.size());
        for (Resource resource : this) {
            resourcePaths.add(resource.getPath());
        }
        return resourcePaths;
    }

    public List<String> getPathsRelativeToClasspathElement() {
        ArrayList<String> resourcePaths = new ArrayList<String>(this.size());
        for (Resource resource : this) {
            resourcePaths.add(resource.getPath());
        }
        return resourcePaths;
    }

    public List<URL> getURLs() {
        ArrayList<URL> resourceURLs = new ArrayList<URL>(this.size());
        for (Resource resource : this) {
            resourceURLs.add(resource.getURL());
        }
        return resourceURLs;
    }

    public ResourceList filter(ResourceFilter filter) {
        ResourceList resourcesFiltered = new ResourceList();
        for (Resource resource : this) {
            if (!filter.accept(resource)) continue;
            resourcesFiltered.add(resource);
        }
        return resourcesFiltered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachByteArray(ByteArrayConsumer byteArrayConsumer, boolean ignoreIOExceptions) {
        for (Resource resource : this) {
            try {
                byte[] resourceContent = resource.load();
                byteArrayConsumer.accept(resource, resourceContent);
            }
            catch (IOException e) {
                if (ignoreIOExceptions) continue;
                throw new IllegalArgumentException("Could not load resource " + resource, e);
            }
            finally {
                resource.close();
            }
        }
    }

    public void forEachByteArray(ByteArrayConsumer byteArrayConsumer) {
        this.forEachByteArray(byteArrayConsumer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachInputStream(InputStreamConsumer inputStreamConsumer, boolean ignoreIOExceptions) {
        for (Resource resource : this) {
            try {
                inputStreamConsumer.accept(resource, resource.open());
            }
            catch (IOException e) {
                if (ignoreIOExceptions) continue;
                throw new IllegalArgumentException("Could not load resource " + resource, e);
            }
            finally {
                resource.close();
            }
        }
    }

    public void forEachInputStream(InputStreamConsumer inputStreamConsumer) {
        this.forEachInputStream(inputStreamConsumer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachByteBuffer(ByteBufferConsumer byteBufferConsumer, boolean ignoreIOExceptions) {
        for (Resource resource : this) {
            try {
                ByteBuffer byteBuffer = resource.read();
                byteBufferConsumer.accept(resource, byteBuffer);
            }
            catch (IOException e) {
                if (ignoreIOExceptions) continue;
                throw new IllegalArgumentException("Could not load resource " + resource, e);
            }
            finally {
                resource.close();
            }
        }
    }

    public void forEachByteBuffer(ByteBufferConsumer byteBufferConsumer) {
        this.forEachByteBuffer(byteBufferConsumer, false);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.get(i));
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public void close() {
        for (Resource resource : this) {
            try {
                resource.close();
            }
            catch (Exception exception) {}
        }
    }

    @FunctionalInterface
    public static interface ByteBufferConsumer {
        public void accept(Resource var1, ByteBuffer var2);
    }

    @FunctionalInterface
    public static interface InputStreamConsumer {
        public void accept(Resource var1, InputStream var2);
    }

    @FunctionalInterface
    public static interface ByteArrayConsumer {
        public void accept(Resource var1, byte[] var2);
    }

    @FunctionalInterface
    public static interface ResourceFilter {
        public boolean accept(Resource var1);
    }
}

