/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.persist;

import co.cask.tephra.ChangeId;
import co.cask.tephra.TransactionManager;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public class TransactionSnapshot {
    private long timestamp;
    private long readPointer;
    private long writePointer;
    private Collection<Long> invalid;
    private NavigableMap<Long, TransactionManager.InProgressTx> inProgress;
    private Map<Long, Set<ChangeId>> committingChangeSets;
    private Map<Long, Set<ChangeId>> committedChangeSets;

    public TransactionSnapshot(long timestamp, long readPointer, long writePointer, Collection<Long> invalid, NavigableMap<Long, TransactionManager.InProgressTx> inProgress, Map<Long, Set<ChangeId>> committing, Map<Long, Set<ChangeId>> committed) {
        this.timestamp = timestamp;
        this.readPointer = readPointer;
        this.writePointer = writePointer;
        this.invalid = invalid;
        this.inProgress = inProgress;
        this.committingChangeSets = committing;
        this.committedChangeSets = committed;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getReadPointer() {
        return this.readPointer;
    }

    public long getWritePointer() {
        return this.writePointer;
    }

    public Collection<Long> getInvalid() {
        return this.invalid;
    }

    public Map<Long, TransactionManager.InProgressTx> getInProgress() {
        return this.inProgress;
    }

    public Map<Long, Set<ChangeId>> getCommittingChangeSets() {
        return this.committingChangeSets;
    }

    public Map<Long, Set<ChangeId>> getCommittedChangeSets() {
        return this.committedChangeSets;
    }

    public long getVisibilityUpperBound() {
        Map.Entry<Long, TransactionManager.InProgressTx> firstInProgress = this.inProgress.firstEntry();
        if (firstInProgress == null) {
            return this.readPointer;
        }
        return firstInProgress.getValue().getVisibilityUpperBound();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TransactionSnapshot)) {
            return false;
        }
        TransactionSnapshot other = (TransactionSnapshot)obj;
        return this.readPointer == other.readPointer && this.writePointer == other.writePointer && this.invalid.equals(other.invalid) && this.inProgress.equals(other.inProgress) && this.committingChangeSets.equals(other.committingChangeSets) && this.committedChangeSets.equals(other.committedChangeSets);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("timestamp", this.timestamp).add("readPointer", this.readPointer).add("writePointer", this.writePointer).add("invalidSize", this.invalid.size()).add("inProgressSize", this.inProgress.size()).add("committingSize", this.committingChangeSets.size()).add("committedSize", this.committedChangeSets.size()).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.readPointer, this.writePointer, this.invalid, this.inProgress, this.committingChangeSets, this.committedChangeSets});
    }

    public static TransactionSnapshot copyFrom(long snapshotTime, long readPointer, long writePointer, Collection<Long> invalid, NavigableMap<Long, TransactionManager.InProgressTx> inProgress, Map<Long, Set<ChangeId>> committing, NavigableMap<Long, Set<ChangeId>> committed) {
        ArrayList invalidCopy = Lists.newArrayList(invalid);
        TreeMap inProgressCopy = Maps.newTreeMap(inProgress);
        HashMap committingCopy = Maps.newHashMap();
        for (Map.Entry<Long, Set<ChangeId>> entry : committing.entrySet()) {
            committingCopy.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        TreeMap<Long, Set<ChangeId>> committedCopy = new TreeMap<Long, Set<ChangeId>>();
        for (Map.Entry entry : committed.entrySet()) {
            committedCopy.put((Long)entry.getKey(), new HashSet((Collection)entry.getValue()));
        }
        return new TransactionSnapshot(snapshotTime, readPointer, writePointer, invalidCopy, inProgressCopy, committingCopy, committedCopy);
    }
}

