/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl;

import com.opensymphony.xwork2.util.ProxyUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ognl.MemberAccess;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SecurityMemberAccess
implements MemberAccess {
    private static final Logger LOG = LogManager.getLogger(SecurityMemberAccess.class);
    private final boolean allowStaticFieldAccess;
    private Set<Pattern> excludeProperties = Collections.emptySet();
    private Set<Pattern> acceptProperties = Collections.emptySet();
    private Set<Class<?>> excludedClasses = Collections.emptySet();
    private Set<Pattern> excludedPackageNamePatterns = Collections.emptySet();
    private Set<String> excludedPackageNames = Collections.emptySet();
    private Set<Class<?>> excludedPackageExemptClasses = Collections.emptySet();
    private boolean disallowProxyMemberAccess;

    public SecurityMemberAccess(boolean allowStaticFieldAccess) {
        this.allowStaticFieldAccess = allowStaticFieldAccess;
    }

    public Object setup(Map context, Object target, Member member, String propertyName) {
        AccessibleObject accessible;
        Boolean result = null;
        if (this.isAccessible(context, target, member, propertyName) && !(accessible = (AccessibleObject)((Object)member)).isAccessible()) {
            result = Boolean.FALSE;
            accessible.setAccessible(true);
        }
        return result;
    }

    public void restore(Map context, Object target, Member member, String propertyName, Object state) {
        if (state != null) {
            AccessibleObject accessible = (AccessibleObject)((Object)member);
            boolean stateBoolean = (Boolean)state;
            if (!stateBoolean) {
                accessible.setAccessible(stateBoolean);
            } else {
                throw new IllegalArgumentException("Improper restore state [" + stateBoolean + "] for target [" + target + "], member [" + member + "], propertyName [" + propertyName + "]");
            }
        }
    }

    public boolean isAccessible(Map context, Object target, Member member, String propertyName) {
        Class<?> targetClass;
        LOG.debug("Checking access for [target: {}, member: {}, property: {}]", target, (Object)member, (Object)propertyName);
        int memberModifiers = member.getModifiers();
        Class<?> memberClass = member.getDeclaringClass();
        Class<?> clazz = targetClass = Modifier.isStatic(memberModifiers) ? memberClass : target.getClass();
        if (!memberClass.isAssignableFrom(targetClass)) {
            throw new IllegalArgumentException("Target does not match member!");
        }
        if (!this.checkPublicMemberAccess(memberModifiers)) {
            LOG.warn("Access to non-public [{}] is blocked!", (Object)member);
            return false;
        }
        if (!this.checkStaticFieldAccess(member, memberModifiers)) {
            LOG.warn("Access to static field [{}] is blocked!", (Object)member);
            return false;
        }
        if (this.checkEnumAccess(target, member)) {
            LOG.trace("Allowing access to enum: target [{}], member [{}]", target, (Object)member);
            return true;
        }
        if (!this.checkStaticMethodAccess(member, memberModifiers)) {
            LOG.warn("Access to static method [{}] is blocked!", (Object)member);
            return false;
        }
        if (this.isClassExcluded(memberClass)) {
            LOG.warn("Declaring class of member type [{}] is excluded!", (Object)member);
            return false;
        }
        if (targetClass != memberClass && this.isClassExcluded(targetClass)) {
            LOG.warn("Target class [{}] of target [{}] is excluded!", targetClass, target);
            return false;
        }
        if (targetClass.getPackage() == null || memberClass.getPackage() == null) {
            LOG.warn("The use of the default (unnamed) package is discouraged!");
        }
        if (this.isPackageExcluded(targetClass, memberClass)) {
            LOG.warn("Package [{}] of target class [{}] of target [{}] or package [{}] of member [{}] are excluded!", (Object)targetClass.getPackage(), targetClass, target, (Object)memberClass.getPackage(), (Object)member);
            return false;
        }
        if (this.disallowProxyMemberAccess && ProxyUtil.isProxyMember(member, target)) {
            LOG.warn("Access to proxy is blocked! Target class [{}] of target [{}], member [{}]", targetClass, target, (Object)member);
            return false;
        }
        return this.isAcceptableProperty(propertyName);
    }

    protected boolean checkStaticMethodAccess(Member member, int memberModifiers) {
        return !Modifier.isStatic(memberModifiers) || member instanceof Field;
    }

    protected boolean checkStaticFieldAccess(Member member, int memberModifiers) {
        if (Modifier.isStatic(memberModifiers) && member instanceof Field) {
            return this.allowStaticFieldAccess;
        }
        return true;
    }

    protected boolean checkPublicMemberAccess(int memberModifiers) {
        return Modifier.isPublic(memberModifiers);
    }

    protected boolean checkEnumAccess(Object target, Member member) {
        if (target instanceof Class) {
            Class clazz = (Class)target;
            return Enum.class.isAssignableFrom(clazz) && member.getName().equals("values");
        }
        return false;
    }

    protected boolean isPackageExcluded(Class<?> targetClass, Class<?> memberClass) {
        if (targetClass == null || memberClass == null) {
            throw new IllegalArgumentException("Parameters should never be null - if member is static, targetClass should be the same as memberClass.");
        }
        HashSet classesToCheck = new HashSet();
        classesToCheck.add(targetClass);
        classesToCheck.add(memberClass);
        for (Class clazz : classesToCheck) {
            if (this.isExcludedPackageExempt(clazz) || !this.isExcludedPackageNamePatterns(clazz) && !this.isExcludedPackageNames(clazz)) continue;
            return true;
        }
        return false;
    }

    protected String toPackageName(Class<?> clazz) {
        if (clazz.getPackage() == null) {
            return "";
        }
        return clazz.getPackage().getName();
    }

    protected boolean isExcludedPackageNamePatterns(Class<?> clazz) {
        String packageName = this.toPackageName(clazz);
        for (Pattern pattern : this.excludedPackageNamePatterns) {
            if (!pattern.matcher(packageName).matches()) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcludedPackageNames(Class<?> clazz) {
        String suffixedPackageName = this.toPackageName(clazz) + ".";
        for (String excludedPackageName : this.excludedPackageNames) {
            if (!suffixedPackageName.startsWith(excludedPackageName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isClassExcluded(Class<?> clazz) {
        if (clazz == Object.class || clazz == Class.class && !this.allowStaticFieldAccess) {
            return true;
        }
        return this.excludedClasses.stream().anyMatch(clazz::isAssignableFrom);
    }

    protected boolean isExcludedPackageExempt(Class<?> clazz) {
        return this.excludedPackageExemptClasses.stream().anyMatch(clazz::equals);
    }

    protected boolean isAcceptableProperty(String name) {
        return name == null || !this.isExcluded(name) && this.isAccepted(name);
    }

    protected boolean isAccepted(String paramName) {
        if (!this.acceptProperties.isEmpty()) {
            for (Pattern pattern : this.acceptProperties) {
                Matcher matcher = pattern.matcher(paramName);
                if (!matcher.matches()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean isExcluded(String paramName) {
        if (!this.excludeProperties.isEmpty()) {
            for (Pattern pattern : this.excludeProperties) {
                Matcher matcher = pattern.matcher(paramName);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    public void setExcludeProperties(Set<Pattern> excludeProperties) {
        this.excludeProperties = excludeProperties;
    }

    public void setAcceptProperties(Set<Pattern> acceptedProperties) {
        this.acceptProperties = acceptedProperties;
    }

    public void setExcludedClasses(Set<Class<?>> excludedClasses) {
        this.excludedClasses = excludedClasses;
    }

    public void setExcludedPackageNamePatterns(Set<Pattern> excludedPackageNamePatterns) {
        this.excludedPackageNamePatterns = excludedPackageNamePatterns;
    }

    public void setExcludedPackageNames(Set<String> excludedPackageNames) {
        this.excludedPackageNames = excludedPackageNames;
    }

    public void setExcludedPackageExemptClasses(Set<Class<?>> excludedPackageExemptClasses) {
        this.excludedPackageExemptClasses = excludedPackageExemptClasses;
    }

    public void setDisallowProxyMemberAccess(boolean disallowProxyMemberAccess) {
        this.disallowProxyMemberAccess = disallowProxyMemberAccess;
    }
}

