/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl;

import com.opensymphony.xwork2.ognl.OgnlCache;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class OgnlDefaultCache<Key, Value>
implements OgnlCache<Key, Value> {
    private final ConcurrentHashMap<Key, Value> ognlCache;
    private final AtomicInteger cacheEvictionLimit = new AtomicInteger(25000);

    public OgnlDefaultCache(int evictionLimit, int initialCapacity, float loadFactor) {
        this.cacheEvictionLimit.set(evictionLimit);
        this.ognlCache = new ConcurrentHashMap(initialCapacity, loadFactor);
    }

    @Override
    public Value get(Key key) {
        return this.ognlCache.get(key);
    }

    @Override
    public void put(Key key, Value value) {
        this.ognlCache.put(key, value);
        this.clearIfEvictionLimitExceeded();
    }

    @Override
    public void putIfAbsent(Key key, Value value) {
        this.ognlCache.putIfAbsent(key, value);
        this.clearIfEvictionLimitExceeded();
    }

    @Override
    public int size() {
        return this.ognlCache.size();
    }

    @Override
    public void clear() {
        this.ognlCache.clear();
    }

    @Override
    public int getEvictionLimit() {
        return this.cacheEvictionLimit.get();
    }

    @Override
    public void setEvictionLimit(int cacheEvictionLimit) {
        this.cacheEvictionLimit.set(cacheEvictionLimit);
    }

    private void clearIfEvictionLimitExceeded() {
        if (this.ognlCache.size() > this.cacheEvictionLimit.get()) {
            this.ognlCache.clear();
        }
    }
}

